<?php $__env->startSection('title', 'Support Tickets'); ?>

<?php $__env->startSection('content'); ?>
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h2 class="fw-bold mb-1">Support Tickets</h2>
            <p class="text-muted mb-0">Manage customer support tickets</p>
        </div>
    </div>

    <div class="admin-card">
        <div class="admin-card-header">
            <h5 class="mb-0 fw-bold">All Tickets</h5>
        </div>
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover mb-0">
                    <thead>
                    <tr>
                        <th>Ticket #</th>
                        <th>Subject</th>
                        <th>User</th>
                        <th>Category</th>
                        <th>Priority</th>
                        <th>Status</th>
                        <th>Created</th>
                        <th>Actions</th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $tickets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ticket): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td><code><?php echo e($ticket->ticket_number); ?></code></td>
                            <td><?php echo e($ticket->subject); ?></td>
                            <td><?php echo e($ticket->user->full_name ?? 'N/A'); ?></td>
                            <td><?php echo e(ucfirst($ticket->category)); ?></td>
                            <td>
                            <span class="badge bg-<?php echo e($ticket->priority === 'high' ? 'danger' : ($ticket->priority === 'medium' ? 'warning' : 'info')); ?>">
                                <?php echo e(ucfirst($ticket->priority)); ?>

                            </span>
                            </td>
                            <td>
                            <span class="badge bg-<?php echo e($ticket->status === 'closed' ? 'success' : ($ticket->status === 'open' ? 'primary' : 'secondary')); ?>">
                                <?php echo e(ucfirst($ticket->status)); ?>

                            </span>
                            </td>
                            <td><?php echo e($ticket->created_at->format('M d, Y')); ?></td>
                            <td>
                                <a href="<?php echo e(route('admin.tickets.show', $ticket->id)); ?>" class="btn btn-sm btn-outline-primary">View</a>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="8" class="text-center text-muted py-4">No tickets found</td>
                        </tr>
                    <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
        <?php if(isset($tickets) && $tickets->hasPages()): ?>
            <div class="admin-card-footer">
                <?php echo e($tickets->links()); ?>

            </div>
        <?php endif; ?>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\privasee\resources\views/admin/tickets/index.blade.php ENDPATH**/ ?>