<?php $__env->startSection('title', 'Manage Permissions: ' . $role->display_name); ?>

<?php $__env->startSection('content'); ?>
<div class="admin-header mb-4">
    <div>
        <h2>Manage Permissions: <?php echo e($role->display_name); ?></h2>
        <p class="text-muted mb-0">Assign and manage permissions for this role</p>
    </div>



</div>

<form action="<?php echo e(route('admin.roles.update', $role->id)); ?>" method="POST">
    <?php echo csrf_field(); ?>
    <?php echo method_field('PUT'); ?>

    <div class="row">
        <div class="col-lg-9">
            <!-- Permissions by Group -->
            <?php $__currentLoopData = $permissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $group => $groupPermissions): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="card mb-3">
                <div class="card-header">
                    <h5 class="mb-0">
                        <?php echo e(ucfirst(str_replace('_', ' ', $group))); ?>

                        <span class="badge bg-secondary float-end"><?php echo e(count($groupPermissions)); ?> permissions</span>
                    </h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <?php $__currentLoopData = $groupPermissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $permission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-md-6 mb-3">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="perm_<?php echo e($permission->id); ?>"
                                    name="permissions[]" value="<?php echo e($permission->id); ?>"
                                    <?php echo e(in_array($permission->id, $rolePermissions) ? 'checked' : ''); ?>>
                                <label class="form-check-label" for="perm_<?php echo e($permission->id); ?>">
                                    <?php echo e($permission->display_name); ?>

                                    <?php if($permission->description): ?>
                                        <small class="d-block text-muted"><?php echo e($permission->description); ?></small>
                                    <?php endif; ?>
                                </label>
                            </div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            <div class="mt-4">
                <button type="submit" class="btn btn-primary">
                    <i class="bi bi-check-circle"></i> Save Permissions
                </button>
                <a href="<?php echo e(route('admin.roles.show', $role->id)); ?>" class="btn btn-secondary">
                    <i class="bi bi-x-circle"></i> Cancel
                </a>
            </div>
        </div>

        <div class="col-lg-3">
            <div class="card">
                <div class="card-header bg-light">
                    <h6 class="mb-0">Role Summary</h6>
                </div>
                <div class="card-body">
                    <dl class="row mb-0">
                        <dt class="col-sm-5">Name:</dt>
                        <dd class="col-sm-7"><strong><?php echo e($role->display_name); ?></strong></dd>

                        <dt class="col-sm-5">Type:</dt>
                        <dd class="col-sm-7">
                            <span class="badge bg-<?php echo e($role->type === 'admin' ? 'primary' : 'success'); ?>">
                                <?php echo e(ucfirst($role->type)); ?>

                            </span>
                        </dd>

                        <dt class="col-sm-5">System:</dt>
                        <dd class="col-sm-7">
                            <?php if($role->is_system): ?>
                                <i class="bi bi-check-circle text-success"></i> Yes
                            <?php else: ?>
                                <i class="bi bi-x-circle text-danger"></i> No
                            <?php endif; ?>
                        </dd>

                        <dt class="col-sm-5">Permissions:</dt>
                        <dd class="col-sm-7"><?php echo e(count($rolePermissions)); ?> assigned</dd>

                        <dt class="col-sm-5">Users:</dt>
                        <dd class="col-sm-7"><?php echo e($role->users()->count()); ?> users</dd>
                    </dl>
                </div>
            </div>

            <div class="card mt-3">
                <div class="card-body text-center">
                    <button type="button" class="btn btn-sm btn-outline-secondary w-100" onclick="selectAll()">
                        <i class="bi bi-check-all"></i> Select All
                    </button>
                    <button type="button" class="btn btn-sm btn-outline-secondary w-100 mt-2" onclick="deselectAll()">
                        <i class="bi bi-x"></i> Deselect All
                    </button>
                </div>
            </div>
        </div>
    </div>
</form>

<script>
function selectAll() {
    document.querySelectorAll('input[name="permissions[]"]').forEach(checkbox => {
        checkbox.checked = true;
    });
}

function deselectAll() {
    document.querySelectorAll('input[name="permissions[]"]').forEach(checkbox => {
        checkbox.checked = false;
    });
}
</script>

<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\privasee\resources\views/admin/roles/manage-permissions.blade.php ENDPATH**/ ?>