<?php $__env->startSection('title', 'Admin Dashboard'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <!-- Welcome Section -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="card bg-primary text-white">
                <div class="card-body py-4">
                    <h4 class="mb-1">
                        <i class="fas fa-chart-line"></i>
                        Welcome back, <?php echo e(auth()->user()->first_name); ?>!
                    </h4>
                    <p class="mb-0"><?php echo e(auth()->user()->hasRole('super_admin') ? 'Super Administrator' : (auth()->user()->hasRole('admin') ? 'Administrator' : 'Manager')); ?></p>
                </div>
            </div>
        </div>
    </div>

    <!-- Key Statistics -->
    <div class="row mb-4">
        <div class="col-md-3">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-start">
                        <div>
                            <p class="text-muted mb-1">Total Users</p>
                            <h3 class="mb-0"><?php echo e($stats['total_users'] ?? 0); ?></h3>
                            <small class="text-success">
                                <i class="fas fa-arrow-up"></i>
                                <?php echo e($stats['new_this_month'] ?? 0); ?> new this month
                            </small>
                        </div>
                        <div class="text-primary" style="font-size: 2.5rem;">
                            <i class="fas fa-users"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-3">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-start">
                        <div>
                            <p class="text-muted mb-1">Active Users</p>
                            <h3 class="mb-0"><?php echo e($stats['active_users'] ?? 0); ?></h3>
                            <small class="text-info">
                                <?php
                                    $percentage = $stats['total_users'] > 0
                                        ? round(($stats['active_users'] / $stats['total_users']) * 100)
                                        : 0;
                                ?>
                                <?php echo e($percentage); ?>% of total
                            </small>
                        </div>
                        <div class="text-info" style="font-size: 2.5rem;">
                            <i class="fas fa-user-check"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-3">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-start">
                        <div>
                            <p class="text-muted mb-1">Active Sessions</p>
                            <h3 class="mb-0"><?php echo e($stats['active_sessions'] ?? 0); ?></h3>
                            <small class="text-muted">Admin users online</small>
                        </div>
                        <div class="text-success" style="font-size: 2.5rem;">
                            <i class="fas fa-globe"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-3">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-start">
                        <div>
                            <p class="text-muted mb-1">Activities Today</p>
                            <h3 class="mb-0"><?php echo e($stats['today_activities'] ?? 0); ?></h3>
                            <small class="text-warning">
                                <i class="fas fa-info-circle"></i>
                                <?php echo e($stats['security_alerts'] ?? 0); ?> sensitive
                            </small>
                        </div>
                        <div class="text-warning" style="font-size: 2.5rem;">
                            <i class="fas fa-history"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <!-- Recent Activities -->
        <?php if(\App\Helpers\AdminHelper::can('activities.view') && isset($recentActivities) && count($recentActivities) > 0): ?>
        <div class="col-lg-8 mb-4">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">
                        <i class="fas fa-clock"></i>
                        Recent Admin Activities
                    </h5>
                    <a href="<?php echo e(route('admin.activities.index')); ?>" class="btn btn-sm btn-outline-primary">
                        View All
                    </a>
                </div>
                <div class="table-responsive">
                    <table class="table table-hover mb-0">
                        <thead class="table-light">
                            <tr>
                                <th>Time</th>
                                <th>Admin</th>
                                <th>Action</th>
                                <th>Entity</th>
                                <th>Status</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $recentActivities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $activity): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td><small><?php echo e($activity->created_at->format('H:i:s')); ?></small></td>
                                <td>
                                    <small>
                                        <strong><?php echo e($activity->adminUser->first_name ?? 'N/A'); ?></strong>
                                        <br>
                                        <span class="text-muted"><?php echo e($activity->adminUser->email ?? ''); ?></span>
                                    </small>
                                </td>
                                <td>
                                    <span class="badge bg-primary"><?php echo e(ucfirst($activity->action)); ?></span>
                                    <?php if($activity->is_sensitive): ?>
                                        <span class="badge bg-danger">Sensitive</span>
                                    <?php endif; ?>
                                </td>
                                <td><small><?php echo e($activity->entity_type); ?></small></td>
                                <td>
                                    <?php if($activity->status === 'success'): ?>
                                        <span class="badge bg-success">Success</span>
                                    <?php elseif($activity->status === 'failed'): ?>
                                        <span class="badge bg-danger">Failed</span>
                                    <?php else: ?>
                                        <span class="badge bg-warning"><?php echo e(ucfirst($activity->status)); ?></span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="5" class="text-center text-muted py-3">
                                    No activities yet
                                </td>
                            </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        <?php endif; ?>

        <!-- Active Sessions -->
        <?php if(\App\Helpers\AdminHelper::can('sessions.view') && isset($activeSessions) && count($activeSessions) > 0): ?>
        <div class="col-lg-4 mb-4">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">
                        <i class="fas fa-users-cog"></i>
                        Active Admin Sessions
                    </h5>
                    <a href="<?php echo e(route('admin.sessions.index')); ?>" class="btn btn-sm btn-outline-primary">
                        Manage
                    </a>
                </div>
                <div class="list-group list-group-flush">
                    <?php $__empty_1 = true; $__currentLoopData = $activeSessions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $session): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <div class="list-group-item">
                        <div class="d-flex justify-content-between align-items-start">
                            <div>
                                <h6 class="mb-1"><?php echo e($session->user->first_name ?? 'N/A'); ?> <?php echo e($session->user->last_name ?? ''); ?></h6>
                                <small class="text-muted">
                                    <i class="fas fa-globe"></i> <?php echo e($session->ip_address); ?>

                                    <br>
                                    <i class="fas fa-clock"></i> <?php echo e($session->last_activity_at->diffForHumans()); ?>

                                </small>
                            </div>
                            <span class="badge bg-success">Active</span>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <div class="list-group-item text-center text-muted py-3">
                        No active sessions
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        <?php endif; ?>
    </div>

    <!-- Quick Actions -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0">Quick Actions</h5>
                </div>
                <div class="card-body">
                    <div class="row g-2">
                        <?php if(\App\Helpers\AdminHelper::can('users.view')): ?>
                        <div class="col-md-2">
                            <a href="<?php echo e(route('admin.users.index')); ?>" class="btn btn-outline-primary w-100">
                                <i class="fas fa-users"></i>
                                <br>
                                <small>Users</small>
                            </a>
                        </div>
                        <?php endif; ?>

                        <?php if(\App\Helpers\AdminHelper::can('roles.view')): ?>
                        <div class="col-md-2">
                            <a href="<?php echo e(route('admin.roles.index')); ?>" class="btn btn-outline-primary w-100">
                                <i class="fas fa-shield-alt"></i>
                                <br>
                                <small>Roles</small>
                            </a>
                        </div>
                        <?php endif; ?>

                        <?php if(\App\Helpers\AdminHelper::can('activities.view')): ?>
                        <div class="col-md-2">
                            <a href="<?php echo e(route('admin.activities.index')); ?>" class="btn btn-outline-primary w-100">
                                <i class="fas fa-history"></i>
                                <br>
                                <small>Activities</small>
                            </a>
                        </div>
                        <?php endif; ?>

                        <?php if(\App\Helpers\AdminHelper::can('sessions.view')): ?>
                        <div class="col-md-2">
                            <a href="<?php echo e(route('admin.sessions.index')); ?>" class="btn btn-outline-primary w-100">
                                <i class="fas fa-users-cog"></i>
                                <br>
                                <small>Sessions</small>
                            </a>
                        </div>
                        <?php endif; ?>

                        <?php if(\App\Helpers\AdminHelper::can('configurations.view')): ?>
                        <div class="col-md-2">
                            <a href="<?php echo e(route('admin.configurations.index')); ?>" class="btn btn-outline-primary w-100">
                                <i class="fas fa-cog"></i>
                                <br>
                                <small>Configuration</small>
                            </a>
                        </div>
                        <?php endif; ?>

                        <?php if(\App\Helpers\AdminHelper::can('settings.view')): ?>
                        <div class="col-md-2">
                            <a href="<?php echo e(route('admin.settings.index')); ?>" class="btn btn-outline-primary w-100">
                                <i class="fas fa-sliders-h"></i>
                                <br>
                                <small>Settings</small>
                            </a>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\privasee\resources\views/admin/dashboard.blade.php ENDPATH**/ ?>