<?php $__env->startSection('title', 'Marketing & Campaigns'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid py-4">
    <!-- Header -->
    <div class="row mb-4">
        <div class="col-md-8">
            <h1 class="h2 fw-bold mb-0">
                <i class="fas fa-bullhorn me-2"></i>Marketing & Campaigns
            </h1>
            <p class="text-muted">Create and manage promotional campaigns to boost your visibility</p>
        </div>
    </div>

    <!-- Check Business Subscription Status -->
    <?php if(!$subscription): ?>
    <div class="alert alert-warning alert-dismissible fade show mb-4" role="alert">
        <div class="d-flex align-items-center">
            <i class="fas fa-exclamation-triangle me-3 fs-5"></i>
            <div class="flex-grow-1">
                <h5 class="alert-heading mb-1">Business Plan Required</h5>
                <p class="mb-0">You don't have an active business subscription. Subscribe to a business plan that includes campaigns to create promotional content.</p>
            </div>
            <a href="<?php echo e(route('business.subscription.plans', ['type' => 'business'])); ?>" class="btn btn-warning btn-sm ms-2">
                <i class="fas fa-shopping-cart me-1"></i>Subscribe Now
            </a>
        </div>
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
    <?php endif; ?>

    <!-- Campaign Limit Alert -->
    <?php if($subscription && !$canCreateCampaigns): ?>
    <div class="alert alert-info alert-dismissible fade show mb-4" role="alert">
        <i class="fas fa-info-circle me-2"></i>
        <strong>Campaign Limit:</strong> Your current plan doesn't include campaign creation. Upgrade to a plan that includes promotional campaigns.
        <a href="<?php echo e(route('business.subscription.plans', ['type' => 'business'])); ?>" class="alert-link ms-2">View Premium Plans</a>
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
    <?php elseif($subscription && $canCreateCampaigns): ?>
    <div class="alert alert-success alert-dismissible fade show mb-4" role="alert">
        <i class="fas fa-check-circle me-2"></i>
        <strong>Campaign Allowance:</strong> <?php echo e($campaignLimit - $activeCampaignsThisMonth); ?>/<?php echo e($campaignLimit); ?> campaigns remaining this month
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
    <?php endif; ?>

    <!-- Statistics Cards -->
    <div class="row mb-4">
        <div class="col-md-3">
            <div class="card shadow-sm border-0">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <p class="text-muted small fw-bold mb-1">ACTIVE CAMPAIGNS</p>
                            <h3 class="mb-0"><?php echo e($activeCampaigns ?? 0); ?></h3>
                        </div>
                        <div class="bg-primary bg-opacity-10 rounded-circle p-3">
                            <i class="fas fa-play-circle text-primary fs-5"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-3">
            <div class="card shadow-sm border-0">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <p class="text-muted small fw-bold mb-1">TOTAL IMPRESSIONS</p>
                            <h3 class="mb-0"><?php echo e(number_format($totalImpressions ?? 0)); ?></h3>
                        </div>
                        <div class="bg-info bg-opacity-10 rounded-circle p-3">
                            <i class="fas fa-eye text-info fs-5"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-3">
            <div class="card shadow-sm border-0">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <p class="text-muted small fw-bold mb-1">TOTAL CLICKS</p>
                            <h3 class="mb-0"><?php echo e(number_format($totalClicks ?? 0)); ?></h3>
                        </div>
                        <div class="bg-success bg-opacity-10 rounded-circle p-3">
                            <i class="fas fa-mouse text-success fs-5"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-3">
            <div class="card shadow-sm border-0">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <p class="text-muted small fw-bold mb-1">TOTAL SPENT</p>
                            <h3 class="mb-0">AED <?php echo e(number_format($totalSpent ?? 0, 2)); ?></h3>
                        </div>
                        <div class="bg-warning bg-opacity-10 rounded-circle p-3">
                            <i class="fas fa-coins text-warning fs-5"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Quick Actions -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="card shadow-sm border-0">
                <div class="card-body">
                    <h5 class="fw-bold mb-3">Quick Actions</h5>
                    <div class="row g-3">
                        <div class="col-md-4">
                            <a href="<?php echo e(route('business.marketing.campaigns')); ?>" class="btn btn-outline-primary w-100">
                                <i class="fas fa-list me-2"></i>My Campaigns
                            </a>
                        </div>
                        <?php if($canCreateCampaigns && $activeCampaignsThisMonth < $campaignLimit): ?>
                        <div class="col-md-4">
                            <a href="<?php echo e(route('business.marketing.campaigns.create')); ?>" class="btn btn-primary w-100">
                                <i class="fas fa-plus-circle me-2"></i>Create Campaign
                            </a>
                        </div>
                        <?php else: ?>
                        <div class="col-md-4">
                            <button class="btn btn-primary w-100" disabled title="Campaign limit reached this month">
                                <i class="fas fa-lock me-2"></i>Campaign Limit Reached
                            </button>
                        </div>
                        <?php endif; ?>
                        <div class="col-md-4">
                            <a href="<?php echo e(route('business.subscription.index')); ?>" class="btn btn-outline-info w-100">
                                <i class="fas fa-cog me-2"></i>Manage Plans
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Current Subscription Status -->
    <?php if($subscription && $plan): ?>
    <div class="row mb-4">
        <div class="col-12">
            <div class="card shadow-sm border-0 border-start border-success border-4">
                <div class="card-body">
                    <div class="row align-items-center">
                        <div class="col-md-8">
                            <h5 class="fw-bold mb-2">
                                <i class="fas fa-check-circle text-success me-2"></i>Active Business Plan
                            </h5>
                            <p class="text-muted mb-1">
                                <strong>Plan:</strong> <?php echo e($plan->name); ?>

                            </p>
                            <p class="text-muted mb-0">
                                <strong>Features:</strong>
                                <?php echo e($plan->max_venues ?? '∞'); ?> Venues •
                                <?php echo e($plan->max_offers ?? '∞'); ?> Offers •
                                <?php echo e($plan->monthly_campaigns ?? 0); ?> Monthly Campaigns
                            </p>
                            <p class="text-muted mb-0 mt-2">
                                Expires: <?php echo e($subscription->end_date->format('M d, Y')); ?>

                                <span class="badge bg-success ms-2"><?php echo e($subscription->end_date->diffForHumans()); ?></span>
                            </p>
                        </div>
                        <div class="col-md-4 text-end">
                            <a href="<?php echo e(route('business.subscription.index')); ?>" class="btn btn-outline-primary">
                                <i class="fas fa-arrow-right me-1"></i>Manage Subscription
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>

    <!-- Recent Campaign Performance Section -->
    <?php if($recentCampaigns && count($recentCampaigns) > 0): ?>
    <div class="row mt-5">
        <div class="col-12">
            <h4 class="fw-bold mb-3">Recent Campaign Performance</h4>
        </div>
    </div>

    <div class="row">
        <?php $__currentLoopData = $recentCampaigns; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $campaign): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="col-lg-6 mb-4">
            <div class="card shadow-sm border-0">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-start mb-3">
                        <div>
                            <h6 class="fw-bold mb-1"><?php echo e($campaign->name); ?></h6>
                            <small class="text-muted"><?php echo e($campaign->created_at->diffForHumans()); ?></small>
                        </div>
                        <span class="badge bg-<?php echo e($campaign->status === 'active' ? 'success' : ($campaign->status === 'paused' ? 'warning' : 'secondary')); ?>">
                            <?php echo e(ucfirst($campaign->status)); ?>

                        </span>
                    </div>

                    <div class="row g-3">
                        <div class="col-6">
                            <small class="text-muted d-block">Impressions</small>
                            <h6 class="mb-0"><?php echo e(number_format($campaign->metrics['impressions'] ?? 0)); ?></h6>
                        </div>
                        <div class="col-6">
                            <small class="text-muted d-block">Clicks</small>
                            <h6 class="mb-0"><?php echo e(number_format($campaign->metrics['clicks'] ?? 0)); ?></h6>
                        </div>
                        <div class="col-6">
                            <small class="text-muted d-block">Budget</small>
                            <h6 class="mb-0">AED <?php echo e(number_format($campaign->budget, 2)); ?></h6>
                        </div>
                        <div class="col-6">
                            <small class="text-muted d-block">CTR</small>
                            <?php
                                $impressions = $campaign->metrics['impressions'] ?? 1;
                                $clicks = $campaign->metrics['clicks'] ?? 0;
                                $ctr = $impressions > 0 ? (($clicks / $impressions) * 100) : 0;
                            ?>
                            <h6 class="mb-0"><?php echo e(number_format($ctr, 2)); ?>%</h6>
                        </div>
                    </div>

                    <div class="mt-3">
                        <a href="<?php echo e(route('marketing.campaigns.edit', $campaign->id)); ?>" class="btn btn-sm btn-outline-primary">
                            <i class="fas fa-edit me-1"></i>Edit Campaign
                        </a>
                    </div>
                </div>
            </div>
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
    <?php else: ?>
    <div class="row mt-5">
        <div class="col-12">
            <div class="card shadow-sm border-0">
                <div class="card-body text-center py-5">
                    <i class="fas fa-inbox text-muted" style="font-size: 48px; opacity: 0.5;"></i>
                    <p class="text-muted mt-3">No campaigns yet</p>
                    <?php if($canCreateCampaigns && $activeCampaignsThisMonth < $campaignLimit): ?>
                    <a href="<?php echo e(route('business.marketing.campaigns.create')); ?>" class="btn btn-primary mt-3">
                        <i class="fas fa-plus-circle me-2"></i>Create Your First Campaign
                    </a>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.business', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\privasee\resources\views/business/marketing/index.blade.php ENDPATH**/ ?>