<?php $__env->startSection('title', 'Activity Logs'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid py-4">
    <!-- Header -->
    <div class="row mb-4">
        <div class="col-md-8">
            <h1 class="h3 mb-0">Admin Activity Logs</h1>
            <p class="text-muted">View comprehensive audit trail of all admin actions</p>
        </div>









    </div>

    <!-- Statistics -->
    <div class="row mb-4">
        <div class="col-md-2">
            <div class="card">
                <div class="card-body">
                    <h6 class="card-title text-muted mb-2">Total Logs</h6>
                    <h3 class="mb-0"><?php echo e($stats['total_logs'] ?? 0); ?></h3>
                </div>
            </div>
        </div>
        <div class="col-md-2">
            <div class="card">
                <div class="card-body">
                    <h6 class="card-title text-muted mb-2">Today</h6>
                    <h3 class="mb-0"><?php echo e($stats['today'] ?? 0); ?></h3>
                </div>
            </div>
        </div>
        <div class="col-md-2">
            <div class="card">
                <div class="card-body">
                    <h6 class="card-title text-muted mb-2">This Week</h6>
                    <h3 class="mb-0"><?php echo e($stats['this_week'] ?? 0); ?></h3>
                </div>
            </div>
        </div>
        <div class="col-md-2">
            <div class="card">
                <div class="card-body">
                    <h6 class="card-title text-muted mb-2">Sensitive</h6>
                    <h3 class="mb-0"><?php echo e($stats['sensitive'] ?? 0); ?></h3>
                </div>
            </div>
        </div>
        <div class="col-md-2">
            <div class="card">
                <div class="card-body">
                    <h6 class="card-title text-muted mb-2">Failed</h6>
                    <h3 class="mb-0"><?php echo e($stats['failed'] ?? 0); ?></h3>
                </div>
            </div>
        </div>
    </div>

    <!-- Filters -->
    <div class="card mb-4">
        <div class="card-body">
            <form method="get" class="row g-2">
                <div class="col-md-2">
                    <label class="form-label">Action</label>
                    <select name="action" class="form-select form-select-sm">
                        <option value="">All Actions</option>
                        <?php if(isset($actions)): ?>
                        <?php $__currentLoopData = $actions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $act): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($act); ?>" <?php echo e(request('action') == $act ? 'selected' : ''); ?>>
                                <?php echo e(ucfirst($act)); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </select>
                </div>
                <div class="col-md-2">
                    <label class="form-label">Entity Type</label>
                    <select name="entity_type" class="form-select form-select-sm">
                        <option value="">All Types</option>
                        <?php if(isset($entityTypes)): ?>
                        <?php $__currentLoopData = $entityTypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($type); ?>" <?php echo e(request('entity_type') == $type ? 'selected' : ''); ?>>
                                <?php echo e($type); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </select>
                </div>
                <div class="col-md-2">
                    <label class="form-label">Admin User</label>
                    <select name="admin_user_id" class="form-select form-select-sm">
                        <option value="">All Users</option>
                        <?php if(isset($admins)): ?>
                        <?php $__currentLoopData = $admins; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $admin): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($admin->id); ?>" <?php echo e(request('admin_user_id') == $admin->id ? 'selected' : ''); ?>>
                                <?php echo e($admin->first_name ?? ''); ?> <?php echo e($admin->last_name ?? ''); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </select>
                </div>
                <div class="col-md-2">
                    <label class="form-label">Status</label>
                    <select name="status" class="form-select form-select-sm">
                        <option value="">All</option>
                        <option value="success" <?php echo e(request('status') == 'success' ? 'selected' : ''); ?>>Success</option>
                        <option value="failed" <?php echo e(request('status') == 'failed' ? 'selected' : ''); ?>>Failed</option>
                    </select>
                </div>
                <div class="col-md-2">
                    <label class="form-label">Type</label>
                    <select name="type" class="form-select form-select-sm">
                        <option value="">All</option>
                        <option value="sensitive" <?php echo e(request('type') == 'sensitive' ? 'selected' : ''); ?>>Sensitive Only</option>
                    </select>
                </div>
                <div class="col-md-2 d-flex align-items-end">
                    <button type="submit" class="btn btn-primary btn-sm w-100">
                        <i class="fas fa-filter"></i> Filter
                    </button>
                </div>
            </form>
        </div>
    </div>

    <!-- Activity Table -->
    <div class="card">
        <div class="table-responsive">
            <table class="table table-hover mb-0">
                <thead class="table-light">
                    <tr>
                        <th>Time</th>
                        <th>Admin User</th>
                        <th>Action</th>
                        <th>Entity</th>
                        <th>Entity Name</th>
                        <th>Status</th>
                        <th>IP Address</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if(isset($logs)): ?>
                    <?php $__empty_1 = true; $__currentLoopData = $logs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $log): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td>
                                <small><?php echo e($log->created_at ? $log->created_at->format('M d, Y H:i:s') : 'N/A'); ?></small>
                            </td>
                            <td>
                                <small>
                                    <strong><?php echo e($log->adminUser->first_name ?? 'N/A'); ?> <?php echo e($log->adminUser->last_name ?? ''); ?></strong>
                                    <br>
                                    <span class="text-muted"><?php echo e($log->adminUser->email ?? ''); ?></span>
                                </small>
                            </td>
                            <td>
                                <span class="badge bg-primary"><?php echo e(ucfirst($log->action ?? 'unknown')); ?></span>
                                <?php if($log->is_sensitive): ?>
                                    <span class="badge bg-danger">Sensitive</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <small><?php echo e($log->entity_type ?? 'N/A'); ?></small>
                            </td>
                            <td>
                                <small><?php echo e($log->entity_name ?? 'N/A'); ?></small>
                            </td>
                            <td>
                                <?php if($log->status === 'success'): ?>
                                    <span class="badge bg-success">Success</span>
                                <?php elseif($log->status === 'failed'): ?>
                                    <span class="badge bg-danger">Failed</span>
                                <?php else: ?>
                                    <span class="badge bg-warning"><?php echo e(ucfirst($log->status ?? 'pending')); ?></span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <code class="text-muted"><?php echo e($log->ip_address ?? 'N/A'); ?></code>
                            </td>
                            <td>
                                <button class="btn btn-sm btn-info" data-bs-toggle="modal" data-bs-target="#logDetailModal"
                                    onclick="loadLogDetail(<?php echo e($log->id); ?>)">
                                    <i class="fas fa-eye"></i> View
                                </button>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="8" class="text-center text-muted py-4">
                                No activity logs found
                            </td>
                        </tr>
                    <?php endif; ?>
                    <?php else: ?>
                    <tr>
                        <td colspan="8" class="text-center text-danger py-4">
                            <i class="fas fa-exclamation-triangle me-2"></i>Unable to load activity logs
                        </td>
                    </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Pagination -->
    <div class="d-flex justify-content-between align-items-center mt-4">
        <div>
            <?php if(isset($logs)): ?>
                <?php
                    $firstItem = method_exists($logs, 'firstItem') ? $logs->firstItem() : 0;
                    $lastItem = method_exists($logs, 'lastItem') ? $logs->lastItem() : 0;
                    $total = method_exists($logs, 'total') ? $logs->total() : 0;
                ?>
                Showing <?php echo e($firstItem); ?> to <?php echo e($lastItem); ?> of <?php echo e($total); ?> logs
            <?php else: ?>
                No data available
            <?php endif; ?>
        </div>
        <div>
            <?php if(isset($logs) && method_exists($logs, 'hasPages') && $logs->hasPages()): ?>
                <?php echo e($logs->links()); ?>

            <?php endif; ?>
        </div>
    </div>
</div>

<!-- Log Detail Modal -->
<div class="modal fade" id="logDetailModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Activity Log Details</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div id="logDetailContent">
                    Loading...
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
function loadLogDetail(logId) {
    fetch(`/admin/activities/${logId}`, {
        headers: {
            'Authorization': `Bearer ${document.querySelector('meta[name="csrf-token"]').content}`,
            'Accept': 'application/json'
        }
    })
    .then(response => {
        if (!response.ok) {
            throw new Error(`HTTP error! status: ${response.status}`);
        }
        return response.json();
    })
    .then(data => {
        if (data.data) {
            const log = data.data;
            const content = `
                <div class="row mb-3">
                    <div class="col-md-6">
                        <label class="form-label text-muted">ID</label>
                        <p>${log.id || 'N/A'}</p>
                    </div>
                    <div class="col-md-6">
                        <label class="form-label text-muted">Timestamp</label>
                        <p>${log.created_at || 'N/A'}</p>
                    </div>
                </div>
                <div class="row mb-3">
                    <div class="col-md-6">
                        <label class="form-label text-muted">Admin User</label>
                        <p>${log.admin_user?.first_name || ''} ${log.admin_user?.last_name || ''}</p>
                    </div>
                    <div class="col-md-6">
                        <label class="form-label text-muted">Action</label>
                        <p><span class="badge bg-primary">${log.action || 'N/A'}</span></p>
                    </div>
                </div>
                <div class="row mb-3">
                    <div class="col-md-6">
                        <label class="form-label text-muted">Entity Type</label>
                        <p>${log.entity_type || 'N/A'}</p>
                    </div>
                    <div class="col-md-6">
                        <label class="form-label text-muted">Entity ID</label>
                        <p>${log.entity_id || 'N/A'}</p>
                    </div>
                </div>
                <div class="row mb-3">
                    <div class="col-md-6">
                        <label class="form-label text-muted">Status</label>
                        <p><span class="badge ${log.status === 'success' ? 'bg-success' : 'bg-danger'}">${log.status || 'N/A'}</span></p>
                    </div>
                    <div class="col-md-6">
                        <label class="form-label text-muted">IP Address</label>
                        <p><code>${log.ip_address || 'N/A'}</code></p>
                    </div>
                </div>
                <div class="row mb-3">
                    <div class="col-12">
                        <label class="form-label text-muted">Description</label>
                        <p>${log.description || 'No description'}</p>
                    </div>
                </div>
                ${log.changes ? `
                <div class="row">
                    <div class="col-12">
                        <label class="form-label text-muted">Changes</label>
                        <pre class="bg-light p-3 rounded"><code>${JSON.stringify(log.changes, null, 2)}</code></pre>
                    </div>
                </div>
                ` : ''}
            `;
            document.getElementById('logDetailContent').innerHTML = content;
        } else {
            document.getElementById('logDetailContent').innerHTML = '<p class="text-danger">Failed to load log details</p>';
        }
    })
    .catch(error => {
        console.error('Error:', error);
        document.getElementById('logDetailContent').innerHTML = `<p class="text-danger">Error: ${error.message}</p>`;
    });
}
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\privasee\resources\views/admin/activities/index.blade.php ENDPATH**/ ?>