<?php $__env->startSection('title', 'Marketing Plans'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid py-4">
    <!-- Header -->
    <div class="row mb-4">
        <div class="col">
            <h1 class="h2 fw-bold mb-0">
                <i class="fas fa-star me-2"></i>Marketing Plans
            </h1>
            <p class="text-muted">Choose a marketing plan to start creating campaigns</p>
        </div>
        <div class="col-auto">
            <a href="<?php echo e(route('business.marketing.index')); ?>" class="btn btn-outline-secondary">
                <i class="fas fa-arrow-left me-2"></i>Back to Marketing
            </a>
        </div>
    </div>

    <!-- Current Plan Alert -->
    <?php if($currentPlan): ?>
    <div class="alert alert-success alert-dismissible fade show mb-4" role="alert">
        <i class="fas fa-check-circle me-2"></i>
        <strong>Current Plan:</strong> <?php echo e($currentPlan->plan->name); ?> - Active until <?php echo e($currentPlan->end_date->format('M d, Y')); ?>

        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
    <?php endif; ?>

    <!-- Plans Grid -->
    <div class="row">
        <?php $__empty_1 = true; $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
        <div class="col-lg-4 col-md-6 mb-4">
            <div class="card h-100 shadow-sm border-0 position-relative <?php echo e($currentPlan?->plan_id === $plan->id ? 'border-success border-3' : ''); ?>">
                <!-- Popular Badge -->
                <?php if($plan->is_popular): ?>
                <div class="position-absolute top-0 end-0 p-3">
                    <span class="badge bg-primary">
                        <i class="fas fa-star me-1"></i>POPULAR
                    </span>
                </div>
                <?php endif; ?>

                <!-- Current Plan Badge -->
                <?php if($currentPlan?->plan_id === $plan->id): ?>
                <div class="position-absolute top-0 start-0 p-3">
                    <span class="badge bg-success">
                        <i class="fas fa-check-circle me-1"></i>CURRENT PLAN
                    </span>
                </div>
                <?php endif; ?>

                <div class="card-body d-flex flex-column">
                    <!-- Plan Name -->
                    <h4 class="fw-bold mb-3"><?php echo e($plan->name); ?></h4>

                    <!-- Price -->
                    <div class="mb-4">
                        <div class="display-5 fw-bold text-primary">
                            AED <?php echo e(number_format($plan->price, 2)); ?>

                        </div>
                        <p class="text-muted">per <?php echo e(ucfirst($plan->duration_type)); ?></p>
                    </div>

                    <!-- Description -->
                    <?php if($plan->description): ?>
                    <p class="text-muted small mb-4"><?php echo e($plan->description); ?></p>
                    <?php endif; ?>

                    <!-- Duration -->
                    <div class="mb-4 p-3 bg-light rounded">
                        <small class="text-muted">
                            <i class="fas fa-clock me-2"></i>
                            Duration: <?php echo e($plan->duration_days); ?> days
                        </small>
                    </div>

                    <!-- Features -->
                    <?php if($plan->features && is_array($plan->features)): ?>
                    <div class="mb-4 flex-grow-1">
                        <h6 class="fw-bold small mb-3">Includes:</h6>
                        <ul class="list-unstyled small">
                            <?php $__currentLoopData = $plan->features; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $feature): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li class="mb-2">
                                <i class="fas fa-check text-success me-2"></i><?php echo e($feature); ?>

                            </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                    <?php endif; ?>

                    <!-- Limits -->
                    <?php if($plan->max_venues || $plan->max_offers || $plan->max_impressions): ?>
                    <div class="mb-4 p-3 bg-light rounded">
                        <h6 class="fw-bold small mb-2">Plan Limits:</h6>
                        <div class="row g-2 small">
                            <?php if($plan->max_impressions): ?>
                            <div class="col-12">
                                <span class="badge bg-secondary">
                                    <i class="fas fa-eye me-1"></i><?php echo e(number_format($plan->max_impressions)); ?> Impressions
                                </span>
                            </div>
                            <?php endif; ?>
                            <?php if($plan->max_offers): ?>
                            <div class="col-12">
                                <span class="badge bg-secondary">
                                    <i class="fas fa-tag me-1"></i><?php echo e($plan->max_offers); ?> Offers
                                </span>
                            </div>
                            <?php endif; ?>
                        </div>
                    </div>
                    <?php endif; ?>

                    <!-- Action Button -->
                    <?php if($currentPlan?->plan_id === $plan->id): ?>
                    <button class="btn btn-success btn-lg w-100" disabled>
                        <i class="fas fa-check-circle me-2"></i>Current Plan
                    </button>
                    <?php else: ?>
                    <button class="btn btn-primary btn-lg w-100" onclick="selectPlan(<?php echo e($plan->id); ?>)">
                        <i class="fas fa-shopping-cart me-2"></i>Select Plan
                    </button>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
        <div class="col-12">
            <div class="card shadow-sm border-0">
                <div class="card-body text-center py-5">
                    <i class="fas fa-inbox text-muted" style="font-size: 48px; opacity: 0.5;"></i>
                    <p class="text-muted mt-3">No marketing plans available</p>
                </div>
            </div>
        </div>
        <?php endif; ?>
    </div>

    <!-- Info Section -->
    <div class="row mt-5">
        <div class="col-12">
            <div class="card shadow-sm border-0 bg-light">
                <div class="card-body">
                    <h5 class="fw-bold mb-3">
                        <i class="fas fa-info-circle me-2 text-info"></i>Why Subscribe to a Marketing Plan?
                    </h5>
                    <div class="row g-4">
                        <div class="col-md-4">
                            <div class="d-flex">
                                <div class="me-3">
                                    <i class="fas fa-bullhorn text-primary fs-5"></i>
                                </div>
                                <div>
                                    <h6 class="fw-bold">Create Campaigns</h6>
                                    <p class="text-muted small">Launch promotional campaigns to reach more customers</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="d-flex">
                                <div class="me-3">
                                    <i class="fas fa-chart-bar text-success fs-5"></i>
                                </div>
                                <div>
                                    <h6 class="fw-bold">Track Performance</h6>
                                    <p class="text-muted small">Monitor impressions, clicks, and conversions in real-time</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="d-flex">
                                <div class="me-3">
                                    <i class="fas fa-rocket text-warning fs-5"></i>
                                </div>
                                <div>
                                    <h6 class="fw-bold">Boost Visibility</h6>
                                    <p class="text-muted small">Get featured placements and reach a wider audience</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
function selectPlan(planId) {
    window.location.href = `/business/subscription/plans?type=marketing&plan_id=${planId}`;
}
</script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.business', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\privasee\resources\views/business/marketing/plans.blade.php ENDPATH**/ ?>