<?php $__env->startSection('title', 'Redemptions Report'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid py-4">
    <!-- Header -->
    <div class="row mb-4">
        <div class="col-md-8">
            <h1 class="h3 mb-0">
                <i class="bi bi-check-circle"></i> Redemptions Report
            </h1>
            <p class="text-muted">Detailed redemption analytics and transactions</p>
        </div>
        <div class="col-md-4 text-end">
            <a href="<?php echo e(route('admin.analytics.index')); ?>" class="btn btn-sm btn-secondary">
                <i class="bi bi-arrow-left"></i> Back to Analytics
            </a>
        </div>
    </div>

    <!-- Filters -->
    <div class="card border-0 shadow-sm mb-4">
        <div class="card-body">
            <form method="GET" class="row g-3">
                <div class="col-md-3">
                    <label class="form-label">Period</label>
                    <select name="period" class="form-select" onchange="this.form.submit()">
                        <option value="7" <?php echo e($period == 7 ? 'selected' : ''); ?>>Last 7 Days</option>
                        <option value="30" <?php echo e($period == 30 ? 'selected' : ''); ?>>Last 30 Days</option>
                        <option value="90" <?php echo e($period == 90 ? 'selected' : ''); ?>>Last 90 Days</option>
                    </select>
                </div>
                <div class="col-md-3">
                    <label class="form-label">Status</label>
                    <select name="status" class="form-select" onchange="this.form.submit()">
                        <option value="">All Statuses</option>
                        <option value="completed" <?php echo e($status == 'completed' ? 'selected' : ''); ?>>Completed</option>
                        <option value="pending" <?php echo e($status == 'pending' ? 'selected' : ''); ?>>Pending</option>
                        <option value="cancelled" <?php echo e($status == 'cancelled' ? 'selected' : ''); ?>>Cancelled</option>
                    </select>
                </div>
                <div class="col-md-6 d-flex align-items-end gap-2">
                    <button type="submit" class="btn btn-primary">
                        <i class="bi bi-search"></i> Filter
                    </button>
                    <a href="<?php echo e(route('admin.analytics.reports.redemptions')); ?>" class="btn btn-secondary">
                        <i class="bi bi-arrow-clockwise"></i> Reset
                    </a>
                </div>
            </form>
        </div>
    </div>

    <!-- Redemptions Table -->
    <div class="card border-0 shadow-sm">
        <div class="table-responsive">
            <table class="table table-hover mb-0">
                <thead class="table-light">
                    <tr>
                        <th>User</th>
                        <th>Offer</th>
                        <th>Business</th>
                        <th>Status</th>
                        <th>Date</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $redemptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $redemption): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td>
                                <small>
                                    <strong><?php echo e($redemption->user->first_name); ?> <?php echo e($redemption->user->last_name); ?></strong><br>
                                    <span class="text-muted"><?php echo e($redemption->user->email); ?></span>
                                </small>
                            </td>
                            <td>
                                <small><?php echo e(Str::limit($redemption->offer->title, 25)); ?></small>
                            </td>
                            <td>
                                <small class="text-muted"><?php echo e($redemption->offer->business->business_name ?? 'N/A'); ?></small>
                            </td>
                            <td>
                                <span class="badge bg-<?php echo e($redemption->status === 'completed' ? 'success' : ($redemption->status === 'pending' ? 'warning' : 'danger')); ?>">
                                    <?php echo e(ucfirst($redemption->status)); ?>

                                </span>
                            </td>
                            <td>
                                <small class="text-muted"><?php echo e($redemption->created_at->format('M d, Y H:i')); ?></small>
                            </td>
                            <td>
                                <a href="#" class="btn btn-sm btn-info" title="View Details">
                                    <i class="bi bi-eye"></i>
                                </a>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="6" class="text-center text-muted py-4">
                                <small>No redemptions found</small>
                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

        <!-- Pagination -->
        <div class="card-footer bg-light">
            <div class="d-flex justify-content-between align-items-center">
                <small class="text-muted">
                    Showing <?php echo e($redemptions->firstItem() ?? 0); ?> to <?php echo e($redemptions->lastItem() ?? 0); ?> of <?php echo e($redemptions->total()); ?> redemptions
                </small>
                <?php echo e($redemptions->links()); ?>

            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\privasee\resources\views/admin/analytics/redemptions-report.blade.php ENDPATH**/ ?>