<?php $__env->startSection('title', 'Offer Details'); ?>

<?php $__env->startSection('content'); ?>
    <div class="mb-4">
        <div class="d-flex justify-content-between align-items-center">
            <div>
                <h2 class="fw-bold mb-1"><?php echo e($offer->title); ?></h2>
                <p class="text-muted mb-0">
                    <a href="<?php echo e(route('business.venues.show', $offer->venue_id)); ?>" class="text-decoration-none">
                        <?php echo e($offer->venue->name); ?>

                    </a>
                </p>
            </div>
            <div>
                <a href="<?php echo e(route('business.offers.edit', $offer->id)); ?>" class="btn btn-primary">
                    <i class="bi bi-pencil me-2"></i>Edit Offer
                </a>
                <a href="<?php echo e(route('business.offers.index')); ?>" class="btn btn-outline-secondary">
                    <i class="bi bi-arrow-left me-2"></i>Back
                </a>
            </div>
        </div>
    </div>

    <!-- Stats Cards -->
    <div class="row g-3 mb-4">
        <div class="col-md-3">
            <div class="card border-0 shadow-sm">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <p class="text-muted mb-1 small">Total Redemptions</p>
                            <h4 class="mb-0"><?php echo e($stats['total_redemptions']); ?></h4>
                        </div>
                        <div class="bg-success bg-opacity-10 rounded p-3">
                            <i class="bi bi-check-circle text-success fs-4"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-3">
            <div class="card border-0 shadow-sm">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <p class="text-muted mb-1 small">Total Views</p>
                            <h4 class="mb-0"><?php echo e($stats['views']); ?></h4>
                        </div>
                        <div class="bg-info bg-opacity-10 rounded p-3">
                            <i class="bi bi-eye text-info fs-4"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-3">
            <div class="card border-0 shadow-sm">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <p class="text-muted mb-1 small">Conversion Rate</p>
                            <h4 class="mb-0"><?php echo e($stats['conversion_rate']); ?>%</h4>
                        </div>
                        <div class="bg-primary bg-opacity-10 rounded p-3">
                            <i class="bi bi-graph-up text-primary fs-4"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-3">
            <div class="card border-0 shadow-sm">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <p class="text-muted mb-1 small">Status</p>
                            <h6 class="mb-0">
                            <span class="badge bg-<?php echo e($offer->status === 'active' ? 'success' : ($offer->status === 'expired' ? 'danger' : 'warning')); ?>">
                                <?php echo e(ucfirst($offer->status)); ?>

                            </span>
                            </h6>
                        </div>
                        <div class="bg-warning bg-opacity-10 rounded p-3">
                            <i class="bi bi-info-circle text-warning fs-4"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Offer Details -->
    <div class="row g-4">
        <div class="col-lg-8">
            <div class="card border-0 shadow-sm mb-4">
                <div class="card-body">
                    <?php if($offer->image): ?>
                        <img src="<?php echo e(asset('storage/' . $offer->image)); ?>" class="img-fluid rounded mb-4" alt="<?php echo e($offer->title); ?>">
                    <?php endif; ?>

                    <h5 class="fw-bold mb-3">Description</h5>
                    <p><?php echo e($offer->description); ?></p>

                    <?php if($offer->terms_and_conditions): ?>
                        <h5 class="fw-bold mb-3 mt-4">Terms & Conditions</h5>
                        <p><?php echo e($offer->terms_and_conditions); ?></p>
                    <?php endif; ?>
                </div>
            </div>

            <!-- Recent Redemptions -->
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-white">
                    <h5 class="mb-0 fw-bold">Recent Redemptions</h5>
                </div>
                <div class="card-body p-0">
                    <div class="table-responsive">
                        <table class="table table-hover mb-0">
                            <thead>
                            <tr>
                                <th>User</th>
                                <th>Date</th>
                                <th>Code</th>
                                <th>Status</th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $offer->redemptions->take(10); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $redemption): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e($redemption->user->name ?? 'N/A'); ?></td>
                                    <td><?php echo e($redemption->redeemed_at ? $redemption->redeemed_at->format('M d, Y H:i') : 'N/A'); ?></td>
                                    <td><code><?php echo e($redemption->code); ?></code></td>
                                    <td>
                                    <span class="badge bg-<?php echo e($redemption->status === 'completed' ? 'success' : 'warning'); ?>">
                                        <?php echo e(ucfirst($redemption->status)); ?>

                                    </span>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="4" class="text-center py-4 text-muted">No redemptions yet</td>
                                </tr>
                            <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>


            <div class="card border-0 shadow-sm mt-4">
                <div class="card-header bg-white">
                    <h5 class="mb-0 fw-bold">Offer Images</h5>
                </div>
                <div class="card-body">
                    <div class="row g-3">
                        <?php $__currentLoopData = json_decode($offer->images ?? '[]'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="col-md-4">
                                <img src="<?php echo e(asset('storage/' . $image)); ?>" class="img-fluid rounded" alt="Offer Image">
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>

        </div>

        <div class="col-lg-4">
            <!-- Offer Info -->
            <div class="card border-0 shadow-sm mb-4">
                <div class="card-header bg-white">
                    <h5 class="mb-0 fw-bold">Offer Information</h5>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <small class="text-muted">Offer Type</small>
                        <p class="mb-0 fw-semibold"><?php echo e(ucfirst($offer->offer_type)); ?></p>
                    </div>

                    <div class="mb-3">
                        <small class="text-muted">Discount Type</small>
                        <p class="mb-0 fw-semibold"><?php echo e(ucfirst(str_replace('_', ' ', $offer->discount_type))); ?></p>
                    </div>

                    <div class="mb-3">
                        <small class="text-muted">Discount Value</small>
                        <p class="mb-0 fw-semibold">
                            <?php echo e($offer->discount_type === 'percentage' ? $offer->discount_value . '%' : 'AED ' . $offer->discount_value); ?>

                        </p>
                    </div>

                    <?php if($offer->original_price): ?>
                        <div class="mb-3">
                            <small class="text-muted">Original Price</small>
                            <p class="mb-0 fw-semibold">AED <?php echo e(number_format($offer->original_price, 2)); ?></p>
                        </div>
                    <?php endif; ?>

                    <?php if($offer->discounted_price): ?>
                        <div class="mb-3">
                            <small class="text-muted">Discounted Price</small>
                            <p class="mb-0 fw-semibold text-success">AED <?php echo e(number_format($offer->discounted_price, 2)); ?></p>
                        </div>
                    <?php endif; ?>

                    <hr>

                    <div class="mb-3">
                        <small class="text-muted">Valid From</small>
                        <p class="mb-0 fw-semibold"><?php echo e($offer->start_date ? $offer->start_date->format('M d, Y') : 'N/A'); ?></p>
                    </div>

                    <div class="mb-3">
                        <small class="text-muted">Valid Until</small>
                        <p class="mb-0 fw-semibold"><?php echo e($offer->end_date ? $offer->end_date->format('M d, Y') : 'N/A'); ?></p>
                    </div>

                    <?php if($offer->max_redemptions): ?>
                        <div class="mb-3">
                            <small class="text-muted">Max Redemptions</small>
                            <p class="mb-0 fw-semibold"><?php echo e($offer->redemption_count); ?> / <?php echo e($offer->max_redemptions); ?></p>
                        </div>
                    <?php endif; ?>

                    <?php if($offer->max_redemptions_per_user): ?>
                        <div class="mb-3">
                            <small class="text-muted">Per User Limit</small>
                            <p class="mb-0 fw-semibold"><?php echo e($offer->max_redemptions_per_user); ?></p>
                        </div>
                    <?php endif; ?>
                </div>
            </div>

            <!-- Quick Actions -->
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-white">
                    <h5 class="mb-0 fw-bold">Quick Actions</h5>
                </div>
                <div class="card-body">
                    <div class="d-grid gap-2">
                        <a href="<?php echo e(route('business.offers.edit', $offer->id)); ?>" class="btn btn-primary">
                            <i class="bi bi-pencil me-2"></i>Edit Offer
                        </a>
                        <button class="btn btn-outline-secondary" onclick="duplicateOffer(<?php echo e($offer->id); ?>)">
                            <i class="bi bi-files me-2"></i>Duplicate
                        </button>
                        <button class="btn btn-outline-<?php echo e($offer->status === 'active' ? 'warning' : 'success'); ?>"
                                onclick="toggleStatus(<?php echo e($offer->id); ?>)">
                            <i class="bi bi-toggle-<?php echo e($offer->status === 'active' ? 'on' : 'off'); ?> me-2"></i>
                            <?php echo e($offer->status === 'active' ? 'Deactivate' : 'Activate'); ?>

                        </button>
                        <button class="btn btn-outline-danger" onclick="deleteOffer(<?php echo e($offer->id); ?>)">
                            <i class="bi bi-trash me-2"></i>Delete
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script>
        function toggleStatus(id) {
            if (!confirm('Are you sure you want to change the offer status?')) return;

            fetch(`/business/offers/${id}/toggle-status`, {
                method: 'POST',
                headers: {
                    'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
                    'Accept': 'application/json'
                }
            })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        window.location.reload();
                    }
                });
        }

        function duplicateOffer(id) {
            if (!confirm('Create a copy of this offer?')) return;

            fetch(`/business/offers/${id}/duplicate`, {
                method: 'POST',
                headers: {
                    'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
                    'Accept': 'application/json'
                }
            })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        window.location.href = `/business/offers/${data.offer_id}/edit`;
                    }
                });
        }

        function deleteOffer(id) {
            if (!confirm('Are you sure you want to delete this offer? This action cannot be undone.')) return;

            fetch(`/business/offers/${id}`, {
                method: 'DELETE',
                headers: {
                    'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
                    'Accept': 'application/json'
                }
            })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        window.location.href = '/business/offers';
                    }
                });
        }
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.business', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\privasee\resources\views/business/offers/show.blade.php ENDPATH**/ ?>