<?php $__env->startSection('title', 'System Settings'); ?>

<?php $__env->startSection('content'); ?>
<div class="mb-4">
    <h2 class="fw-bold mb-1">System Settings</h2>
    <p class="text-muted mb-0">Configure platform-wide settings and preferences</p>
</div>

<div class="row g-4">
    <div class="col-lg-3">
        <div class="admin-card">
            <div class="list-group list-group-flush">
                <a href="#general" class="list-group-item list-group-item-action active" data-bs-toggle="pill">
                    <i class="bi bi-gear me-2"></i>General Settings
                </a>
                <a href="#email" class="list-group-item list-group-item-action" data-bs-toggle="pill">
                    <i class="bi bi-envelope me-2"></i>Email Settings
                </a>
                <a href="#payment" class="list-group-item list-group-item-action" data-bs-toggle="pill">
                    <i class="bi bi-credit-card me-2"></i>Payment Gateways
                </a>
                <a href="#sms" class="list-group-item list-group-item-action" data-bs-toggle="pill">
                    <i class="bi bi-phone me-2"></i>SMS Settings
                </a>
                <a href="#push" class="list-group-item list-group-item-action" data-bs-toggle="pill">
                    <i class="bi bi-bell me-2"></i>Push Notifications
                </a>
                <a href="#social" class="list-group-item list-group-item-action" data-bs-toggle="pill">
                    <i class="bi bi-share me-2"></i>Social Login
                </a>
                <a href="#security" class="list-group-item list-group-item-action" data-bs-toggle="pill">
                    <i class="bi bi-shield-lock me-2"></i>Security
                </a>
                <a href="#maintenance" class="list-group-item list-group-item-action" data-bs-toggle="pill">
                    <i class="bi bi-tools me-2"></i>Maintenance
                </a>
            </div>
        </div>
    </div>

    <div class="col-lg-9">
        <div class="tab-content">
            <!-- General Settings -->
            <div class="tab-pane fade show active" id="general">
                <div class="admin-card">
                    <div class="admin-card-header">
                        <h5 class="mb-0 fw-bold">General Settings</h5>
                    </div>
                    <div class="admin-card-body">
                        <form action="<?php echo e(route('admin.settings.update', 'general')); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <div class="row g-3">
                                <div class="col-12">
                                    <label class="form-label">Platform Name</label>
                                    <input type="text" class="form-control" name="app_name" value="<?php echo e(config('app.name')); ?>">
                                </div>

                                <div class="col-md-6">
                                    <label class="form-label">Default Language</label>
                                    <select class="form-select" name="default_language">
                                        <option value="en">English</option>
                                        <option value="ar">Arabic</option>
                                    </select>
                                </div>

                                <div class="col-md-6">
                                    <label class="form-label">Timezone</label>
                                    <select class="form-select" name="timezone">
                                        <option value="UTC">UTC</option>
                                        <option value="Asia/Dubai" selected>Asia/Dubai (GST)</option>
                                        <option value="Asia/Riyadh">Asia/Riyadh (AST)</option>
                                    </select>
                                </div>

                                <div class="col-md-6">
                                    <label class="form-label">Default Currency</label>
                                    <select class="form-select" name="currency">
                                        <option value="AED" selected>AED (د.إ)</option>
                                        <option value="SAR">SAR (ر.س)</option>
                                        <option value="USD">USD ($)</option>
                                    </select>
                                </div>

                                <div class="col-md-6">
                                    <label class="form-label">Date Format</label>
                                    <select class="form-select" name="date_format">
                                        <option value="Y-m-d">YYYY-MM-DD</option>
                                        <option value="d/m/Y" selected>DD/MM/YYYY</option>
                                        <option value="m/d/Y">MM/DD/YYYY</option>
                                    </select>
                                </div>

                                <div class="col-12">
                                    <label class="form-label">Support Email</label>
                                    <input type="email" class="form-control" name="support_email" value="support@privasee.com">
                                </div>

                                <div class="col-12">
                                    <label class="form-label">Support Phone</label>
                                    <input type="tel" class="form-control" name="support_phone" value="+971 4 123 4567">
                                </div>

                                <div class="col-12">
                                    <button type="submit" class="btn btn-primary">
                                        <i class="bi bi-save me-2"></i>Save Changes
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

            <!-- Email Settings -->
            <div class="tab-pane fade" id="email">
                <div class="admin-card">
                    <div class="admin-card-header">
                        <h5 class="mb-0 fw-bold">Email Configuration</h5>
                    </div>
                    <div class="admin-card-body">
                        <form action="<?php echo e(route('admin.settings.update', 'email')); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <div class="row g-3">
                                <div class="col-md-6">
                                    <label class="form-label">Email Driver</label>
                                    <select class="form-select" name="mail_driver">
                                        <option value="smtp" selected>SMTP</option>
                                        <option value="sendgrid">SendGrid</option>
                                        <option value="ses">AWS SES</option>
                                        <option value="mailgun">Mailgun</option>
                                    </select>
                                </div>

                                <div class="col-md-6">
                                    <label class="form-label">From Email</label>
                                    <input type="email" class="form-control" name="mail_from" value="noreply@privasee.com">
                                </div>

                                <div class="col-12">
                                    <label class="form-label">From Name</label>
                                    <input type="text" class="form-control" name="mail_from_name" value="Privasee">
                                </div>

                                <div class="col-md-6">
                                    <label class="form-label">SMTP Host</label>
                                    <input type="text" class="form-control" name="mail_host" value="">
                                </div>

                                <div class="col-md-6">
                                    <label class="form-label">SMTP Port</label>
                                    <input type="number" class="form-control" name="mail_port" value="587">
                                </div>

                                <div class="col-md-6">
                                    <label class="form-label">SMTP Username</label>
                                    <input type="text" class="form-control" name="mail_username" value="">
                                </div>

                                <div class="col-md-6">
                                    <label class="form-label">SMTP Password</label>
                                    <input type="password" class="form-control" name="mail_password" value="">
                                </div>

                                <div class="col-12">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" name="mail_encryption" id="mailEncryption" checked>
                                        <label class="form-check-label" for="mailEncryption">
                                            Use TLS/SSL Encryption
                                        </label>
                                    </div>
                                </div>

                                <div class="col-12">
                                    <button type="button" class="btn btn-outline-primary me-2" onclick="testEmail()">
                                        <i class="bi bi-envelope-check me-2"></i>Send Test Email
                                    </button>
                                    <button type="submit" class="btn btn-primary">
                                        <i class="bi bi-save me-2"></i>Save Changes
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

            <!-- Payment Gateways -->
            <div class="tab-pane fade" id="payment">
                <div class="admin-card mb-4">
                    <div class="admin-card-header">
                        <h5 class="mb-0 fw-bold">Stripe Configuration</h5>
                    </div>
                    <div class="admin-card-body">
                        <form action="<?php echo e(route('admin.settings.update', 'stripe')); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <div class="row g-3">
                                <div class="col-12">
                                    <div class="form-check form-switch">
                                        <input class="form-check-input" type="checkbox" name="stripe_enabled" id="stripeEnabled" checked>
                                        <label class="form-check-label fw-semibold" for="stripeEnabled">
                                            Enable Stripe Payments
                                        </label>
                                    </div>
                                </div>

                                <div class="col-12">
                                    <label class="form-label">Publishable Key</label>
                                    <input type="text" class="form-control" name="stripe_key" value="">
                                </div>

                                <div class="col-12">
                                    <label class="form-label">Secret Key</label>
                                    <input type="password" class="form-control" name="stripe_secret" value="">
                                </div>

                                <div class="col-12">
                                    <label class="form-label">Webhook Secret</label>
                                    <input type="password" class="form-control" name="stripe_webhook_secret" value="">
                                </div>

                                <div class="col-12">
                                    <button type="submit" class="btn btn-primary">
                                        <i class="bi bi-save me-2"></i>Save Changes
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>

                <div class="admin-card">
                    <div class="admin-card-header">
                        <h5 class="mb-0 fw-bold">PayPal Configuration</h5>
                    </div>
                    <div class="admin-card-body">
                        <form action="<?php echo e(route('admin.settings.update', 'paypal')); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <div class="row g-3">
                                <div class="col-12">
                                    <div class="form-check form-switch">
                                        <input class="form-check-input" type="checkbox" name="paypal_enabled" id="paypalEnabled">
                                        <label class="form-check-label fw-semibold" for="paypalEnabled">
                                            Enable PayPal Payments
                                        </label>
                                    </div>
                                </div>

                                <div class="col-12">
                                    <label class="form-label">PayPal Mode</label>
                                    <select class="form-select" name="paypal_mode">
                                        <option value="sandbox">Sandbox (Testing)</option>
                                        <option value="live">Live (Production)</option>
                                    </select>
                                </div>

                                <div class="col-12">
                                    <label class="form-label">Client ID</label>
                                    <input type="text" class="form-control" name="paypal_client_id" value="">
                                </div>

                                <div class="col-12">
                                    <label class="form-label">Client Secret</label>
                                    <input type="password" class="form-control" name="paypal_secret" value="">
                                </div>

                                <div class="col-12">
                                    <button type="submit" class="btn btn-primary">
                                        <i class="bi bi-save me-2"></i>Save Changes
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

            <!-- SMS Settings -->
            <div class="tab-pane fade" id="sms">
                <div class="admin-card">
                    <div class="admin-card-header">
                        <h5 class="mb-0 fw-bold">SMS Gateway Configuration (Twilio)</h5>
                    </div>
                    <div class="admin-card-body">
                        <form action="<?php echo e(route('admin.settings.update', 'sms')); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <div class="row g-3">
                                <div class="col-12">
                                    <div class="form-check form-switch">
                                        <input class="form-check-input" type="checkbox" name="sms_enabled" id="smsEnabled" checked>
                                        <label class="form-check-label fw-semibold" for="smsEnabled">
                                            Enable SMS Notifications
                                        </label>
                                    </div>
                                </div>

                                <div class="col-12">
                                    <label class="form-label">Account SID</label>
                                    <input type="text" class="form-control" name="twilio_sid" value="">
                                </div>

                                <div class="col-12">
                                    <label class="form-label">Auth Token</label>
                                    <input type="password" class="form-control" name="twilio_token" value="">
                                </div>

                                <div class="col-12">
                                    <label class="form-label">From Number</label>
                                    <input type="text" class="form-control" name="twilio_from" value="" placeholder="+1234567890">
                                </div>

                                <div class="col-12">
                                    <button type="button" class="btn btn-outline-primary me-2" onclick="testSMS()">
                                        <i class="bi bi-phone-check me-2"></i>Send Test SMS
                                    </button>
                                    <button type="submit" class="btn btn-primary">
                                        <i class="bi bi-save me-2"></i>Save Changes
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

            <!-- Push Notifications -->
            <div class="tab-pane fade" id="push">
                <div class="admin-card">
                    <div class="admin-card-header">
                        <h5 class="mb-0 fw-bold">Firebase Cloud Messaging (FCM)</h5>
                    </div>
                    <div class="admin-card-body">
                        <form action="<?php echo e(route('admin.settings.update', 'push')); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <div class="row g-3">
                                <div class="col-12">
                                    <div class="form-check form-switch">
                                        <input class="form-check-input" type="checkbox" name="push_enabled" id="pushEnabled" checked>
                                        <label class="form-check-label fw-semibold" for="pushEnabled">
                                            Enable Push Notifications
                                        </label>
                                    </div>
                                </div>

                                <div class="col-12">
                                    <label class="form-label">Firebase Server Key</label>
                                    <input type="password" class="form-control" name="fcm_server_key" value="">
                                </div>

                                <div class="col-12">
                                    <label class="form-label">Sender ID</label>
                                    <input type="text" class="form-control" name="fcm_sender_id" value="">
                                </div>

                                <div class="col-12">
                                    <button type="submit" class="btn btn-primary">
                                        <i class="bi bi-save me-2"></i>Save Changes
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

            <!-- Social Login -->
            <div class="tab-pane fade" id="social">
                <div class="admin-card mb-4">
                    <div class="admin-card-header">
                        <h5 class="mb-0 fw-bold">Google OAuth</h5>
                    </div>
                    <div class="admin-card-body">
                        <form action="<?php echo e(route('admin.settings.update', 'google')); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <div class="row g-3">
                                <div class="col-12">
                                    <div class="form-check form-switch">
                                        <input class="form-check-input" type="checkbox" name="google_enabled" id="googleEnabled" checked>
                                        <label class="form-check-label fw-semibold" for="googleEnabled">
                                            Enable Google Sign In
                                        </label>
                                    </div>
                                </div>

                                <div class="col-12">
                                    <label class="form-label">Client ID</label>
                                    <input type="text" class="form-control" name="google_client_id" value="">
                                </div>

                                <div class="col-12">
                                    <label class="form-label">Client Secret</label>
                                    <input type="password" class="form-control" name="google_client_secret" value="">
                                </div>

                                <div class="col-12">
                                    <button type="submit" class="btn btn-primary">
                                        <i class="bi bi-save me-2"></i>Save Changes
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>

                <div class="admin-card">
                    <div class="admin-card-header">
                        <h5 class="mb-0 fw-bold">Facebook OAuth</h5>
                    </div>
                    <div class="admin-card-body">
                        <form action="<?php echo e(route('admin.settings.update', 'facebook')); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <div class="row g-3">
                                <div class="col-12">
                                    <div class="form-check form-switch">
                                        <input class="form-check-input" type="checkbox" name="facebook_enabled" id="facebookEnabled">
                                        <label class="form-check-label fw-semibold" for="facebookEnabled">
                                            Enable Facebook Sign In
                                        </label>
                                    </div>
                                </div>

                                <div class="col-12">
                                    <label class="form-label">App ID</label>
                                    <input type="text" class="form-control" name="facebook_app_id" value="">
                                </div>

                                <div class="col-12">
                                    <label class="form-label">App Secret</label>
                                    <input type="password" class="form-control" name="facebook_app_secret" value="">
                                </div>

                                <div class="col-12">
                                    <button type="submit" class="btn btn-primary">
                                        <i class="bi bi-save me-2"></i>Save Changes
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

            <!-- Security Settings -->
            <div class="tab-pane fade" id="security">
                <div class="admin-card">
                    <div class="admin-card-header">
                        <h5 class="mb-0 fw-bold">Security Configuration</h5>
                    </div>
                    <div class="admin-card-body">
                        <form action="<?php echo e(route('admin.settings.update', 'security')); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <div class="row g-3">
                                <div class="col-12">
                                    <div class="form-check form-switch">
                                        <input class="form-check-input" type="checkbox" name="force_https" id="forceHttps" checked>
                                        <label class="form-check-label fw-semibold" for="forceHttps">
                                            Force HTTPS
                                        </label>
                                    </div>
                                </div>

                                <div class="col-12">
                                    <div class="form-check form-switch">
                                        <input class="form-check-input" type="checkbox" name="two_factor_enabled" id="twoFactor" checked>
                                        <label class="form-check-label fw-semibold" for="twoFactor">
                                            Enable Two-Factor Authentication
                                        </label>
                                    </div>
                                </div>

                                <div class="col-12">
                                    <label class="form-label">Session Timeout (minutes)</label>
                                    <input type="number" class="form-control" name="session_timeout" value="120">
                                </div>

                                <div class="col-12">
                                    <label class="form-label">Max Login Attempts</label>
                                    <input type="number" class="form-control" name="max_login_attempts" value="5">
                                </div>

                                <div class="col-12">
                                    <label class="form-label">Lockout Duration (minutes)</label>
                                    <input type="number" class="form-control" name="lockout_duration" value="15">
                                </div>

                                <div class="col-12">
                                    <button type="submit" class="btn btn-primary">
                                        <i class="bi bi-save me-2"></i>Save Changes
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

            <!-- Maintenance Mode -->
            <div class="tab-pane fade" id="maintenance">
                <div class="admin-card">
                    <div class="admin-card-header">
                        <h5 class="mb-0 fw-bold">Maintenance Mode</h5>
                    </div>
                    <div class="admin-card-body">
                        <div class="alert alert-warning">
                            <i class="bi bi-exclamation-triangle me-2"></i>
                            <strong>Warning:</strong> Enabling maintenance mode will make the platform unavailable to all users except administrators.
                        </div>

                        <form action="<?php echo e(route('admin.settings.maintenance')); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <div class="row g-3">
                                <div class="col-12">
                                    <div class="form-check form-switch">
                                        <input class="form-check-input" type="checkbox" name="maintenance_mode" id="maintenanceMode">
                                        <label class="form-check-label fw-semibold" for="maintenanceMode">
                                            Enable Maintenance Mode
                                        </label>
                                    </div>
                                </div>

                                <div class="col-12">
                                    <label class="form-label">Maintenance Message</label>
                                    <textarea class="form-control" name="maintenance_message" rows="3">We're currently performing scheduled maintenance. We'll be back shortly!</textarea>
                                </div>

                                <div class="col-12">
                                    <label class="form-label">Expected Return Time</label>
                                    <input type="datetime-local" class="form-control" name="expected_return">
                                </div>

                                <div class="col-12">
                                    <button type="submit" class="btn btn-warning">
                                        <i class="bi bi-tools me-2"></i>Update Maintenance Mode
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
function testEmail() {
    const email = prompt('Enter email address to send test to:');
    if (email) {
        fetch('/admin/settings/test-email', {
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
                'Content-Type': 'application/json'
            },
            body: JSON.stringify({ email })
        })
        .then(response => response.json())
        .then(data => {
            alert(data.message);
        });
    }
}

function testSMS() {
    const phone = prompt('Enter phone number to send test SMS to (with country code):');
    if (phone) {
        fetch('/admin/settings/test-sms', {
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
                'Content-Type': 'application/json'
            },
            body: JSON.stringify({ phone })
        })
        .then(response => response.json())
        .then(data => {
            alert(data.message);
        });
    }
}
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\privasee\resources\views/admin/settings/index.blade.php ENDPATH**/ ?>