<?php $__env->startSection('content'); ?>
<div class="container mt-4">
    <div class="row mb-4">
        <div class="col">
            <h1>Start New Chat</h1>
            <p class="text-muted">Create a conversation with your team members</p>
        </div>
    </div>

    <div class="row">
        <div class="col-md-8">
            <div class="card">
                <div class="card-body">
                    <?php if(count($participants) > 0): ?>
                        <form action="<?php echo e(route('business.chats.store')); ?>" method="POST">
                            <?php echo csrf_field(); ?>

                            <!-- Subject -->
                            <div class="mb-4">
                                <label for="subject" class="form-label fw-bold">Chat Subject</label>
                                <input type="text" class="form-control <?php $__errorArgs = ['subject'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                       id="subject" name="subject" value="<?php echo e(old('subject')); ?>"
                                       placeholder="e.g., Project Discussion" required>
                                <?php $__errorArgs = ['subject'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <!-- Participants -->
                            <div class="mb-4">
                                <label for="participants" class="form-label fw-bold">Select Team Members</label>
                                <div class="list-group" id="participants-list">
                                    <?php $__currentLoopData = $participants; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $participant): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="list-group-item">
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox"
                                                       id="participant<?php echo e($participant['id']); ?>"
                                                       name="participant_ids[]"
                                                       value="<?php echo e($participant['id']); ?>"
                                                       <?php echo e(in_array($participant['id'], old('participant_ids', [])) ? 'checked' : ''); ?>>
                                                <label class="form-check-label w-100" for="participant<?php echo e($participant['id']); ?>">
                                                    <div class="d-flex justify-content-between align-items-center">
                                                        <div>
                                                            <strong><?php echo e($participant['name']); ?></strong>
                                                            <br>
                                                            <small class="text-muted"><?php echo e($participant['email']); ?></small>
                                                        </div>
                                                        <span class="badge bg-info"><?php echo e(ucfirst($participant['role'])); ?></span>
                                                    </div>
                                                </label>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                                <small class="text-muted d-block mt-2">
                                    Select one or more team members to include in the chat
                                </small>
                                <?php $__errorArgs = ['participant_ids'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="text-danger mt-2"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <!-- Initial Message -->
                            <div class="mb-4">
                                <label for="message" class="form-label fw-bold">Initial Message (Optional)</label>
                                <textarea class="form-control <?php $__errorArgs = ['message'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                          id="message" name="message" rows="4"
                                          placeholder="Type your first message..."><?php echo e(old('message')); ?></textarea>
                                <?php $__errorArgs = ['message'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <!-- Buttons -->
                            <div class="d-flex gap-2">
                                <button type="submit" class="btn btn-primary">
                                    <i class="bi bi-chat-dots"></i> Start Chat
                                </button>
                                <a href="<?php echo e(route('business.chats.index')); ?>" class="btn btn-secondary">
                                    Cancel
                                </a>
                            </div>
                        </form>
                    <?php else: ?>
                        <div class="alert alert-info text-center">
                            <i class="bi bi-info-circle" style="font-size: 2rem;"></i>
                            <h5 class="mt-3">No Team Members Available</h5>
                            <p class="text-muted mb-0">You need to have active team members to start a chat. Please invite team members first.</p>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <div class="col-md-4">
            <div class="card bg-light">
                <div class="card-body">
                    <h5 class="card-title">Tips</h5>
                    <ul class="small mb-0">
                        <li>Only active team members appear here</li>
                        <li>You can start a direct message or group chat</li>
                        <li>All participants will be notified</li>
                        <li>Optionally send a first message</li>
                        <li>Only you can delete the chat</li>
                    </ul>
                </div>
            </div>

            <div class="card mt-3">
                <div class="card-body">
                    <h5 class="card-title text-info">Business Only</h5>
                    <p class="small mb-0">
                        <strong>Only your business team members</strong> are shown here. You can only chat with people in your organization.
                    </p>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.business', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\privasee\resources\views/business/chats/create.blade.php ENDPATH**/ ?>