<?php $__env->startSection('title', 'User Management'); ?>

<?php $__env->startSection('content'); ?>
<div class="d-flex justify-content-between align-items-center mb-4">
    <div>
        <h2 class="fw-bold mb-1">User Management</h2>
        <p class="text-muted mb-0">Manage all platform users and their accounts</p>
    </div>
    <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#createUserModal">
        <i class="bi bi-plus-lg me-2"></i>Add New User
    </button>
</div>

<!-- Stats Cards -->
<div class="row g-4 mb-4">
    <div class="col-md-3">
        <div class="stat-card">
            <div class="stat-label">Total Users</div>
            <div class="stat-value" style="font-size: 28px;"><?php echo e(number_format($stats['total'] ?? 12547)); ?></div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="stat-card">
            <div class="stat-label">Active Users</div>
            <div class="stat-value" style="font-size: 28px; color: var(--admin-secondary);"><?php echo e(number_format($stats['active'] ?? 11890)); ?></div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="stat-card">
            <div class="stat-label">New This Month</div>
            <div class="stat-value" style="font-size: 28px;"><?php echo e(number_format($stats['new_month'] ?? 342)); ?></div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="stat-card">
            <div class="stat-label">Suspended</div>
            <div class="stat-value" style="font-size: 28px; color: var(--admin-danger);"><?php echo e(number_format($stats['suspended'] ?? 23)); ?></div>
        </div>
    </div>
</div>

<!-- Filters & Search -->
<div class="admin-card mb-4">
    <div class="admin-card-body">
        <form method="GET" class="row g-3">
            <div class="col-md-4">
                <input type="text" class="form-control" name="search" placeholder="Search by name, email, phone..."
                       value="<?php echo e(request('search')); ?>">
            </div>
            <div class="col-md-2">
                <select class="form-select" name="status">
                    <option value="">All Status</option>
                    <option value="active" <?php echo e(request('status') === 'active' ? 'selected' : ''); ?>>Active</option>
                    <option value="inactive" <?php echo e(request('status') === 'inactive' ? 'selected' : ''); ?>>Inactive</option>
                    <option value="suspended" <?php echo e(request('status') === 'suspended' ? 'selected' : ''); ?>>Suspended</option>
                </select>
            </div>
            <div class="col-md-2">
                <select class="form-select" name="role">
                    <option value="">All Roles</option>
                    <option value="user" <?php echo e(request('role') === 'user' ? 'selected' : ''); ?>>User</option>
                    <option value="business_owner" <?php echo e(request('role') === 'business_owner' ? 'selected' : ''); ?>>Business Owner</option>
                    <option value="admin" <?php echo e(request('role') === 'admin' ? 'selected' : ''); ?>>Admin</option>
                </select>
            </div>
            <div class="col-md-2">
                <select class="form-select" name="sort">
                    <option value="newest">Newest First</option>
                    <option value="oldest" <?php echo e(request('sort') === 'oldest' ? 'selected' : ''); ?>>Oldest First</option>
                    <option value="name_asc" <?php echo e(request('sort') === 'name_asc' ? 'selected' : ''); ?>>Name A-Z</option>
                    <option value="name_desc" <?php echo e(request('sort') === 'name_desc' ? 'selected' : ''); ?>>Name Z-A</option>
                </select>
            </div>
            <div class="col-md-2">
                <button type="submit" class="btn btn-primary w-100">
                    <i class="bi bi-search me-2"></i>Filter
                </button>
            </div>
        </form>
    </div>
</div>

<!-- Users Table -->
<div class="admin-card">
    <div class="admin-card-header d-flex justify-content-between align-items-center">
        <h5 class="mb-0 fw-bold">All Users (<?php echo e(isset($users) ? $users->total() : 0); ?>)</h5>
        <div class="btn-group btn-group-sm">
            <button class="btn btn-outline-primary" onclick="exportUsers('csv')">
                <i class="bi bi-file-earmark-spreadsheet me-1"></i>CSV
            </button>
            <button class="btn btn-outline-primary" onclick="exportUsers('excel')">
                <i class="bi bi-file-earmark-excel me-1"></i>Excel
            </button>
        </div>
    </div>
    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="table table-hover mb-0">
                <thead>
                    <tr>
                        <th style="width: 50px;">
                            <input type="checkbox" class="form-check-input" id="selectAll">
                        </th>
                        <th>User</th>
                        <th>Email</th>
                        <th>Phone</th>
                        <th>Role</th>
                        <th>Joined</th>
                        <th>Last Active</th>
                        <th>Status</th>
                        <th style="width: 120px;">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if(isset($users)): ?>
                    <?php $__empty_1 = true; $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td>
                            <input type="checkbox" class="form-check-input user-checkbox" value="<?php echo e($user->id); ?>">
                        </td>
                        <td>
                            <div class="d-flex align-items-center">
                                <img src="<?php echo e($user->avatar ?? 'https://ui-avatars.com/api/?name='.urlencode($user->full_name ?? 'User')); ?>"
                                     class="rounded-circle me-2" width="40" height="40" alt="<?php echo e($user->full_name ?? 'User'); ?>">
                                <div>
                                    <div class="fw-semibold"><?php echo e($user->full_name ?? 'N/A'); ?></div>
                                    <small class="text-muted">ID: <?php echo e($user->id ?? 'N/A'); ?></small>
                                </div>
                            </div>
                        </td>
                        <td><?php echo e($user->email); ?></td>
                        <td><?php echo e($user->phone ?? 'N/A'); ?></td>
                        <td>
                            <?php if($user->role === 'admin'): ?>
                                <span class="badge bg-danger">Admin</span>
                            <?php elseif($user->role === 'business_owner'): ?>
                                <span class="badge bg-primary">Business Owner</span>
                            <?php else: ?>
                                <span class="badge bg-secondary">User</span>
                            <?php endif; ?>
                        </td>
                        <td><?php echo e($user->created_at->format('M d, Y')); ?></td>
                        <td><?php echo e($user->last_login_at ? $user->last_login_at->diffForHumans() : 'Never'); ?></td>
                        <td>
                            <?php if($user->status === 'active'): ?>
                                <span class="badge bg-success">Active</span>
                            <?php elseif($user->status === 'suspended'): ?>
                                <span class="badge bg-danger">Suspended</span>
                            <?php else: ?>
                                <span class="badge bg-secondary">Inactive</span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <div class="table-actions">
                                <button class="btn btn-icon btn-outline-primary" onclick="viewUser(<?php echo e($user->id); ?>)">
                                    <i class="bi bi-eye"></i>
                                </button>
                                <button class="btn btn-icon btn-outline-success" onclick="editUser(<?php echo e($user->id); ?>)">
                                    <i class="bi bi-pencil"></i>
                                </button>
                                <button class="btn btn-icon btn-outline-danger" onclick="deleteUser(<?php echo e($user->id); ?>)">
                                    <i class="bi bi-trash"></i>
                                </button>
                            </div>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="9" class="text-center py-5">
                            <i class="bi bi-people fs-1 text-muted d-block mb-3"></i>
                            <h5>No users found</h5>
                            <p class="text-muted">Try adjusting your filters</p>
                        </td>
                    </tr>
                    <?php endif; ?>
                    <?php else: ?>
                    <tr>
                        <td colspan="9" class="text-center py-5">
                            <i class="bi bi-exclamation-triangle fs-1 text-warning d-block mb-3"></i>
                            <h5>No data available</h5>
                            <p class="text-muted">Unable to load users</p>
                        </td>
                    </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
    <?php if(isset($users) && $users->hasPages()): ?>
    <div class="card-footer bg-white">
        <?php echo e($users->links()); ?>

    </div>
    <?php endif; ?>
</div>

<!-- Create User Modal -->
<div class="modal fade" id="createUserModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <form action="<?php echo e(route('admin.users.store')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <div class="modal-header">
                    <h5 class="modal-title">Create New User</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="row g-3">
                        <div class="col-md-6">
                            <label class="form-label">First Name <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" name="first_name" required>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Last Name <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" name="last_name" required>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Email <span class="text-danger">*</span></label>
                            <input type="email" class="form-control" name="email" required>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Phone</label>
                            <input type="tel" class="form-control" name="phone">
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Password <span class="text-danger">*</span></label>
                            <input type="password" class="form-control" name="password" required>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Role <span class="text-danger">*</span></label>
                            <select class="form-select" name="role" required>
                                <option value="user">User</option>
                                <option value="business_owner">Business Owner</option>
                                <option value="admin">Admin</option>
                            </select>
                        </div>
                        <div class="col-12">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" name="send_welcome_email" id="sendWelcome" checked>
                                <label class="form-check-label" for="sendWelcome">
                                    Send welcome email with login credentials
                                </label>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">Create User</button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
function viewUser(id) {
    window.location.href = `/admin/users/${id}`;
}

function editUser(id) {
    window.location.href = `/admin/users/${id}/edit`;
}

function deleteUser(id) {
    if (confirm('Are you sure you want to delete this user? This action cannot be undone.')) {
        fetch(`/admin/users/${id}`, {
            method: 'DELETE',
            headers: {
                'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
                'Content-Type': 'application/json'
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                location.reload();
            } else {
                alert(data.message || 'Failed to delete user');
            }
        });
    }
}

function exportUsers(format) {
    window.location.href = `/admin/users/export?format=${format}`;
}

document.getElementById('selectAll')?.addEventListener('change', function() {
    document.querySelectorAll('.user-checkbox').forEach(checkbox => {
        checkbox.checked = this.checked;
    });
});
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\privasee\resources\views/admin/users/index.blade.php ENDPATH**/ ?>