<?php $__env->startSection('title', $category->name); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <!-- Header -->
    <div class="row mb-4">
        <div class="col-md-8">
            <h1 class="h3 mb-0"><?php echo e($category->name); ?></h1>
            <p class="text-muted"><?php echo e($category->name_ar); ?></p>
        </div>
        <div class="col-md-4 text-end">
            <a href="<?php echo e(route('admin.categories.edit', $category)); ?>" class="btn btn-warning">
                <i class="fas fa-edit"></i> Edit
            </a>
            <a href="<?php echo e(route('admin.categories.index')); ?>" class="btn btn-secondary">
                <i class="fas fa-arrow-left"></i> Back
            </a>
        </div>
    </div>

    <div class="row">
        <div class="col-md-4">
            <div class="card mb-4">
                <div class="card-header">
                    <h6 class="mb-0">Icon</h6>
                </div>
                <div class="card-body text-center">
                    <?php if($category->icon): ?>
                        <img src="<?php echo e(Storage::url($category->icon)); ?>"
                            alt="<?php echo e($category->name); ?>"
                            class="img-fluid"
                            style="width: 150px; height: 150px;">
                    <?php else: ?>
                        <span class="text-muted">No icon</span>
                    <?php endif; ?>
                </div>
            </div>

            <div class="card">
                <div class="card-header bg-light">
                    <h6 class="mb-0">Information</h6>
                </div>
                <div class="card-body">
                    <p class="mb-2">
                        <strong>Slug:</strong><br>
                        <small class="text-muted"><?php echo e($category->slug); ?></small>
                    </p>
                    <p class="mb-2">
                        <strong>Status:</strong><br>
                        <span class="badge bg-<?php echo e($category->is_active ? 'success' : 'secondary'); ?>">
                            <?php echo e($category->is_active ? 'Active' : 'Inactive'); ?>

                        </span>
                    </p>
                    <p class="mb-2">
                        <strong>Created:</strong><br>
                        <small><?php echo e($category->created_at->format('M d, Y H:i')); ?></small>
                    </p>
                    <p class="mb-0">
                        <strong>Updated:</strong><br>
                        <small><?php echo e($category->updated_at->format('M d, Y H:i')); ?></small>
                    </p>
                </div>
            </div>
        </div>

        <div class="col-md-8">
            <div class="card mb-4">
                <div class="card-header">
                    <h6 class="mb-0">Description</h6>
                </div>
                <div class="card-body">
                    <h6 class="mb-2">English</h6>
                    <p class="mb-4"><?php echo e($category->description ?? 'No description'); ?></p>

                    <h6 class="mb-2">Arabic</h6>
                    <p class="mb-0" dir="rtl"><?php echo e($category->description_ar ?? 'No description'); ?></p>
                </div>
            </div>

            <?php if($category->children->count() > 0): ?>
            <div class="card mb-4">
                <div class="card-header">
                    <h6 class="mb-0">Subcategories</h6>
                </div>
                <div class="table-responsive">
                    <table class="table table-hover mb-0">
                        <thead class="table-light">
                            <tr>
                                <th>Name</th>
                                <th>Slug</th>
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $category->children; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $child): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><strong><?php echo e($child->name); ?></strong></td>
                                <td><small class="text-muted"><?php echo e($child->slug); ?></small></td>
                                <td>
                                    <span class="badge bg-<?php echo e($child->is_active ? 'success' : 'secondary'); ?>">
                                        <?php echo e($child->is_active ? 'Active' : 'Inactive'); ?>

                                    </span>
                                </td>
                                <td>
                                    <a href="<?php echo e(route('admin.categories.show', $child)); ?>" class="btn btn-sm btn-info">
                                        <i class="fas fa-eye"></i>
                                    </a>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
            <?php endif; ?>

            <?php if($venues->count() > 0): ?>
            <div class="card">
                <div class="card-header">
                    <h6 class="mb-0">Venues in this Category</h6>
                </div>
                <div class="table-responsive">
                    <table class="table table-hover mb-0">
                        <thead class="table-light">
                            <tr>
                                <th>Venue Name</th>
                                <th>Business</th>
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $venues; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $venue): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><strong><?php echo e($venue->name); ?></strong></td>
                                <td><?php echo e($venue->business->business_name ?? 'N/A'); ?></td>
                                <td>
                                    <span class="badge bg-<?php echo e($venue->status === 'active' ? 'success' : 'secondary'); ?>">
                                        <?php echo e(ucfirst($venue->status)); ?>

                                    </span>
                                </td>
                                <td>
                                    <a href="<?php echo e(route('admin.venues.show', $venue)); ?>" class="btn btn-sm btn-info">
                                        <i class="fas fa-eye"></i>
                                    </a>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
            <?php endif; ?>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\privasee\resources\views/admin/categories/show.blade.php ENDPATH**/ ?>