<?php $__env->startSection('title', 'Marketing Management'); ?>

<?php $__env->startSection('content'); ?>
    <div class="admin-header mb-4">
        <div>
            <h2>Marketing Management</h2>
            <p class="text-muted mb-0">Manage platform-wide marketing campaigns and analytics</p>
        </div>
        <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#createCampaignModal">
            <i class="bi bi-plus-circle me-2"></i>New Campaign
        </button>
    </div>

    <!-- Marketing Overview Stats -->
    <div class="row g-4 mb-4">
        <?php
            $totalCampaigns = \App\Models\MarketingCampaignAnalytic::distinct('campaign_id')->count();
            $activeCampaigns = \App\Models\MarketingCampaignAnalytic::where('status', 'active')->distinct('campaign_id')->count();
            $totalSent = \App\Models\MarketingCampaignAnalytic::sum('sent_count');
            $totalOpens = \App\Models\MarketingCampaignAnalytic::sum('opened_count');
        ?>

        <div class="col-md-6 col-lg-3">
            <div class="stat-card">
                <div class="stat-icon bg-primary">
                    <i class="bi bi-megaphone"></i>
                </div>
                <div>
                    <div class="stat-label">Total Campaigns</div>
                    <div class="stat-value"><?php echo e(number_format($totalCampaigns)); ?></div>
                </div>
            </div>
        </div>

        <div class="col-md-6 col-lg-3">
            <div class="stat-card">
                <div class="stat-icon bg-success">
                    <i class="bi bi-play-circle"></i>
                </div>
                <div>
                    <div class="stat-label">Active Campaigns</div>
                    <div class="stat-value"><?php echo e(number_format($activeCampaigns)); ?></div>
                </div>
            </div>
        </div>

        <div class="col-md-6 col-lg-3">
            <div class="stat-card">
                <div class="stat-icon bg-info">
                    <i class="bi bi-envelope"></i>
                </div>
                <div>
                    <div class="stat-label">Total Sent</div>
                    <div class="stat-value"><?php echo e(number_format($totalSent)); ?></div>
                </div>
            </div>
        </div>

        <div class="col-md-6 col-lg-3">
            <div class="stat-card">
                <div class="stat-icon bg-warning">
                    <i class="bi bi-eye"></i>
                </div>
                <div>
                    <div class="stat-label">Total Opens</div>
                    <div class="stat-value"><?php echo e(number_format($totalOpens)); ?></div>
                    <?php if($totalSent > 0): ?>
                        <small class="text-muted"><?php echo e(number_format(($totalOpens / $totalSent) * 100, 1)); ?>% rate</small>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <!-- Campaign Types Tabs -->
    <ul class="nav nav-tabs mb-4" role="tablist">
        <li class="nav-item">
            <a class="nav-link active" data-bs-toggle="tab" href="#email-campaigns">
                <i class="bi bi-envelope me-2"></i>Email Campaigns
            </a>
        </li>
        <li class="nav-item">
            <a class="nav-link" data-bs-toggle="tab" href="#push-campaigns">
                <i class="bi bi-bell me-2"></i>Push Notifications
            </a>
        </li>
        <li class="nav-item">
            <a class="nav-link" data-bs-toggle="tab" href="#sms-campaigns">
                <i class="bi bi-chat-text me-2"></i>SMS Campaigns
            </a>
        </li>
        <li class="nav-item">
            <a class="nav-link" data-bs-toggle="tab" href="#analytics">
                <i class="bi bi-graph-up me-2"></i>Analytics
            </a>
        </li>
    </ul>

    <div class="tab-content">
        <!-- Email Campaigns Tab -->
        <div class="tab-pane fade show active" id="email-campaigns">
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-white border-bottom">
                    <h5 class="mb-0 fw-bold">Email Campaigns</h5>
                </div>
                <div class="card-body p-0">
                    <div class="table-responsive">
                        <table class="table table-hover mb-0">
                            <thead class="bg-light">
                            <tr>
                                <th>Campaign Name</th>
                                <th>Target Audience</th>
                                <th>Sent</th>
                                <th>Opens</th>
                                <th>Clicks</th>
                                <th>Status</th>
                                <th>Scheduled</th>
                                <th>Actions</th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php
                                $emailCampaigns = \App\Models\MarketingCampaignAnalytic::where('campaign_type', 'email')
                                    ->orderBy('created_at', 'desc')
                                    ->take(20)
                                    ->get();
                            ?>

                            <?php $__empty_1 = true; $__currentLoopData = $emailCampaigns; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $campaign): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td class="fw-semibold"><?php echo e($campaign->campaign_name); ?></td>
                                    <td><?php echo e(ucfirst($campaign->target_audience ?? 'All Users')); ?></td>
                                    <td><?php echo e(number_format($campaign->sent_count)); ?></td>
                                    <td>
                                        <?php echo e(number_format($campaign->opened_count)); ?>

                                        <?php if($campaign->sent_count > 0): ?>
                                            <small class="text-muted">(<?php echo e(number_format(($campaign->opened_count / $campaign->sent_count) * 100, 1)); ?>%)</small>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php echo e(number_format($campaign->clicked_count)); ?>

                                        <?php if($campaign->sent_count > 0): ?>
                                            <small class="text-muted">(<?php echo e(number_format(($campaign->clicked_count / $campaign->sent_count) * 100, 1)); ?>%)</small>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php if($campaign->status === 'active'): ?>
                                            <span class="badge bg-success">Active</span>
                                        <?php elseif($campaign->status === 'completed'): ?>
                                            <span class="badge bg-primary">Completed</span>
                                        <?php elseif($campaign->status === 'scheduled'): ?>
                                            <span class="badge bg-warning">Scheduled</span>
                                        <?php else: ?>
                                            <span class="badge bg-secondary">Draft</span>
                                        <?php endif; ?>
                                    </td>
                                    <td><?php echo e($campaign->scheduled_at ? $campaign->scheduled_at->format('M d, Y') : '-'); ?></td>
                                    <td>
                                        <div class="btn-group btn-group-sm">
                                            <button class="btn btn-outline-primary" onclick="viewCampaign(<?php echo e($campaign->id); ?>)">
                                                <i class="bi bi-eye"></i>
                                            </button>
                                            <button class="btn btn-outline-secondary" onclick="duplicateCampaign(<?php echo e($campaign->id); ?>)">
                                                <i class="bi bi-files"></i>
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="8" class="text-center py-4 text-muted">
                                        No email campaigns found
                                    </td>
                                </tr>
                            <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <!-- Push Notifications Tab -->
        <div class="tab-pane fade" id="push-campaigns">
            <div class="card border-0 shadow-sm">
                <div class="card-body text-center py-5">
                    <i class="bi bi-bell" style="font-size: 4rem; color: #ccc;"></i>
                    <h4 class="mt-3">Push Notification Campaigns</h4>
                    <p class="text-muted">Send targeted push notifications to users</p>
                    <button class="btn btn-primary">
                        <i class="bi bi-plus-circle me-2"></i>Create Push Campaign
                    </button>
                </div>
            </div>
        </div>

        <!-- SMS Campaigns Tab -->
        <div class="tab-pane fade" id="sms-campaigns">
            <div class="card border-0 shadow-sm">
                <div class="card-body text-center py-5">
                    <i class="bi bi-chat-text" style="font-size: 4rem; color: #ccc;"></i>
                    <h4 class="mt-3">SMS Campaigns</h4>
                    <p class="text-muted">Reach users via SMS marketing</p>
                    <button class="btn btn-primary">
                        <i class="bi bi-plus-circle me-2"></i>Create SMS Campaign
                    </button>
                </div>
            </div>
        </div>

        <!-- Analytics Tab -->
        <div class="tab-pane fade" id="analytics">
            <div class="row g-4">
                <div class="col-lg-8">
                    <div class="card border-0 shadow-sm">
                        <div class="card-header bg-white border-bottom">
                            <h5 class="mb-0 fw-bold">Campaign Performance</h5>
                        </div>
                        <div class="card-body">
                            <canvas id="campaignChart" height="80"></canvas>
                        </div>
                    </div>
                </div>

                <div class="col-lg-4">
                    <div class="card border-0 shadow-sm">
                        <div class="card-header bg-white border-bottom">
                            <h5 class="mb-0 fw-bold">Top Performing</h5>
                        </div>
                        <div class="card-body">
                            <?php
                                $topCampaigns = \App\Models\MarketingCampaignAnalytic::orderBy('opened_count', 'desc')
                                    ->take(5)
                                    ->get();
                            ?>

                            <?php $__currentLoopData = $topCampaigns; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $top): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="mb-3 pb-3 border-bottom">
                                    <div class="fw-semibold mb-1"><?php echo e($top->campaign_name); ?></div>
                                    <div class="progress" style="height: 8px;">
                                        <div class="progress-bar bg-success"
                                             style="width: <?php echo e($top->sent_count > 0 ? ($top->opened_count / $top->sent_count) * 100 : 0); ?>%">
                                        </div>
                                    </div>
                                    <small class="text-muted">
                                        <?php echo e(number_format($top->opened_count)); ?> opens / <?php echo e(number_format($top->sent_count)); ?> sent
                                    </small>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Create Campaign Modal -->
    <div class="modal fade" id="createCampaignModal" tabindex="-1">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Create Marketing Campaign</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <form action="<?php echo e(route('admin.marketing.store')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <div class="row g-3">
                            <div class="col-md-6">
                                <label class="form-label fw-semibold">Campaign Name</label>
                                <input type="text" name="campaign_name" class="form-control" required>
                            </div>

                            <div class="col-md-6">
                                <label class="form-label fw-semibold">Campaign Type</label>
                                <select name="campaign_type" class="form-select" required>
                                    <option value="email">Email</option>
                                    <option value="push">Push Notification</option>
                                    <option value="sms">SMS</option>
                                </select>
                            </div>

                            <div class="col-md-6">
                                <label class="form-label fw-semibold">Target Audience</label>
                                <select name="target_audience" class="form-select">
                                    <option value="all">All Users</option>
                                    <option value="active">Active Users</option>
                                    <option value="businesses">Business Owners</option>
                                    <option value="subscribers">Subscribers</option>
                                </select>
                            </div>

                            <div class="col-md-6">
                                <label class="form-label fw-semibold">Schedule</label>
                                <input type="datetime-local" name="scheduled_at" class="form-control">
                            </div>

                            <div class="col-12">
                                <label class="form-label fw-semibold">Subject / Title</label>
                                <input type="text" name="subject" class="form-control" required>
                            </div>

                            <div class="col-12">
                                <label class="form-label fw-semibold">Message</label>
                                <textarea name="message" class="form-control" rows="5" required></textarea>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                        <button type="submit" name="action" value="draft" class="btn btn-outline-primary">
                            Save as Draft
                        </button>
                        <button type="submit" name="action" value="send" class="btn btn-primary">
                            Send Campaign
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script>
        function viewCampaign(id) {
            window.location.href = `/admin/marketing/campaigns/${id}`;
        }

        function duplicateCampaign(id) {
            if (confirm('Duplicate this campaign?')) {
                // Handle duplication
            }
        }

        // Campaign Performance Chart
        const ctx = document.getElementById('campaignChart');
        if (ctx) {
            new Chart(ctx, {
                type: 'line',
                data: {
                    labels: ['Week 1', 'Week 2', 'Week 3', 'Week 4'],
                    datasets: [{
                        label: 'Sent',
                        data: [1200, 1900, 3000, 2500],
                        borderColor: '#667eea',
                        tension: 0.4
                    }, {
                        label: 'Opens',
                        data: [800, 1400, 2200, 1800],
                        borderColor: '#10b981',
                        tension: 0.4
                    }, {
                        label: 'Clicks',
                        data: [400, 700, 1100, 900],
                        borderColor: '#f59e0b',
                        tension: 0.4
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: true,
                    plugins: {
                        legend: {
                            position: 'top',
                        }
                    }
                }
            });
        }
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\privasee\resources\views/admin/marketing/index.blade.php ENDPATH**/ ?>