<?php $__env->startSection('title', 'Plan Subscribers'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid py-4">
    <div class="row mb-4">
        <div class="col">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <h2 class="mb-1"><?php echo e($plan->name); ?> - Subscribers</h2>
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>">Dashboard</a></li>
                            <li class="breadcrumb-item"><a href="<?php echo e(route('admin.subscription-plans.index')); ?>">Plans</a></li>
                            <li class="breadcrumb-item active">Subscribers</li>
                        </ol>
                    </nav>
                </div>
                <div>
                    <a href="<?php echo e(route('admin.subscription-plans.index')); ?>" class="btn btn-outline-secondary">
                        <i class="bi bi-arrow-left me-2"></i>Back to Plans
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Plan Summary Card -->
    <div class="row mb-4">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    <div class="row align-items-center">
                        <div class="col-md-3">
                            <h5 class="mb-1"><?php echo e($plan->name); ?></h5>
                            <p class="text-muted mb-0">AED <?php echo e(number_format($plan->price, 2)); ?> / <?php echo e($plan->duration_type); ?></p>
                        </div>
                        <div class="col-md-9">
                            <div class="row text-center">
                                <div class="col">
                                    <h3 class="mb-0"><?php echo e($subscriptions->total()); ?></h3>
                                    <small class="text-muted">Total Subscribers</small>
                                </div>
                                <div class="col">
                                    <h3 class="mb-0"><?php echo e($plan->activeSubscriptions()->count()); ?></h3>
                                    <small class="text-muted">Active</small>
                                </div>
                                <div class="col">
                                    <h3 class="mb-0"><?php echo e($plan->subscriptions()->where('status', 'expired')->count()); ?></h3>
                                    <small class="text-muted">Expired</small>
                                </div>
                                <div class="col">
                                    <h3 class="mb-0">AED <?php echo e(number_format($plan->payments()->sum('amount'), 2)); ?></h3>
                                    <small class="text-muted">Revenue</small>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Subscribers Table -->
    <div class="card">
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover mb-0">
                    <thead class="bg-light">
                        <tr>
                            <th>Business</th>
                            <th>Owner</th>
                            <th>Start Date</th>
                            <th>End Date</th>
                            <th>Amount</th>
                            <th>Payment Method</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $subscriptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subscription): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td>
                                <div class="d-flex align-items-center">
                                    <?php if($subscription->business && $subscription->business->logo): ?>
                                        <img src="<?php echo e(Storage::url($subscription->business->logo)); ?>"
                                             class="rounded me-2" width="40" height="40" style="object-fit: cover;">
                                    <?php endif; ?>
                                    <div>
                                        <div class="fw-medium"><?php echo e($subscription->business->business_name ?? 'N/A'); ?></div>
                                        <small class="text-muted">ID: #<?php echo e($subscription->business_id); ?></small>
                                    </div>
                                </div>
                            </td>
                            <td>
                                <?php if($subscription->business && $subscription->business->owner): ?>
                                    <div><?php echo e($subscription->business->owner->full_name); ?></div>
                                    <small class="text-muted"><?php echo e($subscription->business->owner->email); ?></small>
                                <?php else: ?>
                                    <span class="text-muted">—</span>
                                <?php endif; ?>
                            </td>
                            <td><?php echo e($subscription->start_date->format('M d, Y')); ?></td>
                            <td><?php echo e($subscription->end_date->format('M d, Y')); ?></td>
                            <td>AED <?php echo e(number_format($subscription->amount, 2)); ?></td>
                            <td>
                                <span class="badge bg-info"><?php echo e(ucfirst($subscription->payment_method)); ?></span>
                            </td>
                            <td>
                                <?php if($subscription->status === 'active'): ?>
                                    <span class="badge bg-success">Active</span>
                                <?php elseif($subscription->status === 'expired'): ?>
                                    <span class="badge bg-danger">Expired</span>
                                <?php elseif($subscription->status === 'cancelled'): ?>
                                    <span class="badge bg-secondary">Cancelled</span>
                                <?php else: ?>
                                    <span class="badge bg-warning"><?php echo e(ucfirst($subscription->status)); ?></span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <div class="btn-group btn-group-sm">
                                    <a href="<?php echo e(route('admin.businesses.show', $subscription->business_id)); ?>"
                                       class="btn btn-outline-primary" title="View Business">
                                        <i class="bi bi-eye"></i>
                                    </a>
                                </div>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="8" class="text-center py-5">
                                <i class="bi bi-inbox text-muted" style="font-size: 48px;"></i>
                                <p class="text-muted mt-2">No subscribers yet</p>
                            </td>
                        </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>

        <?php if($subscriptions->hasPages()): ?>
        <div class="card-footer">
            <?php echo e($subscriptions->links()); ?>

        </div>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\privasee\resources\views/admin/subscription-plans/subscribers.blade.php ENDPATH**/ ?>