<?php $__env->startSection('title', 'Business Staff Management'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <!-- Header -->
    <div class="row mb-4">
        <div class="col-md-8">
            <h1 class="h3 mb-0">
                <i class="fas fa-user-tie"></i> Business Staff
            </h1>
            <p class="text-muted">Manage all business staff members</p>
        </div>
    </div>

    <!-- Filters -->
    <div class="card mb-4">
        <div class="card-body">
            <form method="get" class="row g-3">
                <div class="col-md-3">
                    <input type="text" name="search" class="form-control form-control-sm"
                        placeholder="Search staff..." value="<?php echo e(request('search')); ?>">
                </div>
                <div class="col-md-2">
                    <select name="status" class="form-select form-select-sm">
                        <option value="">All Status</option>
                        <option value="active" <?php echo e(request('status') === 'active' ? 'selected' : ''); ?>>Active</option>
                        <option value="pending_invitation" <?php echo e(request('status') === 'pending_invitation' ? 'selected' : ''); ?>>Pending</option>
                    </select>
                </div>
                <div class="col-md-2">
                    <select name="role" class="form-select form-select-sm">
                        <option value="">All Roles</option>
                        <option value="owner" <?php echo e(request('role') === 'owner' ? 'selected' : ''); ?>>Owner</option>
                        <option value="manager" <?php echo e(request('role') === 'manager' ? 'selected' : ''); ?>>Manager</option>
                        <option value="staff" <?php echo e(request('role') === 'staff' ? 'selected' : ''); ?>>Staff</option>
                    </select>
                </div>
                <div class="col-md-3">
                    <select name="business_id" class="form-select form-select-sm">
                        <option value="">All Businesses</option>
                        <?php if(isset($businesses)): ?>
                        <?php $__currentLoopData = $businesses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bid => $bname): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($bid); ?>" <?php echo e(request('business_id') == $bid ? 'selected' : ''); ?>>
                                <?php echo e($bname); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </select>
                </div>
                <div class="col-md-2">
                    <button type="submit" class="btn btn-primary btn-sm w-100">
                        <i class="fas fa-filter"></i> Filter
                    </button>
                </div>
            </form>
        </div>
    </div>

    <!-- Statistics -->
    <div class="row mb-4">
        <div class="col-md-3">
            <div class="card">
                <div class="card-body">
                    <h6 class="text-muted mb-2">Total Staff</h6>
                    <h3 class="mb-0"><?php echo e(isset($staff) && method_exists($staff, 'total') ? $staff->total() : 0); ?></h3>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card">
                <div class="card-body">
                    <h6 class="text-muted mb-2">Active</h6>
                    <h3 class="mb-0"><?php echo e($stats['active'] ?? 0); ?></h3>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card">
                <div class="card-body">
                    <h6 class="text-muted mb-2">Pending Invitations</h6>
                    <h3 class="mb-0"><?php echo e($stats['pending'] ?? 0); ?></h3>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card">
                <div class="card-body">
                    <h6 class="text-muted mb-2">In Teams</h6>
                    <h3 class="mb-0"><?php echo e($stats['in_teams'] ?? 0); ?></h3>
                </div>
            </div>
        </div>
    </div>

    <!-- Staff Table -->
    <div class="card">
        <div class="table-responsive">
            <table class="table table-hover mb-0">
                <thead class="table-light">
                    <tr>
                        <th>Name</th>
                        <th>Email</th>
                        <th>Business</th>
                        <th>Role</th>
                        <th>Team</th>
                        <th>Status</th>
                        <th>Joined</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if(isset($staff)): ?>
                    <?php $__empty_1 = true; $__currentLoopData = $staff; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $member): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td>
                            <strong><?php echo e($member->user->first_name ?? 'N/A'); ?> <?php echo e($member->user->last_name ?? ''); ?></strong>
                        </td>
                        <td><?php echo e($member->user->email ?? 'N/A'); ?></td>
                        <td>
                            <?php if($member->business): ?>
                            <a href="<?php echo e(route('admin.businesses.show', $member->business->id)); ?>">
                                <?php echo e($member->business->business_name ?? 'N/A'); ?>

                            </a>
                            <?php else: ?>
                            <span class="text-muted">N/A</span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <span class="badge bg-primary"><?php echo e(ucfirst($member->role ?? 'staff')); ?></span>
                        </td>
                        <td>
                            <?php if($member->team): ?>
                                <span class="badge bg-secondary"><?php echo e($member->team->name ?? 'N/A'); ?></span>
                            <?php else: ?>
                                <span class="text-muted">-</span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <span class="badge bg-<?php echo e($member->status === 'active' ? 'success' : 'warning'); ?>">
                                <?php echo e(ucfirst(str_replace('_', ' ', $member->status ?? 'pending'))); ?>

                            </span>
                        </td>
                        <td>
                            <?php if($member->joined_at): ?>
                                <small><?php echo e($member->joined_at->format('M d, Y')); ?></small>
                            <?php else: ?>
                                <small class="text-muted">Pending</small>
                            <?php endif; ?>
                        </td>
                        <td>
                            <a href="<?php echo e(route('admin.staff.show', $member->id)); ?>" class="btn btn-sm btn-info" title="View">
                                <i class="fas fa-eye"></i>
                            </a>
                            <a href="<?php echo e(route('admin.staff.edit', $member->id)); ?>" class="btn btn-sm btn-warning" title="Edit">
                                <i class="fas fa-edit"></i>
                            </a>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="8" class="text-center text-muted py-4">
                            No staff members found.
                        </td>
                    </tr>
                    <?php endif; ?>
                    <?php else: ?>
                    <tr>
                        <td colspan="8" class="text-center text-danger py-4">
                            <i class="fas fa-exclamation-triangle me-2"></i>Unable to load staff data
                        </td>
                    </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Pagination -->
    <div class="d-flex justify-content-between align-items-center mt-4">
        <div>
            <?php if(isset($staff) && method_exists($staff, 'firstItem')): ?>
            Showing <?php echo e($staff->firstItem() ?? 0); ?> to <?php echo e($staff->lastItem() ?? 0); ?> of <?php echo e($staff->total()); ?> staff members
            <?php else: ?>
            No data available
            <?php endif; ?>
        </div>
        <div>
            <?php if(isset($staff) && method_exists($staff, 'hasPages') && $staff->hasPages()): ?>
            <?php echo e($staff->links()); ?>

            <?php endif; ?>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\privasee\resources\views/admin/staff/index.blade.php ENDPATH**/ ?>