<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            color: #333;
        }
        .container {
            max-width: 600px;
            margin: 0 auto;
            padding: 20px;
            border: 1px solid #ddd;
            border-radius: 5px;
        }
        .header {
            background-color: #007bff;
            color: white;
            padding: 20px;
            border-radius: 5px 5px 0 0;
            text-align: center;
        }
        .content {
            padding: 20px;
        }
        .button {
            display: inline-block;
            margin: 20px 0;
            padding: 12px 30px;
            background-color: #007bff;
            color: white;
            text-decoration: none;
            border-radius: 5px;
            font-weight: bold;
        }
        .button:hover {
            background-color: #0056b3;
        }
        .link-section {
            margin: 20px 0;
            padding: 10px;
            background-color: #f8f9fa;
            border-left: 4px solid #007bff;
        }
        .footer {
            margin-top: 20px;
            padding-top: 20px;
            border-top: 1px solid #ddd;
            font-size: 12px;
            color: #666;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1><?php echo e($business->business_name ?? 'Privasee'); ?></h1>
        </div>

        <div class="content">
            <p>Hello,</p>

            <p>You have been invited to join <strong><?php echo e($business->business_name); ?></strong> as a team member with the role of <strong><?php echo e(ucfirst($role)); ?></strong>.</p>

            <p>Click the button below to create your account and get started:</p>

            <center>
                <a href="<?php echo e($invitation_link); ?>" class="button">Accept Invitation</a>
            </center>

            <div class="link-section">
                <p><strong>Or copy and paste this link in your browser:</strong></p>
                <p><a href="<?php echo e($invitation_link); ?>"><?php echo e($invitation_link); ?></a></p>
            </div>

            <p><strong>Important:</strong> This invitation will expire in 7 days.</p>

            <p>If you didn't expect this invitation, you can safely ignore this email.</p>

            <div class="footer">
                <p>Best regards,<br>
                The <?php echo e($business->business_name); ?> Team</p>

                <p>If you have any questions, please contact us at <?php echo e(config('mail.from.address') ?? 'support@privasee.com'); ?></p>
            </div>
        </div>
    </div>
</body>
</html>

<?php /**PATH C:\laragon\www\privasee\resources\views/emails/staff-invitation.blade.php ENDPATH**/ ?>