<?php $__env->startSection('title', 'Business Report'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid py-4">
    <!-- Header -->
    <div class="row mb-4">
        <div class="col-md-8">
            <h1 class="h3 mb-0">
                <i class="bi bi-shop"></i> Business Report
            </h1>
            <p class="text-muted">Business performance and metrics</p>
        </div>
        <div class="col-md-4 text-end">
            <a href="<?php echo e(route('admin.analytics.index')); ?>" class="btn btn-sm btn-secondary">
                <i class="bi bi-arrow-left"></i> Back to Analytics
            </a>
        </div>
    </div>

    <!-- Filters -->
    <div class="card border-0 shadow-sm mb-4">
        <div class="card-body">
            <form method="GET" class="row g-3">
                <div class="col-md-4">
                    <label class="form-label">Period</label>
                    <select name="period" class="form-select" onchange="this.form.submit()">
                        <option value="7" <?php echo e($period == 7 ? 'selected' : ''); ?>>Last 7 Days</option>
                        <option value="30" <?php echo e($period == 30 ? 'selected' : ''); ?>>Last 30 Days</option>
                        <option value="90" <?php echo e($period == 90 ? 'selected' : ''); ?>>Last 90 Days</option>
                    </select>
                </div>
                <div class="col-md-4">
                    <label class="form-label">Sort By</label>
                    <select name="sort" class="form-select" onchange="this.form.submit()">
                        <option value="redemptions" <?php echo e($sortBy == 'redemptions' ? 'selected' : ''); ?>>Redemptions</option>
                        <option value="rating" <?php echo e($sortBy == 'rating' ? 'selected' : ''); ?>>Rating</option>
                        <option value="revenue" <?php echo e($sortBy == 'revenue' ? 'selected' : ''); ?>>Revenue</option>
                    </select>
                </div>
                <div class="col-md-4 d-flex align-items-end gap-2">
                    <a href="<?php echo e(route('admin.analytics.reports.businesses')); ?>" class="btn btn-secondary">
                        <i class="bi bi-arrow-clockwise"></i> Reset
                    </a>
                </div>
            </form>
        </div>
    </div>

    <!-- Businesses Table -->
    <div class="card border-0 shadow-sm">
        <div class="table-responsive">
            <table class="table table-hover mb-0">
                <thead class="table-light">
                    <tr>
                        <th>Business</th>
                        <th>Owner</th>
                        <th>Status</th>
                        <th>Venues</th>
                        <th>Staff</th>
                        <th>Offers</th>
                        <th>Redemptions</th>
                        <th>Rating</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $businesses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $business): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td>
                                <small>
                                    <strong><?php echo e(Str::limit($business->business_name, 20)); ?></strong><br>
                                    <span class="text-muted"><?php echo e($business->email); ?></span>
                                </small>
                            </td>
                            <td>
                                <small><?php echo e($business->owner->first_name ?? 'N/A'); ?></small>
                            </td>
                            <td>
                                <span class="badge bg-<?php echo e($business->status === 'verified' ? 'success' : ($business->status === 'active' ? 'info' : 'warning')); ?>">
                                    <?php echo e(ucfirst($business->status)); ?>

                                </span>
                            </td>
                            <td>
                                <span class="badge bg-light text-dark"><?php echo e($business->venues_count); ?></span>
                            </td>
                            <td>
                                <span class="badge bg-light text-dark"><?php echo e($business->staff_count); ?></span>
                            </td>
                            <td>
                                <span class="badge bg-light text-dark"><?php echo e($business->offers_count); ?></span>
                            </td>
                            <td>
                                <span class="badge bg-success"><?php echo e($business->redemptions_count); ?></span>
                            </td>
                            <td>
                                <small><?php echo e(number_format($business->reviews_avg_rating ?? 0, 1)); ?>/5</small>
                            </td>
                            <td>
                                <a href="<?php echo e(route('admin.businesses.show', $business)); ?>" class="btn btn-sm btn-info" title="View">
                                    <i class="bi bi-eye"></i>
                                </a>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="9" class="text-center text-muted py-4">
                                <small>No businesses found</small>
                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

        <!-- Pagination -->
        <div class="card-footer bg-light">
            <div class="d-flex justify-content-between align-items-center">
                <small class="text-muted">
                    Showing <?php echo e($businesses->firstItem() ?? 0); ?> to <?php echo e($businesses->lastItem() ?? 0); ?> of <?php echo e($businesses->total()); ?> businesses
                </small>
                <?php echo e($businesses->links()); ?>

            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\privasee\resources\views/admin/analytics/business-report.blade.php ENDPATH**/ ?>