<?php $__env->startSection('title', 'Content Moderation'); ?>

<?php $__env->startSection('content'); ?>
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h2 class="fw-bold mb-1">Content Moderation</h2>
            <p class="text-muted mb-0">Review and moderate platform content</p>
        </div>
    </div>

    <div class="row g-4 mb-4">
        <div class="col-md-4">
            <div class="stat-card">
                <div class="stat-icon" style="background: linear-gradient(135deg, #fbbc04 0%, #ffa000 100%); color: white;">
                    <i class="bi bi-hourglass-split"></i>
                </div>
                <div class="stat-label">Pending Spotlights</div>
                <div class="stat-value"><?php echo e($pendingSpotlights ?? 0); ?></div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="stat-card">
                <div class="stat-icon" style="background: linear-gradient(135deg, #ea4335 0%, #f44336 100%); color: white;">
                    <i class="bi bi-flag-fill"></i>
                </div>
                <div class="stat-label">Flagged Content</div>
                <div class="stat-value"><?php echo e($flaggedContent ?? 0); ?></div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="stat-card">
                <div class="stat-icon" style="background: linear-gradient(135deg, #1a73e8 0%, #4285f4 100%); color: white;">
                    <i class="bi bi-star"></i>
                </div>
                <div class="stat-label">Pending Reviews</div>
                <div class="stat-value"><?php echo e($pendingReviews ?? 0); ?></div>
            </div>
        </div>
    </div>

    <div class="row g-4">
        <div class="col-lg-6">
            <div class="admin-card">
                <div class="admin-card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0 fw-bold">Pending Spotlights</h5>
                    <a href="<?php echo e(route('admin.spotlights.index', ['status' => 'pending'])); ?>" class="btn btn-sm btn-outline-primary">View All</a>
                </div>
                <div class="card-body">
                    <p class="text-muted">Review spotlights waiting for approval</p>
                    <a href="<?php echo e(route('admin.spotlights.index')); ?>" class="btn btn-primary">Review Spotlights</a>
                </div>
            </div>
        </div>

        <div class="col-lg-6">
            <div class="admin-card">
                <div class="admin-card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0 fw-bold">Flagged Content</h5>
                    <a href="<?php echo e(route('admin.spotlights.index', ['status' => 'flagged'])); ?>" class="btn btn-sm btn-outline-danger">View All</a>
                </div>
                <div class="card-body">
                    <p class="text-muted">Review content flagged by users</p>
                    <a href="<?php echo e(route('admin.spotlights.index')); ?>" class="btn btn-danger">Review Flags</a>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\privasee\resources\views/admin/moderation/index.blade.php ENDPATH**/ ?>