

<?php $__env->startSection('content'); ?>
<div class="container mt-4">
    <div class="row mb-4">
        <div class="col">
            <h1>Invite Staff Member</h1>
            <p class="text-muted">Send an invitation to a new team member to join your business</p>
        </div>
    </div>

    <?php
        $business = auth()->user()->businesses()->first();
        $subscription = $business ? $business->activeSubscription()->with('plan')->first() : null;
        $maxStaff = $subscription ? $subscription->plan->max_staff : 0;
        $currentStaff = $business ? $business->staff()->where('status', 'active')->count() : 0;
        $canAddMore = $currentStaff < $maxStaff;
    ?>

    <div class="row">
        <div class="col-md-8">
            <?php if(!$subscription): ?>
                <div class="alert alert-warning" role="alert">
                    <i class="bi bi-exclamation-triangle"></i>
                    <strong>No Active Subscription</strong>
                    <p class="mb-0">You don't have an active subscription. Please upgrade your plan to add staff members.</p>
                </div>
            <?php elseif(!$canAddMore): ?>
                <div class="alert alert-danger" role="alert">
                    <i class="bi bi-exclamation-circle"></i>
                    <strong>Staff Limit Reached</strong>
                    <p class="mb-0">You've reached the maximum of <?php echo e($maxStaff); ?> staff members allowed by your current plan. <a href="#" class="alert-link">Upgrade your plan</a> to add more staff.</p>
                </div>
            <?php endif; ?>

            <div class="card">
                <div class="card-body">
                    <?php if($canAddMore): ?>
                        <form action="<?php echo e(route('business.staff.store')); ?>" method="POST">
                            <?php echo csrf_field(); ?>

                            <!-- Email Address -->
                            <div class="mb-4">
                                <label for="email" class="form-label fw-bold">Email Address</label>
                                <input type="email" class="form-control <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                       id="email" name="email" value="<?php echo e(old('email')); ?>"
                                       placeholder="staff@example.com" required>
                                <small class="text-muted">An invitation will be sent to this email address</small>
                                <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <!-- Role Selection -->
                            <div class="mb-4">
                                <label for="role" class="form-label fw-bold">Role</label>
                                <select class="form-select <?php $__errorArgs = ['role'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        id="role" name="role" required>
                                    <option value="">-- Select Role --</option>
                                    <option value="manager" <?php echo e(old('role') === 'manager' ? 'selected' : ''); ?>>
                                        Manager (Full Access)
                                    </option>
                                    <option value="staff" <?php echo e(old('role') === 'staff' ? 'selected' : ''); ?>>
                                        Staff Member (Limited Access)
                                    </option>
                                </select>
                                <small class="text-muted">
                                    <strong>Manager:</strong> Can manage venues, offers, staff, and view analytics<br>
                                    <strong>Staff:</strong> Can process redemptions and view limited features
                                </small>
                                <?php $__errorArgs = ['role'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <!-- Team Assignment -->
                            <div class="mb-4">
                                <label for="team_id" class="form-label fw-bold">Team (Optional)</label>
                                <select class="form-select <?php $__errorArgs = ['team_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        id="team_id" name="team_id">
                                    <option value="">-- No Specific Team --</option>
                                    <?php if($business): ?>
                                        <?php $__currentLoopData = $business->teams; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $team): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($team->id); ?>" <?php echo e(old('team_id') == $team->id ? 'selected' : ''); ?>>
                                                <?php echo e($team->name); ?>

                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>
                                </select>
                                <small class="text-muted">Assign this staff member to a specific team</small>
                                <?php $__errorArgs = ['team_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <!-- Permissions -->
                            <div class="mb-4">
                                <label class="form-label fw-bold">Permissions</label>
                                <p class="text-muted mb-3">Select which features this staff member can access:</p>

                                <div class="row">
                                    <?php $__currentLoopData = $importantPermissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $permission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="col-md-6 mb-3">
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox"
                                                       id="permission<?php echo e($permission->id); ?>"
                                                       name="permissions[]"
                                                       value="<?php echo e($permission->id); ?>"
                                                       <?php echo e(in_array($permission->id, old('permissions', [])) ? 'checked' : ''); ?>>
                                                <label class="form-check-label" for="permission<?php echo e($permission->id); ?>">
                                                    <strong><?php echo e($permission->display_name ?? ucwords(str_replace('_', ' ', $permission->name))); ?></strong>
                                                    <br>
                                                    <small class="text-muted">
                                                        <?php switch($permission->name):
                                                            case ('manage_offers'): ?>
                                                                Create, edit, and manage offers
                                                                <?php break; ?>
                                                            <?php case ('manage_venues'): ?>
                                                                Create and manage business venues
                                                                <?php break; ?>
                                                            <?php case ('manage_spotlight'): ?>
                                                                Manage spotlight features
                                                                <?php break; ?>
                                                            <?php case ('process_redemptions'): ?>
                                                                Process customer redemptions
                                                                <?php break; ?>
                                                            <?php default: ?>
                                                                <?php echo e($permission->description ?? ''); ?>

                                                        <?php endswitch; ?>
                                                    </small>
                                                </label>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                                <?php $__errorArgs = ['permissions'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="text-danger"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <!-- Buttons -->
                            <div class="d-flex gap-2">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-paper-plane"></i> Send Invitation
                                </button>
                                <a href="<?php echo e(route('business.staff.index')); ?>" class="btn btn-secondary">
                                    Cancel
                                </a>
                            </div>
                        </form>
                    <?php else: ?>
                        <div class="alert alert-danger text-center py-5">
                            <i class="fas fa-lock" style="font-size: 3rem;"></i>
                            <h4 class="mt-3">Staff Limit Reached</h4>
                            <p class="mb-3">Your current plan allows <strong><?php echo e($maxStaff); ?> staff members</strong>.</p>
                            <p class="text-muted mb-4">To add more staff, please upgrade your subscription plan.</p>
                            <a href="<?php echo e(route('business.subscription.index')); ?>" class="btn btn-primary">
                                <i class="fas fa-arrow-up"></i> Upgrade Plan
                            </a>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <!-- Info Sidebar -->
        <div class="col-md-4">
            <?php if($subscription): ?>
                <div class="card mb-3">
                    <div class="card-body">
                        <h5 class="card-title">Plan: <?php echo e($subscription->plan->name); ?></h5>
                        <div class="progress mb-3">
                            <div class="progress-bar <?php if($currentStaff >= $maxStaff): ?> bg-danger <?php elseif($currentStaff >= $maxStaff * 0.8): ?> bg-warning <?php else: ?> bg-success <?php endif; ?>"
                                 role="progressbar"
                                 style="width: <?php echo e(min(100, ($currentStaff / $maxStaff) * 100)); ?>%"
                                 aria-valuenow="<?php echo e($currentStaff); ?>"
                                 aria-valuemin="0"
                                 aria-valuemax="<?php echo e($maxStaff); ?>">
                            </div>
                        </div>
                        <div class="d-flex justify-content-between mb-3">
                            <span><strong>Staff Members:</strong></span>
                            <span class="<?php if($currentStaff >= $maxStaff): ?> text-danger <?php endif; ?>"><strong><?php echo e($currentStaff); ?>/<?php echo e($maxStaff); ?></strong></span>
                        </div>
                        <?php if($canAddMore): ?>
                            <p class="mb-0 text-success"><i class="fas fa-check-circle"></i> <small>You can add <?php echo e($maxStaff - $currentStaff); ?> more staff member(s)</small></p>
                        <?php else: ?>
                            <p class="mb-0 text-danger"><i class="fas fa-exclamation-circle"></i> <small>Limit reached - upgrade to add more</small></p>
                        <?php endif; ?>
                    </div>
                </div>
            <?php endif; ?>

            <div class="card bg-light">
                <div class="card-body">
                    <h5 class="card-title">How it works</h5>
                    <ol class="small">
                        <li>Enter the staff member's email address</li>
                        <li>Select their role and permissions</li>
                        <li>Click "Send Invitation"</li>
                        <li>They'll receive an email with a link to create their account</li>
                        <li>Once they create their account, they can start working immediately</li>
                    </ol>
                </div>
            </div>

            <div class="card mt-3">
                <div class="card-body">
                    <h5 class="card-title text-warning">Important</h5>
                    <p class="small mb-0">
                        <strong>Invitations expire after 7 days.</strong> If the staff member doesn't accept within this period, you'll need to send a new invitation.
                    </p>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.business', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\privasee\resources\views/business/staff/create.blade.php ENDPATH**/ ?>