<?php $__env->startSection('title', 'Users with Role: ' . $role->display_name); ?>

<?php $__env->startSection('content'); ?>
<div class="admin-header mb-4">
    <div>
        <h2>Users with Role: <?php echo e($role->display_name); ?></h2>
        <p class="text-muted mb-0">View all users assigned to this role</p>
    </div>
    <a href="<?php echo e(route('admin.roles.show', $role->id)); ?>" class="btn btn-secondary">
        <i class="bi bi-arrow-left"></i> Back to Role
    </a>
</div>

<!-- Users Table -->
<div class="card">
    <div class="table-responsive">
        <table class="table table-hover mb-0">
            <thead class="table-light">
                <tr>
                    <th>Name</th>
                    <th>Email</th>
                    <th>Status</th>
                    <th>Assigned Date</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr>
                    <td>
                        <strong><?php echo e($user->first_name); ?> <?php echo e($user->last_name); ?></strong>
                    </td>
                    <td><?php echo e($user->email); ?></td>
                    <td>
                        <span class="badge bg-<?php echo e($user->status === 'active' ? 'success' : 'warning'); ?>">
                            <?php echo e(ucfirst($user->status)); ?>

                        </span>
                    </td>
                    <td>
                        <?php if($user->pivot->created_at): ?>
                            <?php echo e($user->pivot->created_at->format('M d, Y')); ?>

                        <?php else: ?>
                            N/A
                        <?php endif; ?>
                    </td>
                    <td>
                        <a href="<?php echo e(route('admin.users.show', $user->id)); ?>" class="btn btn-sm btn-light">
                            <i class="bi bi-eye"></i> View
                        </a>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="5" class="text-center py-5">
                        <i class="bi bi-people" style="font-size: 3rem; color: #ccc;"></i>
                        <p class="text-muted mt-3">No users assigned to this role</p>
                    </td>
                </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <?php if($users->hasPages()): ?>
    <div class="card-footer bg-white">
        <?php echo e($users->links()); ?>

    </div>
    <?php endif; ?>
</div>

<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\privasee\resources\views/admin/roles/users.blade.php ENDPATH**/ ?>