<?php $__env->startSection('title', 'Chat Details - ' . ($chat->name ?? 'Chat')); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <!-- Header -->
    <div class="row mb-4">
        <div class="col-md-8">
            <h1 class="h3 mb-0">
                <i class="fas fa-comments"></i> <?php echo e($chat->name ?? 'Chat Details'); ?>

            </h1>
            <p class="text-muted">View and manage chat messages</p>
        </div>
        <div class="col-md-4 text-end">
            <a href="<?php echo e(route('admin.chats.index')); ?>" class="btn btn-secondary">
                <i class="fas fa-arrow-left"></i> Back to Chats
            </a>
        </div>
    </div>

    <!-- Chat Information -->
    <div class="row mb-4">
        <div class="col-md-4">
            <div class="card">
                <div class="card-body">
                    <h6 class="text-muted mb-2">Chat Type</h6>
                    <p class="mb-0"><span class="badge bg-info"><?php echo e(ucfirst($chat->type)); ?></span></p>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card">
                <div class="card-body">
                    <h6 class="text-muted mb-2">Status</h6>
                    <p class="mb-0">
                        <span class="badge bg-<?php echo e($chat->is_active ? 'success' : 'danger'); ?>">
                            <?php echo e($chat->is_active ? 'Active' : 'Inactive'); ?>

                        </span>
                    </p>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card">
                <div class="card-body">
                    <h6 class="text-muted mb-2">Messages</h6>
                    <p class="mb-0"><strong><?php echo e($chat->messages_count ?? 0); ?></strong></p>
                </div>
            </div>
        </div>
    </div>

    <!-- Participants -->
    <div class="card mb-4">
        <div class="card-header">
            <h5 class="mb-0">
                <i class="fas fa-users"></i> Participants (<?php echo e($chat->participants_count ?? 0); ?>)
            </h5>
        </div>
        <div class="table-responsive">
            <table class="table table-sm mb-0">
                <thead class="table-light">
                    <tr>
                        <th>User</th>
                        <th>Email</th>
                        <th>Joined</th>
                        <th>Last Read</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $chat->participants; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $participant): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td>
                            <strong><?php echo e($participant->first_name); ?> <?php echo e($participant->last_name); ?></strong>
                        </td>
                        <td><?php echo e($participant->email); ?></td>
                        <td>
                            <?php if($participant->pivot && $participant->pivot->joined_at): ?>
                                <?php if(is_string($participant->pivot->joined_at)): ?>
                                    <?php echo e(\Carbon\Carbon::parse($participant->pivot->joined_at)->format('M d, Y H:i')); ?>

                                <?php else: ?>
                                    <?php echo e($participant->pivot->joined_at->format('M d, Y H:i')); ?>

                                <?php endif; ?>
                            <?php else: ?>
                                N/A
                            <?php endif; ?>
                        </td>
                        <td>
                            <?php if($participant->pivot && $participant->pivot->last_read_at): ?>
                                <?php if(is_string($participant->pivot->last_read_at)): ?>
                                    <?php echo e(\Carbon\Carbon::parse($participant->pivot->last_read_at)->diffForHumans()); ?>

                                <?php else: ?>
                                    <?php echo e($participant->pivot->last_read_at->diffForHumans()); ?>

                                <?php endif; ?>
                            <?php else: ?>
                                Never
                            <?php endif; ?>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="4" class="text-center text-muted py-4">No participants</td>
                    </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Messages -->
    <div class="card">
        <div class="card-header">
            <h5 class="mb-0">
                <i class="fas fa-envelope"></i> Messages
            </h5>
        </div>
        <div class="card-body" style="max-height: 500px; overflow-y: auto;">
            <?php $__empty_1 = true; $__currentLoopData = $messages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $message): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <div class="mb-3 pb-3 border-bottom">
                <div class="d-flex justify-content-between align-items-start">
                    <div>
                        <strong><?php echo e($message->sender->first_name); ?> <?php echo e($message->sender->last_name); ?></strong>
                        <span class="text-muted small"><?php echo e($message->sender->email); ?></span>
                    </div>
                    <small class="text-muted">
                        <?php if(is_string($message->created_at)): ?>
                            <?php echo e(\Carbon\Carbon::parse($message->created_at)->format('M d, Y H:i')); ?>

                        <?php else: ?>
                            <?php echo e($message->created_at->format('M d, Y H:i')); ?>

                        <?php endif; ?>
                        <?php if($message->is_edited): ?>
                            <span class="badge bg-warning">Edited</span>
                        <?php endif; ?>
                    </small>
                </div>
                <p class="mb-0 mt-2"><?php echo e($message->content); ?></p>
                <small class="text-muted">
                    Type: <span class="badge bg-secondary"><?php echo e(ucfirst($message->message_type)); ?></span>
                </small>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <div class="text-center text-muted py-4">
                <i class="fas fa-inbox fs-1 d-block mb-2"></i>
                <p>No messages in this chat</p>
            </div>
            <?php endif; ?>
        </div>

        <!-- Pagination -->
        <?php if($messages->hasPages()): ?>
        <div class="card-footer">
            <nav>
                <ul class="pagination pagination-sm mb-0">
                    <!-- Previous Page -->
                    <?php if($messages->onFirstPage()): ?>
                        <li class="page-item disabled">
                            <span class="page-link">← Previous</span>
                        </li>
                    <?php else: ?>
                        <li class="page-item">
                            <a class="page-link" href="<?php echo e($messages->previousPageUrl()); ?>">← Previous</a>
                        </li>
                    <?php endif; ?>

                    <!-- Page Numbers -->
                    <?php $__currentLoopData = $messages->getUrlRange(1, $messages->lastPage()); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page => $url): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if($page == $messages->currentPage()): ?>
                            <li class="page-item active">
                                <span class="page-link"><?php echo e($page); ?></span>
                            </li>
                        <?php else: ?>
                            <li class="page-item">
                                <a class="page-link" href="<?php echo e($url); ?>"><?php echo e($page); ?></a>
                            </li>
                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    <!-- Next Page -->
                    <?php if($messages->hasMorePages()): ?>
                        <li class="page-item">
                            <a class="page-link" href="<?php echo e($messages->nextPageUrl()); ?>">Next →</a>
                        </li>
                    <?php else: ?>
                        <li class="page-item disabled">
                            <span class="page-link">Next →</span>
                        </li>
                    <?php endif; ?>
                </ul>
            </nav>
        </div>
        <?php endif; ?>
    </div>

    <!-- Actions -->
    <div class="mt-4">
        <?php if($chat->is_active): ?>
        <form action="<?php echo e(route('admin.chats.disable', $chat->id)); ?>" method="POST" style="display:inline;">
            <?php echo csrf_field(); ?>
            <button type="submit" class="btn btn-warning" onclick="return confirm('Disable this chat?')">
                <i class="fas fa-ban"></i> Disable Chat
            </button>
        </form>
        <?php else: ?>
        <form action="<?php echo e(route('admin.chats.enable', $chat->id)); ?>" method="POST" style="display:inline;">
            <?php echo csrf_field(); ?>
            <button type="submit" class="btn btn-success" onclick="return confirm('Enable this chat?')">
                <i class="fas fa-check"></i> Enable Chat
            </button>
        </form>
        <?php endif; ?>

        <form action="<?php echo e(route('admin.chats.destroy', $chat->id)); ?>" method="POST" style="display:inline;">
            <?php echo csrf_field(); ?>
            <?php echo method_field('DELETE'); ?>
            <button type="submit" class="btn btn-danger" onclick="return confirm('Delete this chat permanently?')">
                <i class="fas fa-trash"></i> Delete Chat
            </button>
        </form>
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\privasee\resources\views/admin/chats/show.blade.php ENDPATH**/ ?>