<?php $__env->startSection('title', 'Admin Notifications'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid py-4">
    <!-- Header -->
    <div class="row mb-4">
        <div class="col-md-8">
            <h1 class="h3 mb-0">
                <i class="bi bi-bell"></i> Admin Notifications
            </h1>
            <p class="text-muted">Manage your system notifications</p>
        </div>
        <div class="col-md-4 text-end">
            <?php if(isset($unreadCount) && $unreadCount > 0): ?>
                <button class="btn btn-sm btn-primary" id="markAllRead">
                    <i class="bi bi-check2-all"></i> Mark All Read (<?php echo e($unreadCount); ?>)
                </button>
            <?php endif; ?>
        </div>
    </div>

    <!-- Notification Cards -->
    <div class="row">
        <?php $__empty_1 = true; $__currentLoopData = $notifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
        <div class="col-md-6 mb-3">
            <div class="card border-0 shadow-sm <?php echo e(!$notification->read_at ? 'border-left border-primary' : ''); ?>">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-start">
                        <div class="flex-grow-1">
                            <!-- Notification Type Icon -->
                            <div class="mb-2">
                                <?php switch($notification->type):
                                    case ('business_verified'): ?>
                                        <span class="badge bg-success">Business Verified</span>
                                        <?php break; ?>
                                    <?php case ('business_rejected'): ?>
                                        <span class="badge bg-danger">Business Rejected</span>
                                        <?php break; ?>
                                    <?php case ('venue_approved'): ?>
                                        <span class="badge bg-success">Venue Approved</span>
                                        <?php break; ?>
                                    <?php case ('venue_rejected'): ?>
                                        <span class="badge bg-danger">Venue Rejected</span>
                                        <?php break; ?>
                                    <?php case ('staff_invited'): ?>
                                        <span class="badge bg-info">Staff Invited</span>
                                        <?php break; ?>
                                    <?php case ('staff_joined'): ?>
                                        <span class="badge bg-success">Staff Joined</span>
                                        <?php break; ?>
                                    <?php case ('payment_received'): ?>
                                        <span class="badge bg-success">Payment Received</span>
                                        <?php break; ?>
                                    <?php case ('subscription_expiring'): ?>
                                        <span class="badge bg-warning">Subscription Expiring</span>
                                        <?php break; ?>
                                    <?php default: ?>
                                        <span class="badge bg-secondary"><?php echo e(ucfirst(str_replace('_', ' ', $notification->type))); ?></span>
                                <?php endswitch; ?>
                            </div>

                            <!-- Notification Content -->
                            <?php
                                $data = $notification->data;
                            ?>

                            <h6 class="mb-2 fw-bold">
                                <?php switch($notification->type):
                                    case ('business_verified'): ?>
                                        <?php echo e($data['business_name'] ?? 'Unknown'); ?> - Verified
                                        <?php break; ?>
                                    <?php case ('business_rejected'): ?>
                                        <?php echo e($data['business_name'] ?? 'Unknown'); ?> - Rejected
                                        <?php break; ?>
                                    <?php case ('venue_approved'): ?>
                                        <?php echo e($data['venue_name'] ?? 'Unknown'); ?> - Approved
                                        <?php break; ?>
                                    <?php case ('venue_rejected'): ?>
                                        <?php echo e($data['venue_name'] ?? 'Unknown'); ?> - Rejected
                                        <?php break; ?>
                                    <?php case ('staff_invited'): ?>
                                        New Staff Invite: <?php echo e($data['staff_email'] ?? 'Unknown'); ?>

                                        <?php break; ?>
                                    <?php case ('staff_joined'): ?>
                                        <?php echo e($data['staff_name'] ?? 'Unknown'); ?> Joined <?php echo e($data['business_name'] ?? 'Business'); ?>

                                        <?php break; ?>
                                    <?php case ('payment_received'): ?>
                                        Payment Received: <?php echo e($data['amount'] ?? '0'); ?>

                                        <?php break; ?>
                                    <?php case ('subscription_expiring'): ?>
                                        Subscription Expiring: <?php echo e($data['business_name'] ?? 'Unknown'); ?>

                                        <?php break; ?>
                                    <?php default: ?>
                                        <?php echo e(ucfirst(str_replace('_', ' ', $notification->type))); ?>

                                <?php endswitch; ?>
                            </h6>

                            <!-- Notification Details -->
                            <p class="mb-2 text-muted small">
                                <?php switch($notification->type):
                                    case ('business_rejected'): ?>
                                        Reason: <?php echo e($data['reason'] ?? 'No reason provided'); ?>

                                        <?php break; ?>
                                    <?php case ('venue_rejected'): ?>
                                        Reason: <?php echo e($data['reason'] ?? 'No reason provided'); ?>

                                        <?php break; ?>
                                    <?php case ('payment_received'): ?>
                                        Amount: <?php echo e($data['amount'] ?? 'N/A'); ?> <?php echo e($data['currency'] ?? 'AED'); ?>

                                        <?php break; ?>
                                    <?php case ('subscription_expiring'): ?>
                                        Expires: <?php echo e($data['expiry_date'] ?? 'Unknown'); ?>

                                        <?php break; ?>
                                    <?php default: ?>
                                <?php endswitch; ?>
                            </p>

                            <!-- Timestamp -->
                            <small class="text-muted">
                                <i class="bi bi-clock"></i> <?php echo e($notification->created_at->diffForHumans()); ?>

                            </small>
                        </div>

                        <!-- Actions -->
                        <div class="ms-3">
                            <?php if(!$notification->read_at): ?>
                            <button class="btn btn-sm btn-light" onclick="markAsRead('<?php echo e($notification->id); ?>')">
                                <i class="bi bi-check"></i>
                            </button>
                            <?php endif; ?>
                            <button class="btn btn-sm btn-light" onclick="deleteNotification('<?php echo e($notification->id); ?>')">
                                <i class="bi bi-trash"></i>
                            </button>
                        </div>
                    </div>

                    <!-- Action Link -->
                    <?php if(!empty($data['action_url'])): ?>
                    <div class="mt-3">
                        <a href="<?php echo e($data['action_url']); ?>" class="btn btn-sm btn-outline-primary">
                            View Details <i class="bi bi-arrow-right"></i>
                        </a>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
        <div class="col-12">
            <div class="card border-0 shadow-sm">
                <div class="card-body text-center py-5">
                    <i class="bi bi-inbox" style="font-size: 3rem; color: #ccc;"></i>
                    <p class="text-muted mt-3">No notifications</p>
                </div>
            </div>
        </div>
        <?php endif; ?>
    </div>

    <!-- Pagination -->
    <?php if($notifications->hasPages()): ?>
    <nav class="mt-4">
        <?php echo e($notifications->links()); ?>

    </nav>
    <?php endif; ?>
</div>

<script>
    function markAsRead(id) {
        fetch(`<?php echo e(route('admin.notifications.mark-read', '')); ?>/${id}`, {
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
                'Content-Type': 'application/json'
            }
        }).then(response => {
            if (response.ok) {
                location.reload();
            }
        });
    }

    function deleteNotification(id) {
        if (confirm('Delete this notification?')) {
            fetch(`<?php echo e(route('admin.notifications.destroy', '')); ?>/${id}`, {
                method: 'DELETE',
                headers: {
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
                    'Content-Type': 'application/json'
                }
            }).then(response => {
                if (response.ok) {
                    location.reload();
                }
            });
        }
    }

    document.getElementById('markAllRead')?.addEventListener('click', function() {
        fetch(`<?php echo e(route('admin.notifications.mark-all-read')); ?>`, {
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
                'Content-Type': 'application/json'
            }
        }).then(response => {
            if (response.ok) {
                location.reload();
            }
        });
    });
</script>

<style>
    .border-left {
        border-left: 3px solid !important;
    }
</style>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\privasee\resources\views/admin/notifications/index.blade.php ENDPATH**/ ?>