<?php $__env->startSection('title', 'User Report'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid py-4">
    <!-- Header -->
    <div class="row mb-4">
        <div class="col-md-8">
            <h1 class="h3 mb-0">
                <i class="bi bi-people"></i> User Report
            </h1>
            <p class="text-muted">User growth and activity metrics</p>
        </div>
        <div class="col-md-4 text-end">
            <a href="<?php echo e(route('admin.analytics.index')); ?>" class="btn btn-sm btn-secondary">
                <i class="bi bi-arrow-left"></i> Back to Analytics
            </a>
        </div>
    </div>

    <!-- Filters -->
    <div class="card border-0 shadow-sm mb-4">
        <div class="card-body">
            <form method="GET" class="row g-3">
                <div class="col-md-4">
                    <label class="form-label">Period</label>
                    <select name="period" class="form-select" onchange="this.form.submit()">
                        <option value="7" <?php echo e($period == 7 ? 'selected' : ''); ?>>Last 7 Days</option>
                        <option value="30" <?php echo e($period == 30 ? 'selected' : ''); ?>>Last 30 Days</option>
                        <option value="90" <?php echo e($period == 90 ? 'selected' : ''); ?>>Last 90 Days</option>
                    </select>
                </div>
                <div class="col-md-4">
                    <label class="form-label">Account Type</label>
                    <select name="account_type" class="form-select" onchange="this.form.submit()">
                        <option value="">All Users</option>
                        <option value="personal" <?php echo e($accountType == 'personal' ? 'selected' : ''); ?>>Personal</option>
                        <option value="business" <?php echo e($accountType == 'business' ? 'selected' : ''); ?>>Business</option>
                        <option value="admin" <?php echo e($accountType == 'admin' ? 'selected' : ''); ?>>Admin</option>
                    </select>
                </div>
                <div class="col-md-4 d-flex align-items-end gap-2">
                    <a href="<?php echo e(route('admin.analytics.reports.users')); ?>" class="btn btn-secondary">
                        <i class="bi bi-arrow-clockwise"></i> Reset
                    </a>
                </div>
            </form>
        </div>
    </div>

    <!-- Users Table -->
    <div class="card border-0 shadow-sm">
        <div class="table-responsive">
            <table class="table table-hover mb-0">
                <thead class="table-light">
                    <tr>
                        <th>User</th>
                        <th>Email</th>
                        <th>Account Type</th>
                        <th>Status</th>
                        <th>Joined Date</th>
                        <th>Redemptions</th>
                        <th>Last Active</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td>
                                <small>
                                    <strong><?php echo e($user->first_name); ?> <?php echo e($user->last_name); ?></strong>
                                </small>
                            </td>
                            <td>
                                <small class="text-muted"><?php echo e($user->email); ?></small>
                            </td>
                            <td>
                                <span class="badge bg-<?php echo e($user->account_type === 'business' ? 'info' : ($user->account_type === 'admin' ? 'danger' : 'secondary')); ?>">
                                    <?php echo e(ucfirst($user->account_type)); ?>

                                </span>
                            </td>
                            <td>
                                <span class="badge bg-<?php echo e($user->status === 'active' ? 'success' : 'secondary'); ?>">
                                    <?php echo e(ucfirst($user->status)); ?>

                                </span>
                            </td>
                            <td>
                                <small class="text-muted"><?php echo e($user->created_at->format('M d, Y')); ?></small>
                            </td>
                            <td>
                                <span class="badge bg-primary"><?php echo e($user->redemptions_count); ?></span>
                            </td>
                            <td>
                                <small class="text-muted">
                                    <?php echo e($user->updated_at->diffForHumans()); ?>

                                </small>
                            </td>
                            <td>
                                <a href="<?php echo e(route('admin.users.show', $user)); ?>" class="btn btn-sm btn-info" title="View">
                                    <i class="bi bi-eye"></i>
                                </a>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="8" class="text-center text-muted py-4">
                                <small>No users found</small>
                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

        <!-- Pagination -->
        <div class="card-footer bg-light">
            <div class="d-flex justify-content-between align-items-center">
                <small class="text-muted">
                    Showing <?php echo e($users->firstItem() ?? 0); ?> to <?php echo e($users->lastItem() ?? 0); ?> of <?php echo e($users->total()); ?> users
                </small>
                <?php echo e($users->links()); ?>

            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\privasee\resources\views/admin/analytics/user-report.blade.php ENDPATH**/ ?>