<?php $__env->startSection('title', 'Venue Details - ' . $venue->name); ?>

<?php $__env->startSection('content'); ?>
    <div class="admin-header mb-4">
        <div>
            <h2><?php echo e($venue->name); ?></h2>
            <p class="text-muted mb-0">
                Business: <?php echo e($venue->business->business_name); ?> |
                Category: <?php echo e($venue->category->name); ?>

            </p>
        </div>
        <div class="d-flex gap-2 justify-content-end">
            <?php if($venue->status == 'pending'): ?>
                <button class="btn btn-primary" onclick="approveVenue(<?php echo e($venue->id); ?>)">
                    <i class="bi bi-check-circle me-2"></i>Approve
                </button>
                <button class="btn btn-danger" onclick="rejectVenue(<?php echo e($venue->id); ?>)">
                    <i class="bi bi-x-circle me-2"></i>Reject
                </button>
            <?php endif; ?>
            <a href="<?php echo e(route('admin.venues.index')); ?>" class="btn btn-outline-secondary">
                <i class="bi bi-arrow-left me-2"></i>Back
            </a>
        </div>
    </div>

    <!-- Status & Quick Info -->
    <div class="row g-4 mb-4">
        <div class="col-md-3">
            <div class="card border-0 shadow-sm">
                <div class="card-body">
                    <div class="text-muted small mb-2">Status</div>
                    <?php if($venue->status === 'active'): ?>
                        <span class="badge bg-success">Active</span>
                    <?php elseif($venue->status === 'pending'): ?>
                        <span class="badge bg-warning">Pending Approval</span>
                    <?php else: ?>
                        <span class="badge bg-secondary"><?php echo e(ucfirst($venue->status)); ?></span>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <div class="col-md-3">
            <div class="card border-0 shadow-sm">
                <div class="card-body">
                    <div class="text-muted small mb-2">Total Offers</div>
                    <div class="fs-4 fw-bold"><?php echo e($venue->offers()->count()); ?></div>
                </div>
            </div>
        </div>

        <div class="col-md-3">
            <div class="card border-0 shadow-sm">
                <div class="card-body">
                    <div class="text-muted small mb-2">Reviews</div>
                    <div class="fs-4 fw-bold">
                        <?php echo e($venue->reviews()->count()); ?>

                        <?php if($venue->rating): ?>
                            <small class="text-muted fs-6">(<?php echo e(number_format($venue->rating, 1)); ?>★)</small>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-3">
            <div class="card border-0 shadow-sm">
                <div class="card-body">
                    <div class="text-muted small mb-2">Redemptions</div>
                    <div class="fs-4 fw-bold"><?php echo e($venue->redemptions()->count()); ?></div>
                </div>
            </div>
        </div>
    </div>

    <div class="row g-4">
        <div class="col-lg-8">
            <!-- Featured Image -->
            <?php if($venue->featured_image): ?>
                <div class="card border-0 shadow-sm mb-4">
                    <img src="<?php echo e(Storage::url($venue->featured_image)); ?>"
                         class="card-img-top"
                         alt="<?php echo e($venue->name); ?>"
                         style="height: 400px; object-fit: cover;">
                </div>
            <?php endif; ?>

            <!-- Details -->
            <div class="card border-0 shadow-sm mb-4">
                <div class="card-header bg-white border-bottom">
                    <h5 class="mb-0 fw-bold">Venue Information</h5>
                </div>
                <div class="card-body">
                    <div class="row g-3">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="text-muted small">Venue Name</label>
                                <div class="fw-semibold"><?php echo e($venue->name); ?></div>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="text-muted small">Category</label>
                                <div class="fw-semibold"><?php echo e($venue->category->name); ?></div>
                            </div>
                        </div>

                        <div class="col-12">
                            <div class="mb-3">
                                <label class="text-muted small">Description</label>
                                <div><?php echo e($venue->description ?? 'No description provided'); ?></div>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="text-muted small">City</label>
                                <div class="fw-semibold"><?php echo e($venue->city); ?></div>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="text-muted small">Area</label>
                                <div class="fw-semibold"><?php echo e($venue->area); ?></div>
                            </div>
                        </div>

                        <div class="col-12">
                            <div class="mb-3">
                                <label class="text-muted small">Full Address</label>
                                <div><?php echo e($venue->address); ?></div>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="text-muted small">Phone</label>
                                <div class="fw-semibold"><?php echo e($venue->phone); ?></div>
                            </div>
                        </div>

                        <?php if($venue->email): ?>
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="text-muted small">Email</label>
                                    <div class="fw-semibold"><?php echo e($venue->email); ?></div>
                                </div>
                            </div>
                        <?php endif; ?>

                        <?php if($venue->website): ?>
                            <div class="col-12">
                                <div class="mb-3">
                                    <label class="text-muted small">Website</label>
                                    <div>
                                        <a href="<?php echo e($venue->website); ?>" target="_blank"><?php echo e($venue->website); ?></a>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>

                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="text-muted small">Coordinates</label>
                                <div><?php echo e($venue->latitude); ?>, <?php echo e($venue->longitude); ?></div>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="mb-0">
                                <label class="text-muted small">Created</label>
                                <div><?php echo e($venue->created_at->format('M d, Y h:i A')); ?></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Gallery -->
            <?php if($venue->images && count(json_decode($venue->images, true)) > 0): ?>
                <div class="card border-0 shadow-sm mb-4">
                    <div class="card-header bg-white border-bottom">
                        <h5 class="mb-0 fw-bold">Gallery</h5>
                    </div>
                    <div class="card-body">
                        <div class="row g-3">
                            <?php $__currentLoopData = json_decode($venue->images, true); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-md-4">
                                    <img src="<?php echo e(Storage::url($image)); ?>"
                                         class="img-fluid rounded"
                                         style="height: 200px; width: 100%; object-fit: cover;">
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>
            <?php endif; ?>

            <!-- Offers -->
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-white border-bottom">
                    <h5 class="mb-0 fw-bold">Active Offers</h5>
                    <a href="<?php echo e(route('admin.offers.create-for-business', $venue->id)); ?>"
                       class="btn btn-sm btn-primary float-end">
                        <i class="bi bi-plus-circle me-2"></i>Add Offer
                    </a>
                </div>
                <div class="card-body p-0">
                    <?php
                        $offers = $venue->offers()->where('status', 'active')->take(10)->get();
                    ?>

                    <?php if($offers->count() > 0): ?>
                        <div class="table-responsive">
                            <table class="table table-hover mb-0">
                                <thead class="bg-light">
                                <tr>
                                    <th>Offer Title</th>
                                    <th>Discount</th>
                                    <th>Valid Until</th>
                                    <th>Redemptions</th>
                                    <th>Status</th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php $__currentLoopData = $offers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $offer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($offer->title); ?></td>
                                        <td>
                                            <?php if($offer->discount_percentage): ?>
                                                <?php echo e($offer->discount_percentage); ?>%
                                            <?php elseif($offer->discount_amount): ?>
                                                AED <?php echo e(number_format($offer->discount_amount)); ?>

                                            <?php else: ?>
                                                -
                                            <?php endif; ?>
                                        </td>
                                        <td><?php echo e($offer->end_date ? $offer->end_date->format('M d, Y') : '-'); ?></td>
                                        <td><?php echo e($offer->redemption_count); ?></td>
                                        <td>
                                            <span class="badge bg-success">Active</span>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    <?php else: ?>
                        <div class="text-center py-4 text-muted">
                            No active offers
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <!-- Sidebar -->
        <div class="col-lg-4">
            <!-- Business Info -->
            <div class="card border-0 shadow-sm mb-4">
                <div class="card-header bg-white border-bottom">
                    <h5 class="mb-0 fw-bold">Business Information</h5>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <label class="text-muted small">Business Name</label>
                        <div class="fw-semibold"><?php echo e($venue->business->business_name); ?></div>
                    </div>

                    <div class="mb-3">
                        <label class="text-muted small">Owner</label>
                        <div class="fw-semibold"><?php echo e($venue->business->owner->full_name); ?></div>
                    </div>

                    <div class="mb-3">
                        <label class="text-muted small">Email</label>
                        <div><?php echo e($venue->business->email); ?></div>
                    </div>

                    <div class="mb-0">
                        <label class="text-muted small">Phone</label>
                        <div><?php echo e($venue->business->phone); ?></div>
                    </div>
                </div>
            </div>

            <!-- Admin Actions -->
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-white border-bottom">
                    <h5 class="mb-0 fw-bold">Admin Actions</h5>
                </div>
                <div class="card-body">
                    <?php if($venue->status === 'pending'): ?>
                        <button class="btn btn-success w-100 mb-2" onclick="approveVenue(<?php echo e($venue->id); ?>)">
                            <i class="bi bi-check-circle me-2"></i>Approve Venue
                        </button>
                        <button class="btn btn-danger w-100 mb-2" onclick="rejectVenue(<?php echo e($venue->id); ?>)">
                            <i class="bi bi-x-circle me-2"></i>Reject Venue
                        </button>
                    <?php else: ?>
                        <button class="btn btn-warning w-100 mb-2" onclick="toggleStatus(<?php echo e($venue->id); ?>)">
                            <i class="bi bi-power me-2"></i>
                            <?php echo e($venue->status === 'active' ? 'Deactivate' : 'Activate'); ?>

                        </button>
                    <?php endif; ?>

                    <a href="<?php echo e(route('admin.businesses.show', $venue->business_id)); ?>"
                       class="btn btn-outline-primary w-100 mb-2">
                        <i class="bi bi-building me-2"></i>View Business
                    </a>

                    <button class="btn btn-outline-danger w-100" onclick="deleteVenue(<?php echo e($venue->id); ?>)">
                        <i class="bi bi-trash me-2"></i>Delete Venue
                    </button>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script>
        function approveVenue(id) {
            if (confirm('Approve this venue?')) {
                fetch(`/admin/venues/${id}/approve`, {
                    method: 'POST',
                    headers: {
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
                        'Accept': 'application/json'
                    }
                })
                    .then(response => response.json())
                    .then(data => {
                        if (data.success) {
                            location.reload();
                        } else {
                            alert(data.message || 'Error approving venue');
                        }
                    });
            }
        }

        function rejectVenue(id) {
            const reason = prompt('Enter rejection reason:');
            if (reason) {
                fetch(`/admin/venues/${id}/reject`, {
                    method: 'POST',
                    headers: {
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
                        'Content-Type': 'application/json',
                        'Accept': 'application/json'
                    },
                    body: JSON.stringify({ reason: reason })
                })
                    .then(response => response.json())
                    .then(data => {
                        if (data.success) {
                            location.reload();
                        } else {
                            alert(data.message || 'Error rejecting venue');
                        }
                    });
            }
        }

        function toggleStatus(id) {
            if (confirm('Change venue status?')) {
                fetch(`/admin/venues/${id}/toggle-status`, {
                    method: 'POST',
                    headers: {
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
                        'Accept': 'application/json'
                    }
                })
                    .then(response => response.json())
                    .then(data => {
                        if (data.success) {
                            location.reload();
                        }
                    });
            }
        }

        function deleteVenue(id) {
            if (confirm('Are you sure you want to delete this venue? This action cannot be undone.')) {
                fetch(`/admin/venues/${id}`, {
                    method: 'DELETE',
                    headers: {
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
                        'Accept': 'application/json'
                    }
                })
                    .then(response => response.json())
                    .then(data => {
                        if (data.success) {
                            window.location.href = '/admin/venues';
                        } else {
                            alert(data.message || 'Error deleting venue');
                        }
                    });
            }
        }
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\privasee\resources\views/admin/venues/show.blade.php ENDPATH**/ ?>