<?php $__env->startSection('title', 'User Activity Tracking'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid py-4">
    <!-- Header -->
    <div class="row mb-4">
        <div class="col-md-8">
            <h1 class="h3 mb-0">
                <i class="fas fa-history"></i> User Activity Tracking
            </h1>
            <p class="text-muted">Monitor business owners and staff member activities</p>
        </div>
    </div>

    <!-- Statistics -->
    <div class="row mb-4">
        <div class="col-md-3">
            <div class="card">
                <div class="card-body">
                    <h6 class="text-muted mb-2">Total Users</h6>
                    <h3 class="mb-0"><?php echo e($stats['total_users'] ?? 0); ?></h3>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card">
                <div class="card-body">
                    <h6 class="text-muted mb-2">Active Today</h6>
                    <h3 class="mb-0"><?php echo e($stats['active_today'] ?? 0); ?></h3>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card">
                <div class="card-body">
                    <h6 class="text-muted mb-2">Active This Week</h6>
                    <h3 class="mb-0"><?php echo e($stats['active_this_week'] ?? 0); ?></h3>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card">
                <div class="card-body">
                    <h6 class="text-muted mb-2">Inactive 7+ Days</h6>
                    <h3 class="mb-0"><?php echo e($stats['inactive_7_days'] ?? 0); ?></h3>
                </div>
            </div>
        </div>
    </div>

    <!-- Filters -->
    <div class="card mb-4">
        <div class="card-body">
            <form method="get" class="row g-3">
                <div class="col-md-3">
                    <input type="text" name="search" class="form-control" placeholder="Search by name or email" value="<?php echo e(request('search')); ?>">
                </div>
                <div class="col-md-2">
                    <select name="account_type" class="form-select">
                        <option value="">All Types</option>
                        <option value="business" <?php echo e(request('account_type') === 'business' ? 'selected' : ''); ?>>Business Owner</option>
                        <option value="user" <?php echo e(request('account_type') === 'user' ? 'selected' : ''); ?>>Staff/User</option>
                    </select>
                </div>
                <div class="col-md-2">
                    <select name="status" class="form-select">
                        <option value="">All Status</option>
                        <option value="active" <?php echo e(request('status') === 'active' ? 'selected' : ''); ?>>Active</option>
                        <option value="inactive" <?php echo e(request('status') === 'inactive' ? 'selected' : ''); ?>>Inactive</option>
                    </select>
                </div>
                <div class="col-md-2">
                    <select name="days" class="form-select">
                        <option value="">Any Time</option>
                        <option value="1" <?php echo e(request('days') === '1' ? 'selected' : ''); ?>>Today</option>
                        <option value="7" <?php echo e(request('days') === '7' ? 'selected' : ''); ?>>This Week</option>
                        <option value="30" <?php echo e(request('days') === '30' ? 'selected' : ''); ?>>This Month</option>
                    </select>
                </div>
                <div class="col-md-3">
                    <button type="submit" class="btn btn-primary w-100">
                        <i class="fas fa-search"></i> Filter
                    </button>
                </div>
            </form>
        </div>
    </div>

    <!-- Users Activity Table -->
    <div class="card">
        <div class="table-responsive">
            <table class="table table-hover mb-0">
                <thead class="table-light">
                    <tr>
                        <th>User</th>
                        <th>Email</th>
                        <th>Account Type</th>
                        <th>Last Active</th>
                        <th>Last Active Ago</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td>
                            <div class="d-flex align-items-center">
                                <div class="avatar-sm me-2">
                                    <?php if($user->profile_image): ?>
                                    <img src="<?php echo e(asset($user->profile_image)); ?>" alt="<?php echo e($user->first_name); ?>" class="rounded-circle">
                                    <?php else: ?>
                                    <span class="avatar-title rounded-circle bg-primary text-white">
                                        <?php echo e(strtoupper(substr($user->first_name ?? 'U', 0, 1))); ?>

                                    </span>
                                    <?php endif; ?>
                                </div>
                                <div>
                                    <h6 class="mb-0"><?php echo e($user->first_name); ?> <?php echo e($user->last_name); ?></h6>
                                </div>
                            </div>
                        </td>
                        <td><?php echo e($user->email); ?></td>
                        <td>
                            <span class="badge bg-<?php echo e($user->account_type === 'business' ? 'info' : 'secondary'); ?>">
                                <?php echo e(ucfirst($user->account_type)); ?>

                            </span>
                        </td>
                        <td>
                            <?php if($user->last_active_at): ?>
                                <small><?php echo e($user->last_active_at->format('M d, Y H:i')); ?></small>
                            <?php else: ?>
                                <span class="text-muted">Never</span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <?php if($user->last_active_at): ?>
                                <small class="text-muted"><?php echo e($user->last_active_at->diffForHumans()); ?></small>
                            <?php else: ?>
                                <span class="text-muted">N/A</span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <?php if($user->last_active_at): ?>
                                <?php
                                    $daysSinceActive = $user->last_active_at->diffInDays(now());
                                ?>
                                <?php if($daysSinceActive === 0): ?>
                                    <span class="badge bg-success">Active Today</span>
                                <?php elseif($daysSinceActive <= 7): ?>
                                    <span class="badge bg-info">Active This Week</span>
                                <?php elseif($daysSinceActive <= 30): ?>
                                    <span class="badge bg-warning">Active This Month</span>
                                <?php else: ?>
                                    <span class="badge bg-danger">Inactive</span>
                                <?php endif; ?>
                            <?php else: ?>
                                <span class="badge bg-secondary">Never Active</span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <a href="<?php echo e(route('admin.users.show', $user->id)); ?>" class="btn btn-sm btn-info" title="View Details">
                                <i class="fas fa-eye"></i>
                            </a>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="7" class="text-center text-muted py-4">
                            No users found
                        </td>
                    </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

        <!-- Pagination -->
        <?php if($users->hasPages()): ?>
        <div class="card-footer">
            <?php echo e($users->links()); ?>

        </div>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\privasee\resources\views/admin/users/activity.blade.php ENDPATH**/ ?>