<?php $__env->startSection('title', 'Business Teams'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid py-4">
    <!-- Header -->
    <div class="row mb-4">
        <div class="col-md-8">
            <h1 class="h3 mb-0">
                <a href="<?php echo e(route('business.show', $business)); ?>" class="text-decoration-none">
                    <?php echo e($business->business_name); ?>

                </a>
            </h1>
            <p class="text-muted">Teams</p>
        </div>
        <div class="col-md-4 text-end">
            <a href="<?php echo e(route('business.teams.create', $business)); ?>" class="btn btn-primary">
                <i class="fas fa-plus"></i> Create Team
            </a>
        </div>
    </div>

    <!-- Statistics -->
    <div class="row mb-4">
        <div class="col-md-3">
            <div class="card">
                <div class="card-body">
                    <h6 class="text-muted mb-2">Total Teams</h6>
                    <h3 class="mb-0"><?php echo e($teams->total()); ?></h3>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card">
                <div class="card-body">
                    <h6 class="text-muted mb-2">Active Teams</h6>
                    <h3 class="mb-0"><?php echo e($teams->where('status', 'active')->count()); ?></h3>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card">
                <div class="card-body">
                    <h6 class="text-muted mb-2">Total Members</h6>
                    <h3 class="mb-0"><?php echo e($teams->sum('member_count')); ?></h3>
                </div>
            </div>
        </div>
    </div>

    <!-- Teams Table -->
    <div class="card">
        <div class="table-responsive">
            <table class="table table-hover mb-0">
                <thead class="table-light">
                    <tr>
                        <th>Team Name</th>
                        <th>Description</th>
                        <th>Members</th>
                        <th>Status</th>
                        <th>Created</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $teams; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $team): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td>
                            <strong><?php echo e($team->name); ?></strong>
                        </td>
                        <td>
                            <small class="text-muted"><?php echo e(Str::limit($team->description, 50)); ?></small>
                        </td>
                        <td>
                            <span class="badge bg-info"><?php echo e($team->member_count); ?></span>
                        </td>
                        <td>
                            <span class="badge bg-<?php echo e($team->status === 'active' ? 'success' : 'secondary'); ?>">
                                <?php echo e(ucfirst($team->status)); ?>

                            </span>
                        </td>
                        <td><small><?php echo e($team->created_at->format('M d, Y')); ?></small></td>
                        <td>
                            <a href="<?php echo e(route('business.teams.show', [$business, $team])); ?>" class="btn btn-sm btn-info" title="View">
                                <i class="fas fa-eye"></i>
                            </a>
                            <a href="<?php echo e(route('business.teams.edit', [$business, $team])); ?>" class="btn btn-sm btn-warning" title="Edit">
                                <i class="fas fa-edit"></i>
                            </a>
                            <?php if($team->status !== 'archived'): ?>
                                <form action="<?php echo e(route('business.teams.destroy', [$business, $team])); ?>" method="POST" style="display:inline;">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure?')" title="Delete">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </form>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="6" class="text-center text-muted py-4">
                            No teams yet. <a href="<?php echo e(route('business.teams.create', $business)); ?>">Create one</a>
                        </td>
                    </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Pagination -->
    <div class="d-flex justify-content-between align-items-center mt-4">
        <div>
            Showing <?php echo e($teams->firstItem() ?? 0); ?> to <?php echo e($teams->lastItem() ?? 0); ?> of <?php echo e($teams->total()); ?> teams
        </div>
        <div>
            <?php echo e($teams->links()); ?>

        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.business', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\privasee\resources\views/business/teams/index.blade.php ENDPATH**/ ?>