<?php $__env->startSection('title', 'Admin Sessions'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid py-4">
    <!-- Header -->
    <div class="row mb-4">
        <div class="col-md-8">
            <h1 class="h3 mb-0">Admin Sessions</h1>
            <p class="text-muted">Manage and monitor admin user sessions</p>
        </div>
        <div class="col-md-4 text-end">
            <button class="btn btn-danger btn-sm" id="cleanup-sessions">
                <i class="fas fa-trash"></i> Cleanup Old Sessions
            </button>
        </div>
    </div>

    <!-- Statistics Cards -->
    <div class="row mb-4">
        <div class="col-md-3">
            <div class="card">
                <div class="card-body">
                    <h6 class="card-title text-muted mb-2">Active Sessions</h6>
                    <h3 class="mb-0"><?php echo e($stats['total_active'] ?? 0); ?></h3>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card">
                <div class="card-body">
                    <h6 class="card-title text-muted mb-2">Today Logins</h6>
                    <h3 class="mb-0"><?php echo e($stats['today_logins'] ?? 0); ?></h3>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card">
                <div class="card-body">
                    <h6 class="card-title text-muted mb-2">This Week</h6>
                    <h3 class="mb-0"><?php echo e($stats['this_week_logins'] ?? 0); ?></h3>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card">
                <div class="card-body">
                    <h6 class="card-title text-muted mb-2">Concurrent Users</h6>
                    <h3 class="mb-0"><?php echo e($stats['concurrent_sessions'] ?? 0); ?></h3>
                </div>
            </div>
        </div>
    </div>

    <!-- Filters -->
    <div class="card mb-4">
        <div class="card-body">
            <form method="get" class="row g-3">
                <div class="col-md-3">
                    <label class="form-label">Admin User</label>
                    <select name="user_id" class="form-select">
                        <option value="">All Users</option>
                        <?php if(isset($admins)): ?>
                        <?php $__currentLoopData = $admins; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $admin): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($admin->id); ?>" <?php echo e(request('user_id') == $admin->id ? 'selected' : ''); ?>>
                                <?php echo e($admin->first_name ?? ''); ?> <?php echo e($admin->last_name ?? ''); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </select>
                </div>
                <div class="col-md-3">
                    <label class="form-label">Status</label>
                    <select name="status" class="form-select">
                        <option value="">All</option>
                        <option value="active" <?php echo e(request('status') == 'active' ? 'selected' : ''); ?>>Active</option>
                        <option value="inactive" <?php echo e(request('status') == 'inactive' ? 'selected' : ''); ?>>Inactive</option>
                    </select>
                </div>
                <div class="col-md-3">
                    <label class="form-label">Search (IP/Email)</label>
                    <input type="text" name="search" class="form-control" placeholder="IP address or email" value="<?php echo e(request('search')); ?>">
                </div>
                <div class="col-md-3 d-flex align-items-end">
                    <button type="submit" class="btn btn-primary w-100">
                        <i class="fas fa-search"></i> Filter
                    </button>
                </div>
            </form>
        </div>
    </div>

    <!-- Sessions Table -->
    <div class="card">
        <div class="table-responsive">
            <table class="table table-hover mb-0">
                <thead class="table-light">
                    <tr>
                        <th>Admin User</th>
                        <th>IP Address</th>
                        <th>Browser</th>
                        <th>Login Time</th>
                        <th>Last Activity</th>
                        <th>Status</th>
                        <th>Duration</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if(isset($sessions)): ?>
                    <?php $__empty_1 = true; $__currentLoopData = $sessions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $session): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td>
                                <div class="d-flex align-items-center">
                                    <div class="avatar-sm me-2">
                                        <span class="avatar-title rounded-circle bg-primary text-white">
                                            <?php echo e(strtoupper(substr($session->user->first_name ?? 'A', 0, 1))); ?>

                                        </span>
                                    </div>
                                    <div>
                                        <h6 class="mb-0"><?php echo e($session->user->first_name ?? 'N/A'); ?> <?php echo e($session->user->last_name ?? ''); ?></h6>
                                        <small class="text-muted"><?php echo e($session->user->email ?? 'N/A'); ?></small>
                                    </div>
                                </div>
                            </td>
                            <td>
                                <code><?php echo e($session->ip_address ?? 'N/A'); ?></code>
                            </td>
                            <td>
                                <?php if($session->metadata && isset($session->metadata['browser'])): ?>
                                    <?php echo e($session->metadata['browser']); ?>

                                    <?php if(isset($session->metadata['device'])): ?>
                                        <br><small class="text-muted"><?php echo e($session->metadata['device']); ?></small>
                                    <?php endif; ?>
                                <?php else: ?>
                                    <span class="text-muted">Unknown</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <small><?php echo e($session->login_at ? $session->login_at->format('M d, Y H:i') : 'N/A'); ?></small>
                            </td>
                            <td>
                                <small><?php echo e($session->last_activity_at ? $session->last_activity_at->format('M d, Y H:i') : 'N/A'); ?></small>
                            </td>
                            <td>
                                <?php if($session->is_active && !$session->logout_at): ?>
                                    <span class="badge bg-success">Active</span>
                                <?php else: ?>
                                    <span class="badge bg-secondary">Inactive</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <small><?php echo e(method_exists($session, 'getDuration') ? $session->getDuration() : '0'); ?> seconds</small>
                            </td>
                            <td>
                                <button class="btn btn-sm btn-info" data-bs-toggle="modal" data-bs-target="#sessionDetailModal"
                                    onclick="loadSessionDetail(<?php echo e($session->id); ?>)">
                                    <i class="fas fa-eye"></i>
                                </button>
                                <?php if($session->is_active && $session->user_id !== auth()->id()): ?>
                                    <button class="btn btn-sm btn-danger" onclick="terminateSession(<?php echo e($session->id); ?>)">
                                        <i class="fas fa-times"></i>
                                    </button>
                                <?php endif; ?>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="8" class="text-center text-muted py-4">
                                No sessions found
                            </td>
                        </tr>
                    <?php endif; ?>
                    <?php else: ?>
                    <tr>
                        <td colspan="8" class="text-center text-danger py-4">
                            <i class="fas fa-exclamation-triangle me-2"></i>Unable to load sessions
                        </td>
                    </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Pagination -->
    <div class="d-flex justify-content-between align-items-center mt-4">
        <div>
            <?php if(isset($sessions)): ?>
            Showing <?php echo e($sessions->firstItem() ?? 0); ?> to <?php echo e($sessions->lastItem() ?? 0); ?> of <?php echo e($sessions->total()); ?> sessions
            <?php else: ?>
            No data available
            <?php endif; ?>
        </div>
        <div>
            <?php if(isset($sessions) && $sessions->hasPages()): ?>
            <?php echo e($sessions->links()); ?>

            <?php endif; ?>
        </div>
    </div>
</div>

<!-- Session Detail Modal -->
<div class="modal fade" id="sessionDetailModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Session Details</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div id="sessionDetailContent">
                    Loading...
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
function loadSessionDetail(sessionId) {
    // Fetch session detail
    fetch(`/api/admin/sessions/${sessionId}`)
        .then(response => response.json())
        .then(data => {
            // Display session details
            console.log(data);
        });
}

function terminateSession(sessionId) {
    if (!confirm('Are you sure you want to terminate this session?')) return;

    fetch(`/api/admin/sessions/${sessionId}/terminate`, {
        method: 'POST',
        headers: {
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            alert('Session terminated successfully');
            location.reload();
        }
    });
}

document.getElementById('cleanup-sessions')?.addEventListener('click', function() {
    if (!confirm('Delete sessions older than 90 days?')) return;

    fetch('/api/admin/sessions/cleanup', {
        method: 'POST',
        headers: {
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
        }
    })
    .then(response => response.json())
    .then(data => {
        alert(data.message);
        location.reload();
    });
});
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\privasee\resources\views/admin/sessions/index.blade.php ENDPATH**/ ?>