<?php $__env->startSection('title', 'Admin Chat Management'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <!-- Header -->
    <div class="row mb-4">
        <div class="col-md-8">
            <h1 class="h3 mb-0">
                <i class="fas fa-comments"></i> Chats Management
            </h1>
            <p class="text-muted">Monitor and manage all chats and conversations</p>
        </div>
    </div>

    <!-- Statistics -->
    <div class="row mb-4">
        <div class="col-md-3">
            <div class="card">
                <div class="card-body">
                    <h6 class="text-muted mb-2">Total Chats</h6>
                    <h3 class="mb-0"><?php echo e($stats['total'] ?? 0); ?></h3>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card">
                <div class="card-body">
                    <h6 class="text-muted mb-2">Active</h6>
                    <h3 class="mb-0"><?php echo e($stats['active'] ?? 0); ?></h3>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card">
                <div class="card-body">
                    <h6 class="text-muted mb-2">Total Messages</h6>
                    <h3 class="mb-0"><?php echo e($stats['messages'] ?? 0); ?></h3>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card">
                <div class="card-body">
                    <h6 class="text-muted mb-2">Active Users</h6>
                    <h3 class="mb-0"><?php echo e($stats['active_users'] ?? 0); ?></h3>
                </div>
            </div>
        </div>
    </div>

    <!-- Filters -->
    <div class="card mb-4">
        <div class="card-body">
            <form method="get" class="row g-3">
                <div class="col-md-4">
                    <input type="text" name="search" class="form-control form-control-sm"
                        placeholder="Search chats..." value="<?php echo e(request('search')); ?>">
                </div>
                <div class="col-md-3">
                    <select name="type" class="form-select form-select-sm">
                        <option value="">All Types</option>
                        <option value="team" <?php echo e(request('type') === 'team' ? 'selected' : ''); ?>>Team</option>
                        <option value="business" <?php echo e(request('type') === 'business' ? 'selected' : ''); ?>>Business</option>
                        <option value="direct" <?php echo e(request('type') === 'direct' ? 'selected' : ''); ?>>Direct</option>
                        <option value="group" <?php echo e(request('type') === 'group' ? 'selected' : ''); ?>>Group</option>
                    </select>
                </div>
                <div class="col-md-3">
                    <select name="status" class="form-select form-select-sm">
                        <option value="">All Status</option>
                        <option value="active" <?php echo e(request('status') === 'active' ? 'selected' : ''); ?>>Active</option>
                        <option value="inactive" <?php echo e(request('status') === 'inactive' ? 'selected' : ''); ?>>Inactive</option>
                    </select>
                </div>
                <div class="col-md-2">
                    <button type="submit" class="btn btn-primary btn-sm w-100">
                        <i class="fas fa-filter"></i> Filter
                    </button>
                </div>
            </form>
        </div>
    </div>

    <!-- Chats Table -->
    <div class="card">
        <div class="table-responsive">
            <table class="table table-hover mb-0">
                <thead class="table-light">
                    <tr>
                        <th>Chat Name</th>
                        <th>Type</th>
                        <th>Members</th>
                        <th>Messages</th>
                        <th>Status</th>
                        <th>Last Message</th>
                        <th>Created</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if(isset($chats)): ?>
                    <?php $__empty_1 = true; $__currentLoopData = $chats; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $chat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td>
                            <strong><?php echo e($chat->name ?? 'N/A'); ?></strong>
                            <br>
                            <small class="text-muted"><?php echo e(Str::limit($chat->description ?? '', 40)); ?></small>
                        </td>
                        <td>
                            <span class="badge bg-info"><?php echo e(ucfirst($chat->type ?? 'direct')); ?></span>
                        </td>
                        <td>
                            <?php echo e($chat->participants_count ?? 0); ?>

                        </td>
                        <td>
                            <?php echo e($chat->message_count ?? 0); ?>

                        </td>
                        <td>
                            <span class="badge bg-<?php echo e($chat->is_active ? 'success' : 'secondary'); ?>">
                                <?php echo e($chat->is_active ? 'Active' : 'Inactive'); ?>

                            </span>
                        </td>
                        <td>
                            <?php if($chat->last_message_at): ?>
                                <small><?php echo e($chat->last_message_at->diffForHumans()); ?></small>
                            <?php else: ?>
                                <small class="text-muted">Never</small>
                            <?php endif; ?>
                        </td>
                        <td>
                            <small><?php echo e($chat->created_at ? $chat->created_at->format('M d, Y') : 'N/A'); ?></small>
                        </td>
                        <td>
                            <a href="<?php echo e(route('admin.chats.show', $chat->id)); ?>" class="btn btn-sm btn-info" title="View Messages">
                                <i class="fas fa-eye"></i>
                            </a>
                            <?php if($chat->is_active): ?>
                            <form action="<?php echo e(route('admin.chats.disable', $chat->id)); ?>" method="POST" style="display:inline;">
                                <?php echo csrf_field(); ?>
                                <button type="submit" class="btn btn-sm btn-warning" title="Disable Chat" onclick="return confirm('Disable this chat?')">
                                    <i class="fas fa-ban"></i>
                                </button>
                            </form>
                            <?php else: ?>
                            <form action="<?php echo e(route('admin.chats.enable', $chat->id)); ?>" method="POST" style="display:inline;">
                                <?php echo csrf_field(); ?>
                                <button type="submit" class="btn btn-sm btn-success" title="Enable Chat" onclick="return confirm('Enable this chat?')">
                                    <i class="fas fa-check"></i>
                                </button>
                            </form>
                            <?php endif; ?>
                            <form action="<?php echo e(route('admin.chats.destroy', $chat->id)); ?>" method="POST" style="display:inline;">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button type="submit" class="btn btn-sm btn-danger" title="Delete Chat" onclick="return confirm('Delete this chat permanently?')">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </form>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="8" class="text-center text-muted py-4">
                            No chats found.
                        </td>
                    </tr>
                    <?php endif; ?>
                    <?php else: ?>
                    <tr>
                        <td colspan="8" class="text-center text-danger py-4">
                            <i class="fas fa-exclamation-triangle me-2"></i>Unable to load chats
                        </td>
                    </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Pagination -->
    <div class="d-flex justify-content-between align-items-center mt-4">
        <div>
            <?php if(isset($chats) && method_exists($chats, 'total')): ?>
            Showing <?php echo e($chats->firstItem() ?? 0); ?> to <?php echo e($chats->lastItem() ?? 0); ?> of <?php echo e($chats->total()); ?> chats
            <?php else: ?>
            No data available
            <?php endif; ?>
        </div>
        <div>
            <?php if(isset($chats) && method_exists($chats, 'hasPages') && $chats->hasPages()): ?>
            <?php echo e($chats->links()); ?>

            <?php endif; ?>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\privasee\resources\views/admin/chats/index.blade.php ENDPATH**/ ?>