<?php $__env->startSection('title', 'Staff Details'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <!-- Header -->
    <div class="row mb-4">
        <div class="col-md-8">
            <?php if($staff->user): ?>
                <h1 class="h3 mb-0"><?php echo e($staff->user->first_name); ?> <?php echo e($staff->user->last_name); ?></h1>
                <p class="text-muted"><?php echo e($staff->user->email); ?></p>
            <?php else: ?>
                <h1 class="h3 mb-0"><?php echo e($staff->email ?? 'Pending Staff'); ?></h1>
                <p class="text-muted">
                    <span class="badge bg-warning">Pending Invitation</span>
                </p>
            <?php endif; ?>
        </div>
        <div class="col-md-4 text-end">
            <a href="<?php echo e(route('admin.staff.edit', $staff)); ?>" class="btn btn-warning">
                <i class="fas fa-edit"></i> Edit
            </a>
            <a href="<?php echo e(route('admin.staff.index')); ?>" class="btn btn-secondary">
                <i class="fas fa-arrow-left"></i> Back
            </a>
        </div>
    </div>

    <div class="row">
        <div class="col-md-4">
            <div class="card mb-4">
                <div class="card-header">
                    <h6 class="mb-0">Staff Information</h6>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <label class="text-muted small">Business</label>
                        <p class="mb-0">
                            <a href="<?php echo e(route('admin.businesses.show', $staff->business)); ?>">
                                <?php echo e($staff->business->business_name); ?>

                            </a>
                        </p>
                    </div>
                    <div class="mb-3">
                        <label class="text-muted small">Email</label>
                        <p class="mb-0"><?php echo e($staff->user->email); ?></p>
                    </div>
                    <div class="mb-3">
                        <label class="text-muted small">Phone</label>
                        <p class="mb-0"><?php echo e($staff->user->phone ?? 'N/A'); ?></p>
                    </div>
                    <div class="mb-3">
                        <label class="text-muted small">Role</label>
                        <p class="mb-0">
                            <span class="badge bg-primary"><?php echo e(ucfirst($staff->role)); ?></span>
                        </p>
                    </div>
                    <div class="mb-3">
                        <label class="text-muted small">Team</label>
                        <p class="mb-0">
                            <?php if($staff->team): ?>
                                <span class="badge bg-secondary"><?php echo e($staff->team->name); ?></span>
                            <?php else: ?>
                                <span class="text-muted">-</span>
                            <?php endif; ?>
                        </p>
                    </div>
                    <div class="mb-3">
                        <label class="text-muted small">Status</label>
                        <p class="mb-0">
                            <span class="badge bg-<?php echo e($staff->status === 'active' ? 'success' : 'warning'); ?>">
                                <?php echo e(ucfirst(str_replace('_', ' ', $staff->status))); ?>

                            </span>
                        </p>
                    </div>
                </div>
            </div>

            <div class="card">
                <div class="card-header bg-light">
                    <h6 class="mb-0">Timeline</h6>
                </div>
                <div class="card-body">
                    <div class="mb-2">
                        <label class="text-muted small">Invited</label>
                        <p class="mb-0"><?php echo e($staff->invited_at?->format('M d, Y H:i') ?? 'N/A'); ?></p>
                    </div>
                    <div class="mb-2">
                        <label class="text-muted small">Joined</label>
                        <p class="mb-0"><?php echo e($staff->joined_at?->format('M d, Y H:i') ?? 'N/A'); ?></p>
                    </div>
                    <div class="mb-0">
                        <label class="text-muted small">Created</label>
                        <p class="mb-0"><?php echo e($staff->created_at->format('M d, Y H:i')); ?></p>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-8">
            <div class="card">
                <div class="card-header">
                    <h6 class="mb-0">User Details</h6>
                </div>
                <div class="card-body">
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label class="text-muted small">First Name</label>
                            <p class="mb-0"><?php echo e($staff->user->first_name); ?></p>
                        </div>
                        <div class="col-md-6">
                            <label class="text-muted small">Last Name</label>
                            <p class="mb-0"><?php echo e($staff->user->last_name); ?></p>
                        </div>
                    </div>
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label class="text-muted small">Account Type</label>
                            <p class="mb-0">
                                <span class="badge bg-info"><?php echo e(ucfirst($staff->user->account_type)); ?></span>
                            </p>
                        </div>
                        <div class="col-md-6">
                            <label class="text-muted small">User Status</label>
                            <p class="mb-0">
                                <span class="badge bg-<?php echo e($staff->user->status === 'active' ? 'success' : 'secondary'); ?>">
                                    <?php echo e(ucfirst($staff->user->status)); ?>

                                </span>
                            </p>
                        </div>
                    </div>
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label class="text-muted small">Email Verified</label>
                            <p class="mb-0">
                                <?php if($staff->user->email_verified_at): ?>
                                    <span class="badge bg-success"><?php echo e($staff->user->email_verified_at->format('M d, Y')); ?></span>
                                <?php else: ?>
                                    <span class="badge bg-warning">Pending</span>
                                <?php endif; ?>
                            </p>
                        </div>
                        <div class="col-md-6">
                            <label class="text-muted small">Phone Verified</label>
                            <p class="mb-0">
                                <?php if($staff->user->phone_verified_at): ?>
                                    <span class="badge bg-success"><?php echo e($staff->user->phone_verified_at->format('M d, Y')); ?></span>
                                <?php else: ?>
                                    <span class="badge bg-warning">Pending</span>
                                <?php endif; ?>
                            </p>
                        </div>
                    </div>
                </div>
            </div>

            <div class="card mt-4">
                <div class="card-header">
                    <h6 class="mb-0">Permissions</h6>
                </div>
                <div class="card-body">
                    <?php if(!empty($staff->permissions)): ?>
                        <div class="row">
                            <?php $__currentLoopData = json_decode($staff->permissions, true) ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $permission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="col-md-4 mb-2">
                                <span class="badge bg-secondary"><?php echo e($permission); ?></span>
                            </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    <?php else: ?>
                        <p class="text-muted mb-0">No custom permissions assigned.</p>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\privasee\resources\views/admin/staff/show.blade.php ENDPATH**/ ?>