<?php $__env->startSection('title', 'Configuration Management'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid py-4">
    <!-- Header -->
    <div class="row mb-4">
        <div class="col-md-8">
            <h1 class="h3 mb-0">System Configuration</h1>
            <p class="text-muted">Manage system settings with versioning and rollback support</p>
        </div>
        <div class="col-md-4 text-end">
            <button class="btn btn-primary btn-sm" data-bs-toggle="modal" data-bs-target="#snapshotModal">
                <i class="fas fa-camera"></i> Create Snapshot
            </button>
            <button class="btn btn-info btn-sm" data-bs-toggle="modal" data-bs-target="#versionsModal">
                <i class="fas fa-history"></i> Versions
            </button>
        </div>
    </div>

    <!-- Current Version Info -->
    <?php if($currentVersion): ?>
    <div class="alert alert-info">
        <strong>Current Version:</strong> <?php echo e($currentVersion->version_name); ?>

        <br>
        <small class="text-muted">Created by: <?php echo e($currentVersion->creator->name ?? 'System'); ?> on <?php echo e($currentVersion->created_at->format('M d, Y H:i')); ?></small>
    </div>
    <?php endif; ?>

    <!-- Configuration Groups -->
    <?php $__currentLoopData = $configurations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $group => $configs): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <div class="card mb-4">
        <div class="card-header">
            <h5 class="mb-0"><?php echo e($groups[$group] ?? ucfirst($group)); ?></h5>
        </div>
        <div class="card-body">
            <form id="config-form-<?php echo e($group); ?>" class="configuration-form">
                <?php echo csrf_field(); ?>
                <div class="row">
                    <?php $__currentLoopData = $configs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $config): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-md-6 mb-3">
                        <label class="form-label">
                            <?php echo e($config->description ?? ucfirst(str_replace('_', ' ', $config->key))); ?>

                        </label>

                        <?php if($config->type === 'boolean'): ?>
                            <div class="form-check form-switch">
                                <input class="form-check-input config-input" type="checkbox"
                                    name="configurations[<?php echo e($config->key); ?>]"
                                    value="true"
                                    <?php echo e($config->value === 'true' ? 'checked' : ''); ?>

                                    data-key="<?php echo e($config->key); ?>">
                                <label class="form-check-label" for="config-<?php echo e($config->key); ?>">
                                    <?php echo e($config->value === 'true' ? 'Enabled' : 'Disabled'); ?>

                                </label>
                            </div>

                        <?php elseif($config->type === 'select' && $config->options): ?>
                            <select class="form-select form-select-sm config-input"
                                name="configurations[<?php echo e($config->key); ?>]"
                                data-key="<?php echo e($config->key); ?>">
                                <?php
                                    $options = is_array($config->options)
                                        ? $config->options
                                        : (is_string($config->options) ? json_decode($config->options, true) : []);
                                ?>
                                <?php $__currentLoopData = $options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($option); ?>" <?php echo e($config->value === $option ? 'selected' : ''); ?>>
                                        <?php echo e(ucfirst($option)); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>

                        <?php elseif($config->type === 'json'): ?>
                            <textarea class="form-control form-control-sm config-input"
                                name="configurations[<?php echo e($config->key); ?>]"
                                rows="3"
                                data-key="<?php echo e($config->key); ?>"
                                data-json="true"><?php echo e(is_array($config->value) ? json_encode($config->value, JSON_PRETTY_PRINT) : $config->value); ?></textarea>

                        <?php else: ?>
                            <input type="text" class="form-control form-control-sm config-input"
                                name="configurations[<?php echo e($config->key); ?>]"
                                value="<?php echo e($config->value); ?>"
                                data-key="<?php echo e($config->key); ?>">
                        <?php endif; ?>

                        <?php if($config->description): ?>
                            <small class="text-muted d-block mt-1"><?php echo e($config->description); ?></small>
                        <?php endif; ?>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>

                <div class="mt-3">
                    <button type="submit" class="btn btn-primary btn-sm">
                        <i class="fas fa-save"></i> Save Changes
                    </button>
                </div>
            </form>
        </div>
    </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</div>

<!-- Create Snapshot Modal -->
<div class="modal fade" id="snapshotModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Create Configuration Snapshot</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form id="snapshot-form">
                <?php echo csrf_field(); ?>
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">Snapshot Name</label>
                        <input type="text" class="form-control" name="version_name"
                            placeholder="e.g., Before Payment Integration" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Description</label>
                        <textarea class="form-control" name="description" rows="3"
                            placeholder="What changes is this snapshot protecting against?"></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save"></i> Create Snapshot
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Versions Modal -->
<div class="modal fade" id="versionsModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Configuration Versions</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div id="versionsList" class="list-group">
                    Loading versions...
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
// Handle configuration form submission
document.querySelectorAll('.configuration-form').forEach(form => {
    form.addEventListener('submit', async (e) => {
        e.preventDefault();

        const configs = {};
        form.querySelectorAll('.config-input').forEach(input => {
            const key = input.getAttribute('data-key');
            const isJson = input.getAttribute('data-json');
            const value = input.type === 'checkbox' ? input.checked : input.value;

            if (isJson && typeof value === 'string') {
                try {
                    configs[key] = JSON.parse(value);
                } catch (e) {
                    configs[key] = value;
                }
            } else {
                configs[key] = value;
            }
        });

        try {
            const response = await fetch('/api/admin/configurations/bulk-update', {
                method: 'POST',
                headers: {
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
                    'Content-Type': 'application/json'
                },
                body: JSON.stringify({ configurations: Object.entries(configs).map(([key, value]) => ({key, value})) })
            });

            const data = await response.json();
            if (data.success) {
                alert('Configuration updated successfully');
                location.reload();
            } else {
                alert('Error: ' + data.message);
            }
        } catch (error) {
            alert('Error updating configuration');
            console.error(error);
        }
    });
});

// Handle snapshot form
document.getElementById('snapshot-form')?.addEventListener('submit', async (e) => {
    e.preventDefault();

    const formData = new FormData(e.target);

    try {
        const response = await fetch('/api/admin/configurations/snapshot', {
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
            },
            body: formData
        });

        const data = await response.json();
        if (data.success) {
            alert('Snapshot created successfully');
            bootstrap.Modal.getInstance(document.getElementById('snapshotModal')).hide();
            e.target.reset();
        } else {
            alert('Error: ' + data.message);
        }
    } catch (error) {
        alert('Error creating snapshot');
        console.error(error);
    }
});

// Load versions when modal is shown
document.getElementById('versionsModal')?.addEventListener('show.bs.modal', async () => {
    try {
        const response = await fetch('/api/admin/configurations/versions');
        const data = await response.json();

        const versionsList = document.getElementById('versionsList');
        versionsList.innerHTML = '';

        data.data.data.forEach(version => {
            const element = document.createElement('div');
            element.className = 'list-group-item';
            element.innerHTML = `
                <div class="d-flex justify-content-between align-items-start">
                    <div>
                        <h6 class="mb-1">${version.version_name}</h6>
                        <small class="text-muted">
                            Created: ${new Date(version.created_at).toLocaleString()}
                        </small>
                        ${version.description ? `<p class="mb-0 mt-1 text-muted">${version.description}</p>` : ''}
                    </div>
                    <div>
                        ${version.is_current ? '<span class="badge bg-success">Current</span>' : ''}
                        <button class="btn btn-sm btn-primary" onclick="restoreVersion(${version.id})">
                            Restore
                        </button>
                    </div>
                </div>
            `;
            versionsList.appendChild(element);
        });
    } catch (error) {
        document.getElementById('versionsList').innerHTML = 'Error loading versions';
        console.error(error);
    }
});

async function restoreVersion(versionId) {
    if (!confirm('Are you sure you want to restore this configuration? This action cannot be undone.')) {
        return;
    }

    try {
        const response = await fetch(`/api/admin/configurations/versions/${versionId}/restore`, {
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
                'Content-Type': 'application/json'
            },
            body: JSON.stringify({ confirm: true })
        });

        const data = await response.json();
        if (data.success) {
            alert(data.message);
            location.reload();
        } else {
            alert('Error: ' + data.message);
        }
    } catch (error) {
        alert('Error restoring version');
        console.error(error);
    }
}
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\privasee\resources\views/admin/configurations/advanced.blade.php ENDPATH**/ ?>