<?php $__env->startSection('title', 'Spotlights Management'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <!-- Header -->
    <div class="row mb-4">
        <div class="col-md-8">
            <h1 class="h2 mb-0">
                <i class="fas fa-lightbulb"></i> Spotlights Management
            </h1>
            <p class="text-muted mb-0">Manage and moderate user spotlights</p>
        </div>
        <div class="col-md-4 text-end">
            <a href="<?php echo e(route('admin.spotlight.create')); ?>" class="btn btn-primary">
                <i class="fas fa-plus"></i> Create Spotlight
            </a>
        </div>
    </div>

    <!-- Success Message -->
    <?php if(session('success')): ?>
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <i class="fas fa-check-circle me-2"></i><?php echo e(session('success')); ?>

            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>

    <!-- Statistics -->
    <div class="row mb-4 g-3">
        <div class="col-md-3">
            <div class="card border-0 shadow-sm">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-start">
                        <div>
                            <p class="text-muted mb-1 small">Total Spotlights</p>
                            <h3 class="mb-0"><?php echo e($stats['total']); ?></h3>
                        </div>
                        <div class="text-primary" style="font-size: 2rem;">
                            <i class="fas fa-lightbulb"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card border-0 shadow-sm">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-start">
                        <div>
                            <p class="text-muted mb-1 small">Pending</p>
                            <h3 class="mb-0"><?php echo e($stats['pending']); ?></h3>
                        </div>
                        <div class="text-warning" style="font-size: 2rem;">
                            <i class="fas fa-clock"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card border-0 shadow-sm">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-start">
                        <div>
                            <p class="text-muted mb-1 small">Approved</p>
                            <h3 class="mb-0"><?php echo e($stats['approved']); ?></h3>
                        </div>
                        <div class="text-success" style="font-size: 2rem;">
                            <i class="fas fa-check-circle"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card border-0 shadow-sm">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-start">
                        <div>
                            <p class="text-muted mb-1 small">Rejected</p>
                            <h3 class="mb-0"><?php echo e($stats['rejected']); ?></h3>
                        </div>
                        <div class="text-danger" style="font-size: 2rem;">
                            <i class="fas fa-times-circle"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Filters -->
    <div class="card mb-4 border-0 shadow-sm">
        <div class="card-body">
            <form method="GET" class="row g-3">
                <div class="col-md-3">
                    <label class="form-label">Status</label>
                    <select name="moderation" class="form-select">
                        <option value="all" <?php echo e($moderation === 'all' ? 'selected' : ''); ?>>All</option>
                        <option value="pending" <?php echo e($moderation === 'pending' ? 'selected' : ''); ?>>Pending</option>
                        <option value="approved" <?php echo e($moderation === 'approved' ? 'selected' : ''); ?>>Approved</option>
                        <option value="rejected" <?php echo e($moderation === 'rejected' ? 'selected' : ''); ?>>Rejected</option>
                    </select>
                </div>
                <div class="col-md-9 d-flex align-items-end">
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-filter"></i> Filter
                    </button>
                </div>
            </form>
        </div>
    </div>

    <!-- Spotlights Table -->
    <div class="card border-0 shadow-sm">
        <div class="table-responsive">
            <table class="table table-hover mb-0">
                <thead class="table-light">
                    <tr>
                        <th>ID</th>
                        <th>User</th>
                        <th>Offer</th>
                        <th>Content</th>
                        <th>Media</th>
                        <th>Status</th>
                        <th>Likes</th>
                        <th>Created</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $spotlights; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $spotlight): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td>
                            <span class="badge bg-light text-dark">#<?php echo e($spotlight->id); ?></span>
                        </td>
                        <td>
                            <small>
                                <strong><?php echo e($spotlight->user->first_name ?? 'N/A'); ?></strong><br>
                                <span class="text-muted"><?php echo e($spotlight->user->email ?? ''); ?></span>
                            </small>
                        </td>
                        <td>
                            <?php if($spotlight->offer): ?>
                                <small>
                                    <a href="<?php echo e(route('admin.offers.show', $spotlight->offer->id)); ?>" class="text-decoration-none">
                                        <?php echo e(Str::limit($spotlight->offer->title, 30)); ?>

                                    </a>
                                </small>
                            <?php else: ?>
                                <span class="text-muted small">No Offer</span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <small><?php echo e(Str::limit($spotlight->content, 40)); ?></small>
                        </td>
                        <td>
                            <?php if($spotlight->media_type): ?>
                                <span class="badge bg-info"><?php echo e(ucfirst($spotlight->media_type)); ?></span>
                            <?php else: ?>
                                <span class="text-muted small">-</span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <?php if($spotlight->moderation_status === 'approved'): ?>
                                <span class="badge bg-success">Approved</span>
                            <?php elseif($spotlight->moderation_status === 'rejected'): ?>
                                <span class="badge bg-danger">Rejected</span>
                            <?php else: ?>
                                <span class="badge bg-warning">Pending</span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <span class="badge bg-light text-dark">
                                <i class="fas fa-heart"></i> <?php echo e($spotlight->likes_count); ?>

                            </span>
                        </td>
                        <td>
                            <small class="text-muted"><?php echo e($spotlight->created_at->format('M d, Y')); ?></small>
                        </td>
                        <td>
                            <div class="btn-group btn-group-sm" role="group">
                                <a href="<?php echo e(route('admin.spotlight.show', $spotlight->id)); ?>" class="btn btn-outline-primary" title="View">
                                    <i class="fas fa-eye"></i>
                                </a>
                                <a href="<?php echo e(route('admin.spotlight.edit', $spotlight->id)); ?>" class="btn btn-outline-warning" title="Edit">
                                    <i class="fas fa-edit"></i>
                                </a>
                                <?php if($spotlight->moderation_status !== 'approved'): ?>
                                <form action="<?php echo e(route('admin.spotlight.approve', $spotlight->id)); ?>" method="POST" style="display:inline;">
                                    <?php echo csrf_field(); ?>
                                    <button type="submit" class="btn btn-outline-success btn-sm" title="Approve">
                                        <i class="fas fa-check"></i>
                                    </button>
                                </form>
                                <?php endif; ?>
                                <?php if($spotlight->moderation_status !== 'rejected'): ?>
                                <button type="button" class="btn btn-outline-danger btn-sm" data-bs-toggle="modal" data-bs-target="#rejectModal<?php echo e($spotlight->id); ?>" title="Reject">
                                    <i class="fas fa-times"></i>
                                </button>
                                <?php endif; ?>
                                <form action="<?php echo e(route('admin.spotlight.destroy', $spotlight->id)); ?>" method="POST" style="display:inline;">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button type="submit" class="btn btn-outline-dark btn-sm" title="Delete" onclick="return confirm('Are you sure?')">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </form>
                            </div>

                            <!-- Reject Modal -->
                            <div class="modal fade" id="rejectModal<?php echo e($spotlight->id); ?>" tabindex="-1">
                                <div class="modal-dialog">
                                    <div class="modal-content">
                                        <form action="<?php echo e(route('admin.spotlight.reject', $spotlight->id)); ?>" method="POST">
                                            <?php echo csrf_field(); ?>
                                            <div class="modal-header">
                                                <h5 class="modal-title">Reject Spotlight</h5>
                                                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                            </div>
                                            <div class="modal-body">
                                                <div class="mb-3">
                                                    <label class="form-label">Rejection Notes</label>
                                                    <textarea name="moderation_notes" class="form-control" rows="3" placeholder="Why are you rejecting this spotlight?"></textarea>
                                                </div>
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                                                <button type="submit" class="btn btn-danger">Reject</button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="9" class="text-center text-muted py-4">
                            <i class="fas fa-inbox" style="font-size: 2rem;"></i>
                            <p class="mt-2">No spotlights found</p>
                        </td>
                    </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

        <!-- Pagination -->
        <div class="card-footer bg-white">
            <?php echo e($spotlights->links()); ?>

        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\privasee\resources\views/admin/spotlight/index.blade.php ENDPATH**/ ?>