<?php $__env->startSection('title', 'Teams Management'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <!-- Header -->
    <div class="row mb-4">
        <div class="col-md-8">
            <h1 class="h3 mb-0">
                <i class="fas fa-users"></i> Teams
            </h1>
            <p class="text-muted">Manage all business teams and their members</p>
        </div>
        <div class="col-md-4 text-end">
            <a href="<?php echo e(route('admin.teams.create')); ?>" class="btn btn-primary">
                <i class="fas fa-plus"></i> Create Team
            </a>
        </div>
    </div>

    <!-- Filters -->
    <div class="card mb-4">
        <div class="card-body">
            <form method="get" class="row g-3">
                <div class="col-md-3">
                    <input type="text" name="search" class="form-control form-control-sm"
                        placeholder="Search teams..." value="<?php echo e(request('search')); ?>">
                </div>
                <div class="col-md-2">
                    <select name="status" class="form-select form-select-sm">
                        <option value="">All Status</option>
                        <option value="active" <?php echo e(request('status') === 'active' ? 'selected' : ''); ?>>Active</option>
                        <option value="inactive" <?php echo e(request('status') === 'inactive' ? 'selected' : ''); ?>>Inactive</option>
                        <option value="archived" <?php echo e(request('status') === 'archived' ? 'selected' : ''); ?>>Archived</option>
                    </select>
                </div>
                <div class="col-md-3">
                    <select name="business_id" class="form-select form-select-sm">
                        <option value="">All Businesses</option>
                        <?php if(isset($businesses)): ?>
                        <?php $__currentLoopData = $businesses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bid => $bname): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($bid); ?>" <?php echo e(request('business_id') == $bid ? 'selected' : ''); ?>>
                                <?php echo e($bname); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </select>
                </div>
                <div class="col-md-2">
                    <button type="submit" class="btn btn-primary btn-sm w-100">
                        <i class="fas fa-filter"></i> Filter
                    </button>
                </div>
                <div class="col-md-2">
                    <a href="<?php echo e(route('admin.teams.index')); ?>" class="btn btn-secondary btn-sm w-100">
                        <i class="fas fa-sync"></i> Reset
                    </a>
                </div>
            </form>
        </div>
    </div>

    <!-- Statistics -->
    <div class="row mb-4">
        <div class="col-md-3">
            <div class="card">
                <div class="card-body">
                    <h6 class="text-muted mb-2">Total Teams</h6>
                    <h3 class="mb-0"><?php echo e($teams->total()); ?></h3>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card">
                <div class="card-body">
                    <h6 class="text-muted mb-2">Active Teams</h6>
                    <h3 class="mb-0"><?php echo e($stats['active'] ?? 0); ?></h3>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card">
                <div class="card-body">
                    <h6 class="text-muted mb-2">Total Members</h6>
                    <h3 class="mb-0"><?php echo e($stats['members'] ?? 0); ?></h3>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card">
                <div class="card-body">
                    <h6 class="text-muted mb-2">Chats</h6>
                    <h3 class="mb-0"><?php echo e($stats['chats'] ?? 0); ?></h3>
                </div>
            </div>
        </div>
    </div>

    <!-- Teams Table -->
    <div class="card">
        <div class="table-responsive">
            <table class="table table-hover mb-0">
                <thead class="table-light">
                    <tr>
                        <th>Team Name</th>
                        <th>Business</th>
                        <th>Description</th>
                        <th>Members</th>
                        <th>Status</th>
                        <th>Created</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $teams; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $team): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td>
                            <strong><?php echo e($team->name); ?></strong>
                        </td>
                        <td>
                            <a href="<?php echo e(route('admin.businesses.show', $team->business)); ?>">
                                <?php echo e($team->business->business_name); ?>

                            </a>
                        </td>
                        <td>
                            <small class="text-muted"><?php echo e(Str::limit($team->description, 40)); ?></small>
                        </td>
                        <td>
                            <span class="badge bg-info"><?php echo e($team->member_count); ?></span>
                        </td>
                        <td>
                            <span class="badge bg-<?php echo e($team->status === 'active' ? 'success' : 'secondary'); ?>">
                                <?php echo e(ucfirst($team->status)); ?>

                            </span>
                        </td>
                        <td><small><?php echo e($team->created_at->format('M d, Y')); ?></small></td>
                        <td>
                            <a href="<?php echo e(route('admin.teams.show', $team->id)); ?>" class="btn btn-sm btn-info" title="View">
                                <i class="fas fa-eye"></i>
                            </a>
                            <a href="<?php echo e(route('admin.teams.edit', $team->id)); ?>" class="btn btn-sm btn-warning" title="Edit">
                                <i class="fas fa-edit"></i>
                            </a>
                            <form action="<?php echo e(route('admin.teams.destroy', $team->id)); ?>" method="POST" style="display:inline;">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure?')" title="Delete">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </form>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="7" class="text-center text-muted py-4">
                            No teams found.
                        </td>
                    </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Pagination -->
    <div class="d-flex justify-content-between align-items-center mt-4">
        <div>
            Showing <?php echo e($teams->firstItem() ?? 0); ?> to <?php echo e($teams->lastItem() ?? 0); ?> of <?php echo e($teams->total()); ?> teams
        </div>
        <div>
            <?php echo e($teams->links()); ?>

        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\privasee\resources\views/admin/teams/index.blade.php ENDPATH**/ ?>