<?php $__env->startSection('title', 'Referral Program'); ?>

<?php $__env->startSection('content'); ?>
<div class="mb-4">
    <h2 class="fw-bold mb-1">Referral Program</h2>
    <p class="text-muted mb-0">Refer businesses and earn rewards</p>
</div>

<!-- Stats Cards -->
<div class="row g-4 mb-4">
    <div class="col-md-3">
        <div class="stat-card">
            <div class="stat-icon" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);">
                <i class="bi bi-people text-white"></i>
            </div>
            <div class="stat-label">Total Referrals</div>
            <div class="stat-value"><?php echo e($stats['total'] ?? 0); ?></div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="stat-card">
            <div class="stat-icon" style="background: linear-gradient(135deg, #43e97b 0%, #38f9d7 100%);">
                <i class="bi bi-check-circle text-white"></i>
            </div>
            <div class="stat-label">Successful</div>
            <div class="stat-value"><?php echo e($stats['successful'] ?? 0); ?></div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="stat-card">
            <div class="stat-icon" style="background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);">
                <i class="bi bi-currency-dollar text-white"></i>
            </div>
            <div class="stat-label">Rewards Earned</div>
            <div class="stat-value">AED <?php echo e(number_format($stats['earned'] ?? 0)); ?></div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="stat-card">
            <div class="stat-icon" style="background: linear-gradient(135deg, #fa709a 0%, #fee140 100%);">
                <i class="bi bi-clock-history text-white"></i>
            </div>
            <div class="stat-label">Pending Rewards</div>
            <div class="stat-value">AED <?php echo e(number_format($stats['pending'] ?? 0)); ?></div>
        </div>
    </div>
</div>

<!-- Referral Card -->
<div class="row g-4 mb-4">
    <div class="col-lg-6">
        <div class="table-card">
            <div class="card-body text-center p-4">
                <div class="mb-3">
                    <div class="d-inline-flex align-items-center justify-content-center" style="width: 80px; height: 80px; background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); border-radius: 1rem;">
                        <i class="bi bi-gift text-white fs-1"></i>
                    </div>
                </div>
                <h4 class="fw-bold mb-2">Your Referral Code</h4>
                <p class="text-muted mb-4">Share this code and earn AED 500 for each successful referral</p>

                <div class="input-group input-group-lg mb-3">
                    <input type="text" class="form-control text-center fw-bold" value="<?php echo e($referralCode); ?>" id="referralCode" readonly>
                    <button class="btn btn-primary" onclick="copyCode()">
                        <i class="bi bi-clipboard"></i> Copy
                    </button>
                </div>

                <div class="d-flex gap-2 justify-content-center">
                    <button class="btn btn-outline-primary">
                        <i class="bi bi-whatsapp"></i>
                    </button>
                    <button class="btn btn-outline-primary">
                        <i class="bi bi-envelope"></i>
                    </button>
                    <button class="btn btn-outline-primary">
                        <i class="bi bi-twitter"></i>
                    </button>
                    <button class="btn btn-outline-primary">
                        <i class="bi bi-facebook"></i>
                    </button>
                </div>
            </div>
        </div>
    </div>

    <div class="col-lg-6">
        <div class="table-card">
            <div class="card-header">
                <h5 class="mb-0 fw-bold">How It Works</h5>
            </div>
            <div class="card-body">
                <div class="d-flex mb-4">
                    <div class="me-3">
                        <div class="d-flex align-items-center justify-content-center" style="width: 48px; height: 48px; background: #e8eaf6; border-radius: 0.75rem;">
                            <span class="fw-bold text-primary">1</span>
                        </div>
                    </div>
                    <div>
                        <h6 class="fw-bold mb-1">Share Your Code</h6>
                        <p class="text-muted small mb-0">Send your unique referral code to business owners</p>
                    </div>
                </div>

                <div class="d-flex mb-4">
                    <div class="me-3">
                        <div class="d-flex align-items-center justify-content-center" style="width: 48px; height: 48px; background: #e8eaf6; border-radius: 0.75rem;">
                            <span class="fw-bold text-primary">2</span>
                        </div>
                    </div>
                    <div>
                        <h6 class="fw-bold mb-1">They Sign Up</h6>
                        <p class="text-muted small mb-0">Your referral creates an account using your code</p>
                    </div>
                </div>

                <div class="d-flex mb-4">
                    <div class="me-3">
                        <div class="d-flex align-items-center justify-content-center" style="width: 48px; height: 48px; background: #e8eaf6; border-radius: 0.75rem;">
                            <span class="fw-bold text-primary">3</span>
                        </div>
                    </div>
                    <div>
                        <h6 class="fw-bold mb-1">Subscription Purchase</h6>
                        <p class="text-muted small mb-0">They complete verification and purchase a subscription</p>
                    </div>
                </div>

                <div class="d-flex">
                    <div class="me-3">
                        <div class="d-flex align-items-center justify-content-center" style="width: 48px; height: 48px; background: #e8eaf6; border-radius: 0.75rem;">
                            <span class="fw-bold text-primary">4</span>
                        </div>
                    </div>
                    <div>
                        <h6 class="fw-bold mb-1">Earn Rewards</h6>
                        <p class="text-muted small mb-0">Receive AED 500 credit to your account</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Referrals Table -->
<div class="table-card mb-4">
    <div class="card-header">
        <h5 class="mb-0 fw-bold">Your Referrals</h5>
    </div>
    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="table table-hover mb-0">
                <thead>
                    <tr>
                        <th>Business Name</th>
                        <th>Email</th>
                        <th>Status</th>
                        <th>Signup Date</th>
                        <th>Reward Status</th>
                        <th>Amount</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $referrals ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $referral): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td>
                            <div class="fw-semibold"><?php echo e($referral->referred->businesses->first()->business_name ?? 'N/A'); ?></div>
                        </td>
                        <td><?php echo e($referral->referred->email); ?></td>
                        <td>
                            <?php if($referral->referred->status === 'active'): ?>
                                <span class="badge bg-success">Active</span>
                            <?php else: ?>
                                <span class="badge bg-warning">Pending</span>
                            <?php endif; ?>
                        </td>
                        <td><?php echo e($referral->created_at->format('M d, Y')); ?></td>
                        <td>
                            <?php if($referral->reward_status === 'claimed'): ?>
                                <span class="badge bg-success"><i class="bi bi-check-circle me-1"></i>Claimed</span>
                            <?php elseif($referral->reward_status === 'earned'): ?>
                                <span class="badge bg-info"><i class="bi bi-gift me-1"></i>Earned</span>
                            <?php elseif($referral->reward_status === 'pending'): ?>
                                <span class="badge bg-warning"><i class="bi bi-clock me-1"></i>Pending</span>
                            <?php else: ?>
                                <span class="badge bg-secondary">Expired</span>
                            <?php endif; ?>
                        </td>
                        <td class="fw-semibold">AED <?php echo e(number_format($referral->reward_amount)); ?></td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="6" class="text-center py-5">
                            <i class="bi bi-people fs-1 text-muted d-block mb-2"></i>
                            <p class="text-muted mb-0">No referrals yet. Start sharing your code!</p>
                        </td>
                    </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- Reward History -->
<div class="table-card">
    <div class="card-header">
        <h5 class="mb-0 fw-bold">Reward History</h5>
    </div>
    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="table table-hover mb-0">
                <thead>
                    <tr>
                        <th>Date</th>
                        <th>Description</th>
                        <th>Amount</th>
                        <th>Status</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $rewardHistory ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $reward): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td><?php echo e($reward->created_at->format('M d, Y')); ?></td>
                        <td>Referral reward for <?php echo e($reward->referred_business_name); ?></td>
                        <td class="fw-semibold text-success">+AED <?php echo e(number_format($reward->amount)); ?></td>
                        <td>
                            <span class="badge bg-success">Credited</span>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="4" class="text-center py-4 text-muted">No reward history yet</td>
                    </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
function copyCode() {
    const code = document.getElementById('referralCode');
    code.select();
    document.execCommand('copy');

    // Show feedback
    const btn = event.target.closest('button');
    const originalHTML = btn.innerHTML;
    btn.innerHTML = '<i class="bi bi-check"></i> Copied!';
    setTimeout(() => {
        btn.innerHTML = originalHTML;
    }, 2000);
}
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.business', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\privasee\resources\views/business/referral/index.blade.php ENDPATH**/ ?>