<?php $__env->startSection('title', 'Business Management'); ?>

<?php $__env->startSection('content'); ?>
<div class="d-flex justify-content-between align-items-center mb-4">
    <div>
        <h2 class="fw-bold mb-1">Business Management</h2>
        <p class="text-muted mb-0">Review, verify, and manage businesses on the platform</p>
    </div>
</div>

<!-- Stats Cards -->
<div class="row g-4 mb-4">
    <div class="col-md-3">
        <div class="stat-card">
            <div class="stat-label">Total Businesses</div>
            <div class="stat-value" style="font-size: 28px;"><?php echo e(number_format($stats['total'] ?? 487)); ?></div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="stat-card">
            <div class="stat-label">Verified</div>
            <div class="stat-value" style="font-size: 28px; color: var(--admin-secondary);"><?php echo e(number_format($stats['verified'] ?? 398)); ?></div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="stat-card">
            <div class="stat-label">Pending Verification</div>
            <div class="stat-value" style="font-size: 28px; color: var(--admin-warning);"><?php echo e(number_format($stats['pending'] ?? 67)); ?></div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="stat-card">
            <div class="stat-label">Suspended</div>
            <div class="stat-value" style="font-size: 28px; color: var(--admin-danger);"><?php echo e(number_format($stats['suspended'] ?? 10)); ?></div>
        </div>
    </div>
</div>

<!-- Filters -->
<div class="admin-card mb-4">
    <div class="admin-card-body">
        <form method="GET" class="row g-3">
            <div class="col-md-4">
                <input type="text" class="form-control" name="search" placeholder="Search by business name, owner, license..."
                       value="<?php echo e(request('search')); ?>">
            </div>
            <div class="col-md-2">
                <select class="form-select" name="status">
                    <option value="">All Status</option>
                    <option value="pending" <?php echo e(request('status') === 'pending' ? 'selected' : ''); ?>>Pending</option>
                    <option value="verified" <?php echo e(request('status') === 'verified' ? 'selected' : ''); ?>>Verified</option>
                    <option value="rejected" <?php echo e(request('status') === 'rejected' ? 'selected' : ''); ?>>Rejected</option>
                    <option value="suspended" <?php echo e(request('status') === 'suspended' ? 'selected' : ''); ?>>Suspended</option>
                </select>
            </div>
            <div class="col-md-2">
                <select class="form-select" name="subscription">
                    <option value="">All Subscriptions</option>
                    <option value="free">Free</option>
                    <option value="basic">Basic</option>
                    <option value="premium">Premium</option>
                    <option value="enterprise">Enterprise</option>
                </select>
            </div>
            <div class="col-md-2">
                <select class="form-select" name="sort">
                    <option value="newest">Newest First</option>
                    <option value="oldest">Oldest First</option>
                    <option value="name_asc">Name A-Z</option>
                    <option value="rating_desc">Highest Rating</option>
                </select>
            </div>
            <div class="col-md-2">
                <button type="submit" class="btn btn-primary w-100">
                    <i class="bi bi-search me-2"></i>Filter
                </button>
            </div>
        </form>
    </div>
</div>

<!-- Businesses Table -->
<div class="admin-card">
    <div class="admin-card-header d-flex justify-content-between align-items-center">
        <h5 class="mb-0 fw-bold">All Businesses (<?php echo e(isset($businesses) ? $businesses->total() : 0); ?>)</h5>
        <button class="btn btn-sm btn-outline-primary" onclick="exportBusinesses()">
            <i class="bi bi-download me-1"></i>Export
        </button>
    </div>
    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="table table-hover mb-0">
                <thead>
                    <tr>
                        <th>Business</th>
                        <th>Owner</th>
                        <th>License</th>
                        <th>Subscription</th>
                        <th>Rating</th>
                        <th>Joined</th>
                        <th>Status</th>
                        <th style="width: 150px;">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if(isset($businesses)): ?>
                    <?php $__empty_1 = true; $__currentLoopData = $businesses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $business): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <?php
                            $logoUrl = $business->logo && \Illuminate\Support\Facades\Storage::exists($business->logo)
                                ? \Illuminate\Support\Facades\Storage::url($business->logo)
                                : 'https://ui-avatars.com/api/?name=' . urlencode($business->business_name ?? 'Business');
                        ?>
                    <tr>
                        <td>
                            <div class="d-flex align-items-center">
                                <img src="<?php echo e($logoUrl); ?>" alt="Logo"
                                     class="rounded me-2" width="40" height="40" style="object-fit: cover;">
                                <div>
                                    <div class="fw-semibold"><?php echo e($business->business_name ?? 'N/A'); ?></div>
                                    <small class="text-muted"><?php echo e(isset($business->venues) ? count($business->venues) : 0); ?> venues</small>
                                </div>
                            </div>
                        </td>
                        <td><?php echo e($business->owner->full_name ?? 'N/A'); ?></td>
                        <td>
                            <span class="font-monospace small"><?php echo e($business->trade_license_number ?? 'N/A'); ?></span>
                        </td>
                        <td>
                            <?php if($business->subscription_status === 'active'): ?>
                                <span class="badge bg-success"><?php echo e(ucfirst($business->subscriptionPlan->name ?? 'Free')); ?></span>
                            <?php else: ?>
                                <span class="badge bg-secondary">Inactive</span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <div class="d-flex align-items-center">
                                <i class="bi bi-star-fill text-warning me-1"></i>
                                <span class="fw-semibold"><?php echo e(number_format($business->rating ?? 0, 1)); ?></span>
                                <small class="text-muted ms-1">(<?php echo e($business->total_reviews ?? 0); ?>)</small>
                            </div>
                        </td>
                        <td><?php echo e($business->created_at ? $business->created_at->format('M d, Y') : 'N/A'); ?></td>
                        <td>
                            <?php if($business->status === 'verified'): ?>
                                <span class="badge bg-success">
                                    <i class="bi bi-check-circle me-1"></i>Verified
                                </span>
                            <?php elseif($business->status === 'pending'): ?>
                                <span class="badge bg-warning">
                                    <i class="bi bi-clock me-1"></i>Pending
                                </span>
                            <?php elseif($business->status === 'rejected'): ?>
                                <span class="badge bg-danger">
                                    <i class="bi bi-x-circle me-1"></i>Rejected
                                </span>
                            <?php else: ?>
                                <span class="badge bg-dark">
                                    <i class="bi bi-ban me-1"></i>Suspended
                                </span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <div class="table-actions">
                                <button class="btn btn-icon btn-outline-primary" onclick="viewBusiness(<?php echo e($business->id); ?>)">
                                    <i class="bi bi-eye"></i>
                                </button>
                                <?php if($business->status === 'pending'): ?>
                                    <button class="btn btn-icon btn-outline-success" onclick="verifyBusiness(<?php echo e($business->id); ?>)">
                                        <i class="bi bi-check-lg"></i>
                                    </button>
                                <?php endif; ?>
                                <button class="btn btn-icon btn-outline-danger" onclick="suspendBusiness(<?php echo e($business->id); ?>)">
                                    <i class="bi bi-ban"></i>
                                </button>
                            </div>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="8" class="text-center py-5">
                            <i class="bi bi-building fs-1 text-muted d-block mb-3"></i>
                            <h5>No businesses found</h5>
                        </td>
                    </tr>
                    <?php endif; ?>
                    <?php else: ?>
                    <tr>
                        <td colspan="8" class="text-center text-danger py-5">
                            <i class="bi bi-exclamation-triangle fs-1 d-block mb-3"></i>
                            <h5>Unable to load businesses</h5>
                        </td>
                    </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
    <?php if(isset($businesses) && method_exists($businesses, 'hasPages') && $businesses->hasPages()): ?>
    <div class="card-footer bg-white">
        <?php echo e($businesses->links()); ?>

    </div>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
function viewBusiness(id) {
    window.location.href = `/admin/businesses/${id}`;
}

function verifyBusiness(id) {
    window.location.href = `/admin/businesses/${id}/verify`;
}

function suspendBusiness(id) {
    if (confirm('Are you sure you want to suspend this business?')) {
        fetch(`/admin/businesses/${id}/suspend`, {
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
                'Content-Type': 'application/json'
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                location.reload();
            } else {
                alert(data.message || 'Failed to suspend business');
            }
        });
    }
}

function exportBusinesses() {
    window.location.href = '/admin/businesses/export';
}
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\privasee\resources\views/admin/businesses/index.blade.php ENDPATH**/ ?>