<?php $__env->startSection('title', 'Venues Management'); ?>

<?php $__env->startSection('content'); ?>
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h2 class="fw-bold mb-1">Venues Management</h2>
            <p class="text-muted mb-0">Manage and moderate business venues</p>
        </div>
    </div>

    <!-- Stats -->
    <div class="row g-3 mb-4">
        <div class="col-md-3">
            <div class="stat-card">
                <div class="stat-label">Total Venues</div>
                <div class="stat-value"><?php echo e(number_format($stats['total'] ?? 0)); ?></div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="stat-card">
                <div class="stat-label">Active Venues</div>
                <div class="stat-value text-success"><?php echo e(number_format($stats['active'] ?? 0)); ?></div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="stat-card">
                <div class="stat-label">Inactive Venues</div>
                <div class="stat-value text-danger"><?php echo e(number_format($stats['inactive'] ?? 0)); ?></div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="stat-card">
                <div class="stat-label">Featured Venues</div>
                <div class="stat-value text-primary"><?php echo e(number_format($stats['featured'] ?? 0)); ?></div>
            </div>
        </div>
    </div>

    <!-- Venues Table -->
    <div class="admin-card">
        <div class="admin-card-header">
            <h5 class="mb-0 fw-bold">All Venues (<?php echo e($venues->total()); ?>)</h5>
        </div>
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover mb-0">
                    <thead>
                    <tr>
                        <th>Venue</th>
                        <th>Business</th>
                        <th>Category</th>
                        <th>City</th>
                        <th>Status</th>
                        <th>Rating</th>
                        <th>Created</th>
                        <th>Actions</th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $venues; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $venue): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td>
                                <div class="fw-semibold"><?php echo e($venue->name); ?></div>
                                <small class="text-muted"><?php echo e(Str::limit($venue->address ?? '', 30)); ?></small>
                            </td>
                            <td><?php echo e($venue->business->business_name ?? 'N/A'); ?></td>
                            <td><?php echo e($venue->category->name ?? 'N/A'); ?></td>
                            <td><?php echo e($venue->city); ?></td>
                            <td>
                            <span class="badge bg-<?php echo e($venue->status === 'active' ? 'success' : 'danger'); ?>">
                                <?php echo e(ucfirst($venue->status)); ?>

                            </span>
                            </td>
                            <td>
                                <i class="bi bi-star-fill text-warning"></i> <?php echo e(number_format($venue->rating ?? 0, 1)); ?>

                            </td>
                            <td><?php echo e($venue->created_at->format('M d, Y')); ?></td>
                            <td>
                                <a href="<?php echo e(route('admin.venues.show', $venue->id)); ?>" class="btn btn-sm btn-outline-primary" title="View">
                                    <i class="bi bi-eye"></i>
                                </a>
                                <a href="<?php echo e(route('admin.venues.edit', $venue->id)); ?>" class="btn btn-sm btn-outline-secondary" title="Edit">
                                    <i class="bi bi-pencil"></i>
                                </a>
                                <?php if($venue->status !== 'active'): ?>
                                <form action="<?php echo e(route('admin.venues.approve', $venue->id)); ?>" method="POST" style="display:inline;">
                                    <?php echo csrf_field(); ?>
                                    <button type="submit" class="btn btn-sm btn-outline-success" title="Approve" onclick="return confirm('Approve this venue?')">
                                        <i class="bi bi-check-circle"></i>
                                    </button>
                                </form>
                                <a href="<?php echo e(route('admin.venues.reject-form', $venue->id)); ?>" class="btn btn-sm btn-outline-danger" title="Reject">
                                    <i class="bi bi-x-circle"></i>
                                </a>
                                <?php endif; ?>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="8" class="text-center text-muted py-4">
                                <i class="bi bi-inbox fs-1 d-block mb-2"></i>
                                No venues found
                            </td>
                        </tr>
                    <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
        <?php if($venues->hasPages()): ?>
            <div class="admin-card-footer">
                <?php echo e($venues->links()); ?>

            </div>
        <?php endif; ?>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\privasee\resources\views/admin/venues/index.blade.php ENDPATH**/ ?>