<?php $__env->startSection('content'); ?>
<div class="container-fluid mt-4">
    <div class="row" style="height: calc(100vh - 100px);">
        <!-- Chat Header -->
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-3 pb-3 border-bottom">
                <div>
                    <h4 class="mb-0">
                        <?php if($chat->type === 'group'): ?>
                            <i class="bi bi-people-fill"></i>
                        <?php else: ?>
                            <i class="bi bi-person-circle"></i>
                        <?php endif; ?>
                        <?php echo e($chat->subject); ?>

                    </h4>
                    <small class="text-muted"><?php echo e($chat->participants->count()); ?> participant<?php echo e($chat->participants->count() !== 1 ? 's' : ''); ?></small>
                </div>
                <div>
                    <a href="<?php echo e(route('business.chats.index')); ?>" class="btn btn-sm btn-secondary">
                        <i class="bi bi-arrow-left"></i> Back
                    </a>
                    <?php if(auth()->id() === $chat->created_by): ?>
                        <form action="<?php echo e(route('business.chats.destroy', $chat)); ?>" method="POST" style="display: inline;">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Delete this chat?')">
                                <i class="bi bi-trash"></i>
                            </button>
                        </form>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <!-- Messages Area -->
        <div class="col-12" style="overflow-y: auto; height: calc(100% - 120px); background: #f8f9fa;">
            <div id="messages-container" class="p-3">
                <?php $__empty_1 = true; $__currentLoopData = $messages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $message): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <div class="mb-3 d-flex <?php echo e($message->sender_id === auth()->id() ? 'justify-content-end' : ''); ?>">
                        <div class="card <?php echo e($message->sender_id === auth()->id() ? 'bg-primary text-white' : 'bg-white'); ?>"
                             style="max-width: 70%;">
                            <div class="card-body py-2 px-3">
                                <?php if($chat->type === 'group' && $message->sender_id !== auth()->id()): ?>
                                    <small class="d-block fw-bold mb-1"><?php echo e($message->sender->first_name); ?> <?php echo e($message->sender->last_name); ?></small>
                                <?php endif; ?>
                                <p class="mb-0"><?php echo e($message->content); ?></p>
                                <small class="d-block mt-2 <?php echo e($message->sender_id === auth()->id() ? 'text-white-50' : 'text-muted'); ?>">
                                    <?php echo e($message->created_at->format('H:i')); ?>

                                </small>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <div class="alert alert-info text-center">
                        <p class="mb-0">No messages yet. Start the conversation!</p>
                    </div>
                <?php endif; ?>
            </div>
        </div>

        <!-- Message Input Area -->
        <div class="col-12 border-top pt-3" style="height: auto;">
            <form action="<?php echo e(route('business.chats.send-message', $chat)); ?>" method="POST" class="d-flex gap-2">
                <?php echo csrf_field(); ?>
                <input type="text" class="form-control" name="message" placeholder="Type a message..." required
                       autocomplete="off">
                <button type="submit" class="btn btn-primary">
                    <i class="bi bi-send"></i> Send
                </button>
            </form>
        </div>
    </div>
</div>

<script>
// Auto-scroll to latest message
document.getElementById('messages-container').scrollTop = document.getElementById('messages-container').scrollHeight;
</script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.business', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\privasee\resources\views/business/chats/show.blade.php ENDPATH**/ ?>