<?php $__env->startSection('title', 'Edit Marketing Campaign'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <!-- Header -->
    <div class="row mb-4">
        <div class="col-md-8">
            <h1 class="h3 mb-0">Edit Marketing Campaign</h1>
            <p class="text-muted">Update campaign details</p>
        </div>
        <div class="col-md-4 text-end">
            <a href="<?php echo e(route('admin.marketing.campaigns.view', $campaign->id)); ?>" class="btn btn-secondary">
                <i class="fas fa-arrow-left"></i> Back to Campaign
            </a>
        </div>
    </div>

    <div class="row">
        <div class="col-md-8">
            <div class="card">
                <div class="card-body">
                    <!-- Campaign Info -->
                    <div class="alert alert-info mb-4">
                        <i class="fas fa-info-circle"></i>
                        <strong>Campaign:</strong> <?php echo e($campaign->name); ?><br>
                        <strong>Business:</strong> <?php echo e($campaign->business->name); ?><br>
                        <strong>Status:</strong> <span class="badge bg-<?php echo e($campaign->status === 'active' ? 'success' : ($campaign->status === 'pending' ? 'warning' : 'secondary')); ?>"><?php echo e(ucfirst($campaign->status)); ?></span>
                    </div>

                    <form id="campaignForm">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('PUT'); ?>

                        <!-- Campaign Name -->
                        <div class="mb-3">
                            <label class="form-label" for="name">Campaign Name <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" id="name" name="name" value="<?php echo e($campaign->name); ?>" required>
                        </div>

                        <!-- Campaign Description -->
                        <div class="mb-3">
                            <label class="form-label" for="description">Description</label>
                            <textarea class="form-control" id="description" name="description" rows="3"><?php echo e($campaign->description); ?></textarea>
                        </div>

                        <!-- Campaign Type (Read-only) -->
                        <div class="mb-3">
                            <label class="form-label">Campaign Type</label>
                            <input type="text" class="form-control" value="<?php echo e(ucfirst($campaign->type)); ?>" disabled>
                            <small class="text-muted">Package type cannot be changed after creation</small>
                        </div>

                        <!-- Targeting -->
                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label" for="venue_id">Target Venue (Optional)</label>
                                    <select class="form-select" id="venue_id" name="venue_id">
                                        <option value="">No specific venue</option>
                                        <?php $__currentLoopData = $venues; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $venue): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($venue->id); ?>" <?php echo e(($campaign->targeting_options['venue_id'] ?? null) === $venue->id ? 'selected' : ''); ?>>
                                            <?php echo e($venue->name); ?>

                                        </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label" for="offer_id">Target Offer (Optional)</label>
                                    <select class="form-select" id="offer_id" name="offer_id">
                                        <option value="">No specific offer</option>
                                        <?php $__currentLoopData = $offers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $offer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($offer->id); ?>" <?php echo e(($campaign->targeting_options['offer_id'] ?? null) === $offer->id ? 'selected' : ''); ?>>
                                            <?php echo e($offer->name); ?>

                                        </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>
                        </div>

                        <!-- Campaign Duration -->
                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label" for="start_date">Start Date <span class="text-danger">*</span></label>
                                    <input type="date" class="form-control" id="start_date" name="start_date" value="<?php echo e($campaign->start_date->format('Y-m-d')); ?>" required>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label" for="end_date">End Date <span class="text-danger">*</span></label>
                                    <input type="date" class="form-control" id="end_date" name="end_date" value="<?php echo e($campaign->end_date->format('Y-m-d')); ?>" required>
                                </div>
                            </div>
                        </div>

                        <!-- Budget -->
                        <div class="mb-3">
                            <label class="form-label" for="budget">Budget (AED) <span class="text-danger">*</span></label>
                            <input type="number" class="form-control" id="budget" name="budget" step="0.01" min="0" value="<?php echo e($campaign->budget); ?>" required>
                        </div>

                        <!-- Submit Buttons -->
                        <div class="d-flex gap-2">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save"></i> Update Campaign
                            </button>
                            <a href="<?php echo e(route('admin.marketing.campaigns.view', $campaign->id)); ?>" class="btn btn-secondary">
                                <i class="fas fa-times"></i> Cancel
                            </a>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <div class="col-md-4">
            <!-- Campaign Info -->
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0">Campaign Information</h5>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <p class="text-muted mb-1">Business</p>
                        <h6><?php echo e($campaign->business->name); ?></h6>
                    </div>

                    <div class="mb-3">
                        <p class="text-muted mb-1">Package</p>
                        <h6><?php echo e($campaign->package->name ?? 'N/A'); ?></h6>
                    </div>

                    <div class="mb-3">
                        <p class="text-muted mb-1">Created</p>
                        <h6><?php echo e($campaign->created_at->format('M d, Y H:i')); ?></h6>
                    </div>

                    <div class="mb-3">
                        <p class="text-muted mb-1">Status</p>
                        <h6><span class="badge bg-<?php echo e($campaign->status === 'active' ? 'success' : ($campaign->status === 'pending' ? 'warning' : 'secondary')); ?>"><?php echo e(ucfirst($campaign->status)); ?></span></h6>
                    </div>

                    <?php if($campaign->approved_by): ?>
                    <div class="mb-3">
                        <p class="text-muted mb-1">Approved By</p>
                        <h6><?php echo e($campaign->approver->first_name ?? 'N/A'); ?> <?php echo e($campaign->approver->last_name ?? ''); ?></h6>
                    </div>

                    <div class="mb-3">
                        <p class="text-muted mb-1">Approved At</p>
                        <h6>
                            <?php if($campaign->approved_at): ?>
                                <?php if(is_string($campaign->approved_at)): ?>
                                    <?php echo e(\Carbon\Carbon::parse($campaign->approved_at)->format('M d, Y H:i')); ?>

                                <?php else: ?>
                                    <?php echo e($campaign->approved_at->format('M d, Y H:i')); ?>

                                <?php endif; ?>
                            <?php else: ?>
                                N/A
                            <?php endif; ?>
                        </h6>
                    </div>
                    <?php endif; ?>

                    <hr>

                    <div class="alert alert-info">
                        <i class="fas fa-lightbulb"></i>
                        <small>Only campaign name, description, targets, duration, and budget can be edited. To change the campaign type or package, create a new campaign.</small>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
document.getElementById('campaignForm').addEventListener('submit', function(e) {
    e.preventDefault();

    const formData = new FormData(this);
    const data = Object.fromEntries(formData);

    fetch('<?php echo e(route("admin.marketing.campaigns.update", $campaign->id)); ?>', {
        method: 'PUT',
        headers: {
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
            'Content-Type': 'application/json'
        },
        body: JSON.stringify(data)
    })
    .then(response => response.json())
    .then(result => {
        if (result.success) {
            alert('Campaign updated successfully!');
            window.location.href = '<?php echo e(route("admin.marketing.campaigns.view", $campaign->id)); ?>';
        } else {
            alert('Error: ' + (result.message || 'Failed to update campaign'));
        }
    })
    .catch(error => alert('Error: ' + error.message));
});
</script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\privasee\resources\views/admin/marketing/edit-campaign.blade.php ENDPATH**/ ?>