<?php $__env->startSection('title', 'Notifications'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid py-4">
    <!-- Header -->
    <div class="row mb-4">
        <div class="col-md-8">
            <h1 class="h3 mb-0">
                <i class="bi bi-bell"></i> Notifications
            </h1>
            <p class="text-muted">Stay updated with your business activities</p>
        </div>
        <div class="col-md-4 text-end">
            <?php if($unreadCount > 0): ?>
                <button class="btn btn-sm btn-primary" id="markAllRead">
                    <i class="bi bi-check2-all"></i> Mark All Read (<?php echo e($unreadCount); ?>)
                </button>
            <?php endif; ?>
        </div>
    </div>

    <!-- Tabs Navigation -->
    <ul class="nav nav-tabs mb-4" role="tablist">
        <li class="nav-item">
            <button class="nav-link active" data-bs-toggle="tab" data-bs-target="#all">
                <i class="bi bi-inbox"></i> All
            </button>
        </li>
        <li class="nav-item">
            <button class="nav-link" data-bs-toggle="tab" data-bs-target="#unread">
                <i class="bi bi-exclamation-circle"></i> Unread <span class="badge bg-danger ms-2"><?php echo e($unreadCount); ?></span>
            </button>
        </li>
        <li class="nav-item">
            <button class="nav-link" data-bs-toggle="tab" data-bs-target="#offers">
                <i class="bi bi-tag"></i> Offers
            </button>
        </li>
        <li class="nav-item">
            <button class="nav-link" data-bs-toggle="tab" data-bs-target="#staff">
                <i class="bi bi-people"></i> Staff
            </button>
        </li>
        <li class="nav-item">
            <button class="nav-link" data-bs-toggle="tab" data-bs-target="#system">
                <i class="bi bi-gear"></i> System
            </button>
        </li>
    </ul>

    <!-- Tab Content -->
    <div class="tab-content">
        <!-- All Notifications Tab -->
        <div class="tab-pane fade show active" id="all">
            <div class="card border-0 shadow-sm">
                <?php if($allNotifications->count() > 0): ?>
                    <div class="list-group list-group-flush">
                        <?php $__currentLoopData = $allNotifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="list-group-item">
                                <div class="d-flex justify-content-between align-items-start">
                                    <div class="flex-grow-1">
                                        <h6 class="mb-1 fw-bold">
                                            <?php echo e(\App\Http\Controllers\Business\NotificationController::getNotificationTitle($notification)); ?>

                                            <?php if(!$notification->isRead()): ?>
                                                <span class="badge bg-primary ms-2">New</span>
                                            <?php endif; ?>
                                        </h6>
                                        <p class="mb-2 text-muted small">
                                            <?php echo e(\App\Http\Controllers\Business\NotificationController::getNotificationMessage($notification)); ?>

                                        </p>
                                        <small class="text-muted">
                                            <i class="bi bi-clock"></i> <?php echo e($notification->created_at->diffForHumans()); ?>

                                        </small>
                                    </div>
                                    <div class="ms-3">
                                        <button class="btn btn-sm btn-light" onclick="markNotificationRead(<?php echo e($notification->id); ?>)">
                                            <i class="bi bi-check"></i>
                                        </button>
                                        <button class="btn btn-sm btn-light" onclick="deleteNotification(<?php echo e($notification->id); ?>)">
                                            <i class="bi bi-trash"></i>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                <?php else: ?>
                    <div class="text-center py-5">
                        <i class="bi bi-inbox" style="font-size: 3rem; color: #ccc;"></i>
                        <p class="text-muted mt-3">No notifications</p>
                    </div>
                <?php endif; ?>
            </div>
        </div>

        <!-- Unread Tab -->
        <div class="tab-pane fade" id="unread">
            <div class="card border-0 shadow-sm">
                <?php
                    $unreadNotifs = $allNotifications->filter(fn($n) => !$n->isRead());
                ?>
                <?php if($unreadNotifs->count() > 0): ?>
                    <div class="list-group list-group-flush">
                        <?php $__currentLoopData = $unreadNotifs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="list-group-item bg-light">
                                <h6 class="mb-1 fw-bold">
                                    <?php echo e(\App\Http\Controllers\Business\NotificationController::getNotificationTitle($notification)); ?>

                                    <span class="badge bg-danger ms-2">New</span>
                                </h6>
                                <p class="mb-2 text-muted small">
                                    <?php echo e(\App\Http\Controllers\Business\NotificationController::getNotificationMessage($notification)); ?>

                                </p>
                                <small class="text-muted">
                                    <i class="bi bi-clock"></i> <?php echo e($notification->created_at->diffForHumans()); ?>

                                </small>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                <?php else: ?>
                    <div class="text-center py-5">
                        <i class="bi bi-check-circle" style="font-size: 3rem; color: #ccc;"></i>
                        <p class="text-muted mt-3">All caught up!</p>
                    </div>
                <?php endif; ?>
            </div>
        </div>

        <!-- Offers Tab -->
        <div class="tab-pane fade" id="offers">
            <div class="card border-0 shadow-sm">
                <?php
                    $offerNotifs = $allNotifications->filter(fn($n) => str_contains($n->type, 'offer'));
                ?>
                <?php if($offerNotifs->count() > 0): ?>
                    <div class="list-group list-group-flush">
                        <?php $__currentLoopData = $offerNotifs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="list-group-item">
                                <h6 class="mb-1"><?php echo e(\App\Http\Controllers\Business\NotificationController::getNotificationTitle($notification)); ?></h6>
                                <p class="mb-0 text-muted small"><?php echo e(\App\Http\Controllers\Business\NotificationController::getNotificationMessage($notification)); ?></p>
                                <small class="text-muted"><?php echo e($notification->created_at->diffForHumans()); ?></small>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                <?php else: ?>
                    <div class="text-center py-5">
                        <i class="bi bi-tag" style="font-size: 3rem; color: #ccc;"></i>
                        <p class="text-muted mt-3">No offer notifications</p>
                    </div>
                <?php endif; ?>
            </div>
        </div>

        <!-- Staff Tab -->
        <div class="tab-pane fade" id="staff">
            <div class="card border-0 shadow-sm">
                <?php
                    $staffNotifs = $allNotifications->filter(fn($n) => str_contains($n->type, 'staff'));
                ?>
                <?php if($staffNotifs->count() > 0): ?>
                    <div class="list-group list-group-flush">
                        <?php $__currentLoopData = $staffNotifs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="list-group-item">
                                <h6 class="mb-1"><?php echo e(\App\Http\Controllers\Business\NotificationController::getNotificationTitle($notification)); ?></h6>
                                <p class="mb-0 text-muted small"><?php echo e(\App\Http\Controllers\Business\NotificationController::getNotificationMessage($notification)); ?></p>
                                <small class="text-muted"><?php echo e($notification->created_at->diffForHumans()); ?></small>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                <?php else: ?>
                    <div class="text-center py-5">
                        <i class="bi bi-people" style="font-size: 3rem; color: #ccc;"></i>
                        <p class="text-muted mt-3">No staff notifications</p>
                    </div>
                <?php endif; ?>
            </div>
        </div>

        <!-- System Tab -->
        <div class="tab-pane fade" id="system">
            <div class="card border-0 shadow-sm">
                <?php
                    $systemNotifs = $allNotifications->filter(fn($n) => str_contains($n->type, 'system'));
                ?>
                <?php if($systemNotifs->count() > 0): ?>
                    <div class="list-group list-group-flush">
                        <?php $__currentLoopData = $systemNotifs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="list-group-item">
                                <h6 class="mb-1"><?php echo e(\App\Http\Controllers\Business\NotificationController::getNotificationTitle($notification)); ?></h6>
                                <p class="mb-0 text-muted small"><?php echo e(\App\Http\Controllers\Business\NotificationController::getNotificationMessage($notification)); ?></p>
                                <small class="text-muted"><?php echo e($notification->created_at->diffForHumans()); ?></small>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                <?php else: ?>
                    <div class="text-center py-5">
                        <i class="bi bi-gear" style="font-size: 3rem; color: #ccc;"></i>
                        <p class="text-muted mt-3">No system notifications</p>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<script>
    function markNotificationRead(id) {
        fetch(`<?php echo e(url('/business/notifications')); ?>/${id}/mark-read`, {
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
                'Content-Type': 'application/json'
            }
        }).then(response => {
            if (response.ok) {
                location.reload();
            }
        });
    }

    function deleteNotification(id) {
        if (confirm('Are you sure you want to delete this notification?')) {
            fetch(`<?php echo e(url('/business/notifications')); ?>/${id}`, {
                method: 'DELETE',
                headers: {
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
                    'Content-Type': 'application/json'
                }
            }).then(response => {
                if (response.ok) {
                    location.reload();
                }
            });
        }
    }

    document.getElementById('markAllRead')?.addEventListener('click', function() {
        fetch(`<?php echo e(url('/business/notifications/mark-all-read')); ?>`, {
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
                'Content-Type': 'application/json'
            }
        }).then(response => {
            if (response.ok) {
                location.reload();
            }
        });
    });
</script>

<style>
    .notification-item {
        transition: all 0.3s ease;
    }

    .notification-item:hover {
        background-color: #f8f9fa;
    }

    .list-group-item {
        border-left: 3px solid transparent;
        padding: 1rem;
    }

    .list-group-item.bg-light {
        border-left-color: #0d6efd;
    }
</style>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.business', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\privasee\resources\views/business/notifications/index.blade.php ENDPATH**/ ?>