<?php $__env->startSection('title', 'Business Details - ' . $business->business_name); ?>

<?php $__env->startSection('content'); ?>
    <div class="admin-header mb-4">
        <div>
            <h2><?php echo e($business->business_name); ?></h2>
            <p class="text-muted mb-0">
                Owner: <?php echo e($business->owner->full_name); ?> | <?php echo e($business->email); ?>

            </p>
        </div>
        <div class="d-flex gap-2">
            <?php if($business->status === 'pending'): ?>
                <button class="btn btn-success" onclick="approveBusiness(<?php echo e($business->id); ?>)">
                    <i class="bi bi-check-circle me-2"></i>Approve
                </button>
                <button class="btn btn-danger" onclick="rejectBusiness(<?php echo e($business->id); ?>)">
                    <i class="bi bi-x-circle me-2"></i>Reject
                </button>
            <?php endif; ?>
            <a href="<?php echo e(route('admin.businesses.index')); ?>" class="btn btn-outline-secondary">
                <i class="bi bi-arrow-left me-2"></i>Back
            </a>
        </div>
    </div>

    <!-- Status & Stats -->
    <div class="row g-4 mb-4">
        <div class="col-md-3">
            <div class="card border-0 shadow-sm">
                <div class="card-body">
                    <div class="text-muted small mb-2">Status</div>
                    <?php if($business->status === 'verified'): ?>
                        <span class="badge bg-success px-3 py-2">
                        <i class="bi bi-patch-check me-1"></i>Verified
                    </span>
                    <?php elseif($business->status === 'pending'): ?>
                        <span class="badge bg-warning px-3 py-2">
                        <i class="bi bi-clock me-1"></i>Pending
                    </span>
                    <?php elseif($business->status === 'rejected'): ?>
                        <span class="badge bg-danger px-3 py-2">
                        <i class="bi bi-x-circle me-1"></i>Rejected
                    </span>
                    <?php else: ?>
                        <span class="badge bg-secondary px-3 py-2"><?php echo e(ucfirst($business->status)); ?></span>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <div class="col-md-3">
            <div class="card border-0 shadow-sm">
                <div class="card-body">
                    <div class="text-muted small mb-2">Total Venues</div>
                    <div class="fs-4 fw-bold text-primary"><?php echo e($business->venues()->count()); ?></div>
                </div>
            </div>
        </div>

        <div class="col-md-3">
            <div class="card border-0 shadow-sm">
                <div class="card-body">
                    <div class="text-muted small mb-2">Total Offers</div>
                    <div class="fs-4 fw-bold text-success"><?php echo e($business->offers()->count()); ?></div>
                </div>
            </div>
        </div>

        <div class="col-md-3">
            <div class="card border-0 shadow-sm">
                <div class="card-body">
                    <div class="text-muted small mb-2">Rating</div>
                    <div class="fs-4 fw-bold text-warning">
                        <?php if($business->rating): ?>
                            <?php echo e(number_format($business->rating, 1)); ?> <i class="bi bi-star-fill"></i>
                        <?php else: ?>
                            No ratings yet
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row g-4">
        <div class="col-lg-8">
            <!-- Business Information -->
            <div class="card border-0 shadow-sm mb-4">
                <div class="card-header bg-white border-bottom">
                    <h5 class="mb-0 fw-bold">Business Information</h5>
                </div>
                <div class="card-body">
                    <div class="row g-3">
                        <div class="col-md-6">
                            <label class="text-muted small">Business Name</label>
                            <div class="fw-semibold"><?php echo e($business->business_name); ?></div>
                        </div>

                        <div class="col-12">
                            <label class="text-muted small">Description</label>
                            <div><?php echo e($business->description ?? 'No description provided'); ?></div>
                        </div>

                        <div class="col-md-6">
                            <label class="text-muted small">License Number</label>
                            <div class="fw-semibold"><?php echo e($business->trade_license_number ?? 'N/A'); ?></div>
                        </div>

                        <div class="col-md-6">
                            <label class="text-muted small">License Document</label>

                            <div>
                                <?php if($business->trade_license_document): ?>
                                    <a href="<?php echo e(Storage::url($business->trade_license_document)); ?>" target="_blank">
                                        View Document
                                    </a>
                                <?php else: ?>
                                    N/A
                                <?php endif; ?>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <label class="text-muted small">Phone</label>
                            <div><?php echo e($business->phone); ?></div>
                        </div>

                        <div class="col-md-6">
                            <label class="text-muted small">Email</label>
                            <div><?php echo e($business->email); ?></div>
                        </div>

                        <?php if($business->website): ?>
                            <div class="col-12">
                                <label class="text-muted small">Website</label>
                                <div><a href="<?php echo e($business->website); ?>" target="_blank"><?php echo e($business->website); ?></a></div>
                            </div>
                        <?php endif; ?>






                        <div class="col-md-6">
                            <label class="text-muted small">Registered On</label>
                            <div><?php echo e($business->created_at->format('M d, Y h:i A')); ?></div>
                        </div>

                        <div class="col-md-6">
                            <label class="text-muted small">Last Updated</label>
                            <div><?php echo e($business->updated_at->format('M d, Y h:i A')); ?></div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Documents -->
            <?php if($business->license_document || $business->registration_document): ?>
                <div class="card border-0 shadow-sm mb-4">
                    <div class="card-header bg-white border-bottom">
                        <h5 class="mb-0 fw-bold">Documents</h5>
                    </div>
                    <div class="card-body">
                        <div class="row g-3">
                            <?php if($business->license_document): ?>
                                <div class="col-md-6">
                                    <div class="border rounded p-3">
                                        <div class="d-flex align-items-center mb-2">
                                            <i class="bi bi-file-earmark-pdf text-danger fs-3 me-2"></i>
                                            <div>
                                                <div class="fw-semibold">Trade License</div>
                                                <small class="text-muted">Uploaded document</small>
                                            </div>
                                        </div>
                                        <a href="<?php echo e(Storage::url($business->license_document)); ?>"
                                           target="_blank"
                                           class="btn btn-sm btn-outline-primary w-100">
                                            <i class="bi bi-download me-2"></i>View Document
                                        </a>
                                    </div>
                                </div>
                            <?php endif; ?>

                            <?php if($business->registration_document): ?>
                                <div class="col-md-6">
                                    <div class="border rounded p-3">
                                        <div class="d-flex align-items-center mb-2">
                                            <i class="bi bi-file-earmark-pdf text-danger fs-3 me-2"></i>
                                            <div>
                                                <div class="fw-semibold">Registration Certificate</div>
                                                <small class="text-muted">Uploaded document</small>
                                            </div>
                                        </div>
                                        <a href="<?php echo e(Storage::url($business->registration_document)); ?>"
                                           target="_blank"
                                           class="btn btn-sm btn-outline-primary w-100">
                                            <i class="bi bi-download me-2"></i>View Document
                                        </a>
                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            <?php endif; ?>

            <!-- Venues -->
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-white border-bottom">
                    <h5 class="mb-0 fw-bold">Venues</h5>

                    <a href="<?php echo e(route('admin.venues.create-for-business', $business->id)); ?>"
                       class="btn btn-sm btn-primary">
                        <i class="bi bi-plus-circle me-2"></i>Add Venue
                    </a>
                </div>
                <div class="card-body p-0">
                    <?php
                        $venues = $business->venues()->take(10)->get();
                    ?>

                    <?php if($venues->count() > 0): ?>
                        <div class="table-responsive">
                            <table class="table table-hover mb-0">
                                <thead class="bg-light">
                                <tr>
                                    <th>Venue Name</th>
                                    <th>Category</th>
                                    <th>City</th>
                                    <th>Status</th>
                                    <th>Actions</th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php $__currentLoopData = $venues; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $venue): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td class="fw-semibold"><?php echo e($venue->name); ?></td>
                                        <td><?php echo e($venue->category->name ?? 'N/A'); ?></td>
                                        <td><?php echo e($venue->city); ?></td>
                                        <td>
                                            <?php if($venue->status === 'active'): ?>
                                                <span class="badge bg-success">Active</span>
                                            <?php else: ?>
                                                <span class="badge bg-secondary"><?php echo e(ucfirst($venue->status)); ?></span>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <a href="<?php echo e(route('admin.venues.show', $venue->id)); ?>"
                                               class="btn btn-sm btn-outline-primary">
                                                <i class="bi bi-eye"></i>
                                            </a>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    <?php else: ?>
                        <div class="text-center py-4 text-muted">
                            No venues registered yet
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <!-- Sidebar -->
        <div class="col-lg-4">
            <!-- Owner Information -->
            <div class="card border-0 shadow-sm mb-4">
                <div class="card-header bg-white border-bottom">
                    <h5 class="mb-0 fw-bold">Owner Information</h5>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <label class="text-muted small">Full Name</label>
                        <div class="fw-semibold"><?php echo e($business->owner->full_name); ?></div>
                    </div>

                    <div class="mb-3">
                        <label class="text-muted small">Email</label>
                        <div><?php echo e($business->owner->email); ?></div>
                    </div>

                    <div class="mb-3">
                        <label class="text-muted small">Phone</label>
                        <div><?php echo e($business->owner->phone ?? 'N/A'); ?></div>
                    </div>

                    <div class="mb-0">
                        <label class="text-muted small">Account Status</label>
                        <div>
                            <?php if($business->owner->status === 'active'): ?>
                                <span class="badge bg-success">Active</span>
                            <?php else: ?>
                                <span class="badge bg-secondary"><?php echo e(ucfirst($business->owner->status)); ?></span>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Assign Subscription -->
            <div class="card border-0 shadow-sm mb-4">
                <div class="card-header bg-white border-bottom">
                    <h5 class="mb-0 fw-bold">Assign Subscription</h5>
                </div>
                <div class="card-body">
                    <form action="<?php echo e(route('admin.businesses.assign-subscription', $business->id)); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <div class="mb-3">
                            <label class="form-label">Subscription Plan</label>
                            <select class="form-select" name="plan_id" id="planSelect" required>
                                <option value="">Select Plan</option>
                                <?php
                                    $publicPlans = \App\Models\SubscriptionPlan::where('type', 'business')
                                        ->where('is_active', true)
                                        ->where('is_private', false)
                                        ->where('price', 0)
                                        ->orderBy('price')
                                        ->get();
                                    $privatePlans = \App\Models\SubscriptionPlan::where('type', 'business')
                                        ->where('is_active', true)
                                        ->where('is_private', true)
                                        ->orderBy('price')
                                        ->get();
                                ?>

                                <?php if($publicPlans->count() > 0): ?>
                                    <optgroup label="Public Plans">
                                        <?php $__currentLoopData = $publicPlans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($plan->id); ?>"
                                                    data-price="<?php echo e($plan->price); ?>"
                                                <?php echo e($business->subscription_plan_id == $plan->id ? 'selected' : ''); ?>>
                                                <?php echo e($plan->name); ?> - <?php echo e($plan->price == 0 ? 'FREE' : 'AED ' . $plan->price . ' / ' . $plan->duration); ?>

                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </optgroup>
                                <?php endif; ?>

                                <?php if($privatePlans->count() > 0): ?>
                                    <optgroup label="Private Plans (Admin Only)">
                                        <?php $__currentLoopData = $privatePlans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($plan->id); ?>"
                                                    data-price="<?php echo e($plan->price); ?>"
                                                <?php echo e($business->subscription_plan_id == $plan->id ? 'selected' : ''); ?>>
                                                🔒 <?php echo e($plan->name); ?> - <?php echo e($plan->price == 0 ? 'FREE' : 'AED ' . $plan->price . ' / ' . $plan->duration); ?>

                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </optgroup>
                                <?php endif; ?>
                            </select>
                            <small class="text-muted">Private plans are only visible to admins and can be assigned manually.</small>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Duration (Days)</label>
                            <input type="number" class="form-control" name="duration" id="durationInput"
                                   min="1" max="3650" value="30" required>
                            <small class="text-muted d-block mt-1">
                                Quick select:
                                <a href="#" onclick="setDays(7); return false;" class="text-decoration-none">7</a> |
                                <a href="#" onclick="setDays(30); return false;" class="text-decoration-none">30</a> |
                                <a href="#" onclick="setDays(90); return false;" class="text-decoration-none">90</a> |
                                <a href="#" onclick="setDays(180); return false;" class="text-decoration-none">180</a> |
                                <a href="#" onclick="setDays(365); return false;" class="text-decoration-none">365</a> days
                            </small>
                        </div>

                        <button type="submit" class="btn btn-primary w-100">
                            <i class="bi bi-check-circle me-2"></i>Assign Subscription
                        </button>
                    </form>

                    <script>
                        function setDays(days) {
                            document.getElementById('durationInput').value = days;
                        }
                    </script>
                </div>
            </div>

            <!-- Current Subscription Info -->
            <?php if($business->subscription_plan_id): ?>
                <div class="card border-0 shadow-sm mb-4">
                    <div class="card-header bg-white border-bottom">
                        <h5 class="mb-0 fw-bold">Current Subscription</h5>
                    </div>
                    <div class="card-body">
                        <div class="mb-3">
                            <label class="text-muted small">Plan</label>
                            <div class="fw-semibold"><?php echo e($business->subscriptionPlan->name ?? 'N/A'); ?></div>
                        </div>

                        <div class="mb-3">
                            <label class="text-muted small">Status</label>
                            <div>
                                <?php if($business->subscription_status === 'active'): ?>
                                    <span class="badge bg-success">Active</span>
                                <?php elseif($business->subscription_status === 'expired'): ?>
                                    <span class="badge bg-danger">Expired</span>
                                <?php elseif($business->subscription_status === 'cancelled'): ?>
                                    <span class="badge bg-secondary">Cancelled</span>
                                <?php else: ?>
                                    <span class="badge bg-warning"><?php echo e(ucfirst($business->subscription_status)); ?></span>
                                <?php endif; ?>
                            </div>
                        </div>

                        <div class="mb-3">
                            <label class="text-muted small">Start Date</label>
                            <div><?php echo e($business->subscription_start_date ? $business->subscription_start_date->format('M d, Y') : 'N/A'); ?></div>
                        </div>

                        <div class="mb-0">
                            <label class="text-muted small">End Date</label>
                            <div><?php echo e($business->subscription_end_date ? $business->subscription_end_date->format('M d, Y') : 'N/A'); ?></div>
                        </div>
                    </div>
                </div>
            <?php endif; ?>

            <!-- Admin Actions -->
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-white border-bottom">
                    <h5 class="mb-0 fw-bold">Admin Actions</h5>
                </div>
                <div class="card-body">
                    <?php if($business->status === 'pending'): ?>

                        <a class="btn btn-success w-100 mb-2" href="<?php echo e(route('admin.businesses.verify', $business->id)); ?>">
                            <i class="bi bi-check-circle me-2"></i>Verify Business
                        </a>

                    <?php else: ?>
                        <button class="btn btn-warning w-100 mb-2" onclick="suspendBusiness(<?php echo e($business->id); ?>)">
                            <i class="bi bi-pause-circle me-2"></i>Suspend Business
                        </button>
                    <?php endif; ?>

                    <a href="<?php echo e(route('admin.users.show', $business->owner_id)); ?>"
                       class="btn btn-outline-primary w-100 mb-2">
                        <i class="bi bi-person me-2"></i>View Owner Profile
                    </a>

                    <button class="btn btn-outline-danger w-100" onclick="deleteBusiness(<?php echo e($business->id); ?>)">
                        <i class="bi bi-trash me-2"></i>Delete Business
                    </button>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script>
        function approveBusiness(id) {
            if (confirm('Approve this business?')) {
                fetch(`/admin/businesses/${id}/approve`, {
                    method: 'POST',
                    headers: {
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
                        'Accept': 'application/json'
                    }
                })
                    .then(response => response.json())
                    .then(data => {
                        if (data.success) {
                            location.reload();
                        } else {
                            alert(data.message || 'Error approving business');
                        }
                    });
            }
        }

        function rejectBusiness(id) {
            const reason = prompt('Enter rejection reason:');
            if (reason) {
                fetch(`/admin/businesses/${id}/reject`, {
                    method: 'POST',
                    headers: {
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
                        'Content-Type': 'application/json',
                        'Accept': 'application/json'
                    },
                    body: JSON.stringify({ reason: reason })
                })
                    .then(response => response.json())
                    .then(data => {
                        if (data.success) {
                            location.reload();
                        } else {
                            alert(data.message || 'Error rejecting business');
                        }
                    });
            }
        }

        function suspendBusiness(id) {
            const reason = prompt('Enter suspension reason:');
            if (reason) {
                fetch(`/admin/businesses/${id}/suspend`, {
                    method: 'POST',
                    headers: {
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
                        'Content-Type': 'application/json',
                        'Accept': 'application/json'
                    },
                    body: JSON.stringify({ reason: reason })
                })
                    .then(response => response.json())
                    .then(data => {
                        if (data.success) {
                            location.reload();
                        } else {
                            alert(data.message || 'Error suspending business');
                        }
                    });
            }
        }

        function deleteBusiness(id) {
            if (confirm('Are you sure you want to delete this business? This action cannot be undone.')) {
                fetch(`/admin/businesses/${id}`, {
                    method: 'DELETE',
                    headers: {
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
                        'Accept': 'application/json'
                    }
                })
                    .then(response => response.json())
                    .then(data => {
                        if (data.success) {
                            window.location.href = '/admin/businesses';
                        } else {
                            alert(data.message || 'Error deleting business');
                        }
                    });
            }
        }
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\privasee\resources\views/admin/businesses/show.blade.php ENDPATH**/ ?>