<?php $__env->startSection('title', 'My Campaigns'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row mb-4">
        <div class="col-md-6">
            <h1 class="h3 mb-0">My Marketing Campaigns</h1>
            <p class="text-muted">Manage and monitor your marketing campaigns</p>
        </div>
    </div>

    <!-- Statistics -->
    <div class="row mb-4">
        <div class="col-md-3">
            <div class="card text-center">
                <div class="card-body">
                    <h3 class="mb-0"><?php echo e($stats['total'] ?? 0); ?></h3>
                    <p class="text-muted mb-0">Total Campaigns</p>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card text-center">
                <div class="card-body">
                    <h3 class="mb-0 text-success"><?php echo e($stats['active'] ?? 0); ?></h3>
                    <p class="text-muted mb-0">Active</p>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card text-center">
                <div class="card-body">
                    <h3 class="mb-0 text-warning"><?php echo e($stats['pending'] ?? 0); ?></h3>
                    <p class="text-muted mb-0">Pending</p>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card text-center">
                <div class="card-body">
                    <h3 class="mb-0 text-info"><?php echo e($stats['completed'] ?? 0); ?></h3>
                    <p class="text-muted mb-0">Completed</p>
                </div>
            </div>
        </div>
    </div>

    <!-- Horizontal Tabs Navigation -->
































    <!-- Campaigns Table -->
    <div class="card">
        <div class="table-responsive">
            <table class="table table-hover mb-0">
                <thead class="table-light">
                    <tr>
                        <th>Campaign Name</th>
                        <th>Type</th>
                        <th>Duration</th>
                        <th>Budget</th>
                        <th>Status</th>
                        <th>Performance</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $campaigns; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $campaign): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td>
                            <strong><?php echo e($campaign->name); ?></strong>
                            <br>
                            <small class="text-muted"><?php echo e(Str::limit($campaign->description, 40)); ?></small>
                        </td>
                        <td>
                            <span class="badge bg-secondary"><?php echo e(ucfirst($campaign->type ?? 'N/A')); ?></span>
                        </td>
                        <td>
                            <small><?php echo e($campaign->start_date->format('M d')); ?> - <?php echo e($campaign->end_date->format('M d, Y')); ?></small>
                        </td>
                        <td>
                            <strong>AED <?php echo e(number_format($campaign->budget, 2)); ?></strong>
                        </td>
                        <td>
                            <span class="badge bg-<?php echo e($campaign->status === 'active' ? 'success' : ($campaign->status === 'pending' ? 'warning' : ($campaign->status === 'paused' ? 'secondary' : 'info'))); ?>">
                                <?php echo e(ucfirst($campaign->status)); ?>

                            </span>
                        </td>
                        <td>
                            <?php if($campaign->analytics && count($campaign->analytics) > 0): ?>
                                <?php
                                    $totalClicks = $campaign->analytics->sum('clicks');
                                    $totalImpressions = $campaign->analytics->sum('impressions');
                                    $ctr = $totalImpressions > 0 ? round(($totalClicks / $totalImpressions) * 100, 2) : 0;
                                ?>
                                <small>
                                    <i class="bi bi-eye"></i> <?php echo e(number_format($totalImpressions)); ?>

                                    <i class="bi bi-hand-index"></i> <?php echo e(number_format($totalClicks)); ?>

                                    <br>
                                    <strong>CTR: <?php echo e($ctr); ?>%</strong>
                                </small>
                            <?php else: ?>
                                <small class="text-muted">No data yet</small>
                            <?php endif; ?>
                        </td>
                        <td>
                            <a href="<?php echo e(route('business.marketing.campaign.view', $campaign->id)); ?>" class="btn btn-sm btn-info" title="View Details">
                                <i class="bi bi-eye"></i>
                            </a>
                            <?php if($campaign->status === 'active'): ?>
                            <button class="btn btn-sm btn-warning" onclick="pauseCampaign(<?php echo e($campaign->id); ?>)" title="Pause">
                                <i class="bi bi-pause-circle"></i>
                            </button>
                            <?php elseif($campaign->status === 'paused'): ?>
                            <button class="btn btn-sm btn-success" onclick="resumeCampaign(<?php echo e($campaign->id); ?>)" title="Resume">
                                <i class="bi bi-play-circle"></i>
                            </button>
                            <?php endif; ?>
                            <?php if($campaign->status === 'pending'): ?>
                            <button class="btn btn-sm btn-danger" onclick="deleteCampaign(<?php echo e($campaign->id); ?>)" title="Delete">
                                <i class="bi bi-trash"></i>
                            </button>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="7" class="text-center py-4 text-muted">
                            <i class="bi bi-inbox" style="font-size: 2rem;"></i>
                            <p class="mt-2">No campaigns found</p>
                        </td>
                    </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

        <!-- Pagination -->
        <?php if($campaigns->hasPages()): ?>
        <div class="card-footer">
            <?php echo e($campaigns->links()); ?>

        </div>
        <?php endif; ?>
    </div>
</div>

<script>
function pauseCampaign(campaignId) {
    if (confirm('Are you sure you want to pause this campaign?')) {
        fetch(`/business/marketing/campaign/${campaignId}/pause`, {
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
                'Content-Type': 'application/json'
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                alert('Campaign paused successfully');
                location.reload();
            } else {
                alert('Error: ' + (data.message || 'Failed to pause campaign'));
            }
        })
        .catch(error => alert('Error: ' + error.message));
    }
}

function resumeCampaign(campaignId) {
    if (confirm('Are you sure you want to resume this campaign?')) {
        fetch(`/business/marketing/campaign/${campaignId}/resume`, {
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
                'Content-Type': 'application/json'
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                alert('Campaign resumed successfully');
                location.reload();
            } else {
                alert('Error: ' + (data.message || 'Failed to resume campaign'));
            }
        })
        .catch(error => alert('Error: ' + error.message));
    }
}

function deleteCampaign(campaignId) {
    if (confirm('Are you sure you want to delete this campaign? This cannot be undone.')) {
        fetch(`/business/marketing/campaign/${campaignId}`, {
            method: 'DELETE',
            headers: {
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
                'Content-Type': 'application/json'
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                alert('Campaign deleted successfully');
                location.reload();
            } else {
                alert('Error: ' + (data.message || 'Failed to delete campaign'));
            }
        })
        .catch(error => alert('Error: ' + error.message));
    }
}
</script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.business', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\privasee\resources\views/business/marketing/campaigns.blade.php ENDPATH**/ ?>