<?php $__env->startSection('title', 'Reject Venue'); ?>

<?php $__env->startSection('content'); ?>
<div class="mb-4">
    <a href="<?php echo e(route('admin.venues.show', $venue)); ?>" class="btn btn-outline-secondary btn-sm mb-3">
        <i class="bi bi-arrow-left me-2"></i>Back to Venue
    </a>
    <h2 class="fw-bold mb-1">Reject Venue</h2>
    <p class="text-muted mb-0">Provide rejection reason and checklist items</p>
</div>

<?php if($errors->any()): ?>
    <div class="alert alert-danger">
        <ul class="mb-0">
            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li><?php echo e($error); ?></li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>
    </div>
<?php endif; ?>

<div class="row g-4">
    <!-- Venue Information -->
    <div class="col-lg-8">
        <div class="card border-0 shadow-sm mb-4">
            <div class="card-header bg-light">
                <h5 class="mb-0 fw-bold">Venue Information</h5>
            </div>
            <div class="card-body">
                <div class="row g-3">
                    <div class="col-md-12">
                        <div class="d-flex align-items-center mb-3">
                            <?php if($venue->featured_image): ?>
                            <img src="<?php echo e(asset('storage/' . $venue->featured_image)); ?>"
                                 class="rounded me-3" width="80" height="80" style="object-fit: cover;">
                            <?php else: ?>
                            <i class="bi bi-geo-alt-fill" style="font-size: 3rem; color: #ccc;"></i>
                            <?php endif; ?>
                            <div>
                                <h4 class="mb-1"><?php echo e($venue->name); ?></h4>
                                <p class="text-muted mb-0">
                                    <i class="bi bi-building"></i> <?php echo e($venue->business->business_name); ?>

                                </p>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-6">
                        <label class="text-muted small">Address</label>
                        <div class="fw-semibold"><?php echo e($venue->address); ?></div>
                    </div>

                    <div class="col-md-6">
                        <label class="text-muted small">Phone</label>
                        <div class="fw-semibold"><?php echo e($venue->phone); ?></div>
                    </div>

                    <div class="col-md-6">
                        <label class="text-muted small">Email</label>
                        <div class="fw-semibold"><?php echo e($venue->email); ?></div>
                    </div>

                    <div class="col-md-6">
                        <label class="text-muted small">Status</label>
                        <div class="fw-semibold">
                            <span class="badge bg-<?php echo e($venue->status == 'active' ? 'success' : 'warning'); ?>">
                                <?php echo e(ucfirst($venue->status)); ?>

                            </span>
                        </div>
                    </div>

                    <div class="col-12">
                        <label class="text-muted small">Description</label>
                        <div class="bg-light p-3 rounded"><?php echo e($venue->description ?? 'No description provided'); ?></div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Rejection Form -->
    <div class="col-lg-4">
        <div class="card border-danger shadow-sm">
            <div class="card-header bg-danger text-white">
                <h5 class="mb-0 fw-bold">
                    <i class="bi bi-exclamation-circle"></i> Rejection Checklist
                </h5>
            </div>
            <div class="card-body">
                <form action="<?php echo e(route('admin.venues.reject', $venue)); ?>" method="POST">
                    <?php echo csrf_field(); ?>

                    <!-- Reason -->
                    <div class="mb-3">
                        <label class="form-label fw-semibold">Rejection Reason <span class="text-danger">*</span></label>
                        <textarea class="form-control <?php $__errorArgs = ['reason'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                  name="reason" rows="4" placeholder="Explain why this venue is being rejected..."
                                  required><?php echo e(old('reason')); ?></textarea>
                        <small class="text-muted">Minimum 10 characters required</small>
                        <?php $__errorArgs = ['reason'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <!-- Rejection Checklist -->
                    <div class="mb-4">
                        <label class="form-label fw-semibold">Rejection Reasons <span class="text-danger">*</span></label>
                        <small class="text-muted d-block mb-2">Select all reasons that apply:</small>

                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" name="checklist[]" value="name_missing" id="check1">
                            <label class="form-check-label" for="check1">
                                Venue Name Missing or Invalid
                            </label>
                        </div>

                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" name="checklist[]" value="address_missing" id="check2">
                            <label class="form-check-label" for="check2">
                                Address Missing or Incomplete
                            </label>
                        </div>

                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" name="checklist[]" value="contact_invalid" id="check3">
                            <label class="form-check-label" for="check3">
                                Contact Details Invalid
                            </label>
                        </div>

                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" name="checklist[]" value="description_insufficient" id="check4">
                            <label class="form-check-label" for="check4">
                                Venue Description Insufficient
                            </label>
                        </div>

                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" name="checklist[]" value="images_missing" id="check5">
                            <label class="form-check-label" for="check5">
                                Required Images Missing
                            </label>
                        </div>

                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" name="checklist[]" value="operating_hours" id="check6">
                            <label class="form-check-label" for="check6">
                                Operating Hours Not Provided
                            </label>
                        </div>

                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" name="checklist[]" value="amenities_missing" id="check7">
                            <label class="form-check-label" for="check7">
                                Amenities Not Specified
                            </label>
                        </div>

                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" name="checklist[]" value="compliance" id="check8">
                            <label class="form-check-label" for="check8">
                                Does Not Meet Compliance Requirements
                            </label>
                        </div>
                    </div>

                    <!-- Action Buttons -->
                    <div class="d-grid gap-2">
                        <button type="submit" class="btn btn-danger">
                            <i class="bi bi-x-circle"></i> Reject Venue
                        </button>
                        <a href="<?php echo e(route('admin.venues.show', $venue)); ?>" class="btn btn-secondary">
                            Cancel
                        </a>
                    </div>
                </form>
            </div>
        </div>

        <!-- Info Alert -->
        <div class="alert alert-info mt-3">
            <small>
                <i class="bi bi-info-circle"></i>
                The business owner will be notified with the rejection reason and checklist.
            </small>
        </div>
    </div>
</div>

<script>
    // Prevent submission if no checklist items selected
    document.querySelector('form').addEventListener('submit', function(e) {
        const checkedItems = document.querySelectorAll('input[name="checklist[]"]:checked');
        if (checkedItems.length === 0) {
            e.preventDefault();
            alert('Please select at least one rejection reason');
        }
    });
</script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\privasee\resources\views/admin/venues/reject.blade.php ENDPATH**/ ?>