

<?php $__env->startSection('title', 'Edit Staff'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid py-4">
    <!-- Header -->
    <div class="row mb-4">
        <div class="col-md-12">
            <h1 class="h3 mb-0">Edit Staff Member</h1>
            <p class="text-muted">Update staff member role and team assignment</p>
        </div>
    </div>

    <div class="row">
        <div class="col-md-8">
            <div class="card">
                <div class="card-body">
                    <form action="<?php echo e(route('business.staff.update', [$business, $staff])); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('PUT'); ?>

                        <div class="mb-3">
                            <label for="role" class="form-label">Role *</label>
                            <select class="form-select <?php $__errorArgs = ['role'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                id="role" name="role" required>
                                <option value="">Select Role</option>
                                <option value="owner" <?php echo e(old('role', $staff->role) === 'owner' ? 'selected' : ''); ?>>Owner</option>
                                <option value="manager" <?php echo e(old('role', $staff->role) === 'manager' ? 'selected' : ''); ?>>Manager</option>
                                <option value="staff" <?php echo e(old('role', $staff->role) === 'staff' ? 'selected' : ''); ?>>Staff</option>
                            </select>
                            <?php $__errorArgs = ['role'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="mb-3">
                            <label for="team_id" class="form-label">Team Assignment (Optional)</label>
                            <select class="form-select <?php $__errorArgs = ['team_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                id="team_id" name="team_id">
                                <option value="">No Team</option>
                                <?php $__currentLoopData = $teams; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $team): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($team->id); ?>" <?php echo e(old('team_id', $staff->team_id) == $team->id ? 'selected' : ''); ?>>
                                        <?php echo e($team->name); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <?php $__errorArgs = ['team_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="d-flex gap-2">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save"></i> Update Staff Member
                            </button>
                            <a href="<?php echo e(route('business.staff.index', $business)); ?>" class="btn btn-secondary">
                                <i class="fas fa-times"></i> Cancel
                            </a>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <div class="col-md-4">
            <div class="card">
                <div class="card-header">
                    <h6 class="mb-0">Staff Information</h6>
                </div>
                <div class="card-body">
                    <?php if($staff->user): ?>
                        <p class="mb-2"><strong>Name:</strong> <?php echo e($staff->user->first_name); ?> <?php echo e($staff->user->last_name); ?></p>
                        <p class="mb-2"><strong>Email:</strong> <?php echo e($staff->user->email); ?></p>
                    <?php else: ?>
                        <p class="mb-2"><strong>Email:</strong> <?php echo e($staff->email ?? 'Pending'); ?></p>
                        <p class="mb-2"><strong>Status:</strong> <span class="badge bg-warning">Pending Invitation</span></p>
                    <?php endif; ?>
                    <p class="mb-2"><strong>Current Role:</strong> <span class="badge bg-primary"><?php echo e(ucfirst($staff->role)); ?></span></p>
                    <?php if($staff->user): ?>
                    <p class="mb-2"><strong>Status:</strong> <span class="badge bg-<?php echo e($staff->status === 'active' ? 'success' : 'warning'); ?>"><?php echo e(ucfirst(str_replace('_', ' ', $staff->status))); ?></span></p>
                    <p class="mb-0"><strong>Created:</strong> <?php echo e($staff->created_at->format('M d, Y')); ?></p>
                    <?php else: ?>
                    <p class="mb-2"><strong>Invited:</strong> <?php echo e($staff->invited_at ? $staff->invited_at->format('M d, Y') : 'N/A'); ?></p>
                    <p class="mb-0"><strong>Attempts:</strong> <?php echo e($staff->verification_attempts ?? 0); ?>/3</p>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\privasee\resources\views/business/staff/edit.blade.php ENDPATH**/ ?>