<?php $__env->startSection('title', 'Offers Management'); ?>

<?php $__env->startSection('content'); ?>
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h2 class="fw-bold mb-1">Offers Management</h2>
            <p class="text-muted mb-0">Manage and moderate business offers</p>
        </div>
    </div>

    <!-- Stats -->
    <div class="row g-3 mb-4">
        <div class="col-md-3">
            <div class="stat-card">
                <div class="stat-label">Total Offers</div>
                <div class="stat-value"><?php echo e(number_format($stats['total'] ?? 0)); ?></div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="stat-card">
                <div class="stat-label">Active Offers</div>
                <div class="stat-value text-success"><?php echo e(number_format($stats['active'] ?? 0)); ?></div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="stat-card">
                <div class="stat-label">Expired Offers</div>
                <div class="stat-value text-danger"><?php echo e(number_format($stats['expired'] ?? 0)); ?></div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="stat-card">
                <div class="stat-label">Total Redemptions</div>
                <div class="stat-value text-primary"><?php echo e(number_format($stats['redemptions'] ?? 0)); ?></div>
            </div>
        </div>
    </div>

    <!-- Offers Table -->
    <div class="admin-card">
        <div class="admin-card-header">
            <h5 class="mb-0 fw-bold">All Offers (<?php echo e($offers->total()); ?>)</h5>
        </div>
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover mb-0">
                    <thead>
                    <tr>
                        <th>Offer</th>
                        <th>Business</th>
                        <th>Venue</th>
                        <th>Discount</th>
                        <th>Status</th>
                        <th>Valid Until</th>
                        <th>Redemptions</th>
                        <th>Actions</th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $offers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $offer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td>
                                <div class="fw-semibold"><?php echo e($offer->title); ?></div>
                                <small class="text-muted"><?php echo e(Str::limit($offer->description ?? '', 40)); ?></small>
                            </td>
                            <td><?php echo e($offer->business->business_name ?? 'N/A'); ?></td>
                            <td><?php echo e($offer->venue->name ?? 'All Venues'); ?></td>
                            <td>
                                <strong class="text-primary">
                                    <?php if($offer->discount_type === 'percentage'): ?>
                                        <?php echo e($offer->discount_value); ?>%
                                    <?php else: ?>
                                        AED <?php echo e(number_format($offer->discount_value, 2)); ?>

                                    <?php endif; ?>
                                </strong>
                            </td>
                            <td>
                            <span class="badge bg-<?php echo e($offer->status === 'active' ? 'success' : ($offer->status === 'inactive' ? 'danger' : 'warning')); ?>">
                                <?php echo e(ucfirst($offer->status)); ?>

                            </span>
                            </td>
                            <td><?php echo e($offer->end_date ? $offer->end_date->format('M d, Y') : 'No expiry'); ?></td>
                            <td><?php echo e(number_format($offer->redemptions_count ?? 0)); ?> / <?php echo e($offer->max_redemptions ?? '∞'); ?></td>
                            <td>
                                <a href="<?php echo e(route('admin.offers.show', $offer->id)); ?>" class="btn btn-sm btn-outline-primary">
                                    <i class="bi bi-eye"></i>
                                </a>

                                <a href="<?php echo e(route('admin.offers.edit', $offer->id)); ?>" class="btn btn-sm btn-outline-secondary">
                                    <i class="bi bi-pencil"></i>
                                </a>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="8" class="text-center text-muted py-4">
                                <i class="bi bi-inbox fs-1 d-block mb-2"></i>
                                No offers found
                            </td>
                        </tr>
                    <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
        <?php if($offers->hasPages()): ?>
            <div class="admin-card-footer">
                <?php echo e($offers->links()); ?>

            </div>
        <?php endif; ?>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\privasee\resources\views/admin/offers/index.blade.php ENDPATH**/ ?>