<?php $__env->startSection('title', 'Checkout - ' . $plan->name); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid py-4">
    <!-- Header -->
    <div class="row mb-5">
        <div class="col-md-8">
            <h1 class="h2 fw-bold mb-0">
                <i class="fas fa-shopping-cart me-2"></i>Checkout
            </h1>
            <p class="text-muted">Complete your subscription purchase</p>
        </div>
    </div>

    <div class="row">
        <!-- Order Summary -->
        <div class="col-lg-8 mb-4">
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-light py-3">
                    <h5 class="mb-0 fw-bold">Order Summary</h5>
                </div>
                <div class="card-body p-4">
                    <!-- Plan Details -->
                    <div class="row mb-4 pb-4 border-bottom">
                        <div class="col-md-6">
                            <h6 class="fw-bold mb-2"><?php echo e($plan->name); ?></h6>
                            <p class="text-muted small mb-0"><?php echo e($plan->description ?? 'Premium subscription plan'); ?></p>
                        </div>
                        <div class="col-md-6 text-md-end">
                            <?php if($plan->price > 0): ?>
                            <h6 class="fw-bold mb-2">AED <?php echo e(number_format($plan->price, 2)); ?>/month</h6>
                            <p class="text-muted small mb-0">Billed monthly</p>
                            <?php else: ?>
                            <h6 class="fw-bold mb-2 text-success">FREE</h6>
                            <p class="text-muted small mb-0">No charge</p>
                            <?php endif; ?>
                        </div>
                    </div>

                    <!-- Features -->
                    <div class="mb-4">
                        <h6 class="fw-bold mb-3">What's Included:</h6>
                        <ul class="list-unstyled">
                            <?php if($plan->max_venues): ?>
                            <li class="mb-2">
                                <i class="fas fa-check text-success me-2"></i>
                                <strong><?php echo e($plan->max_venues == -1 ? 'Unlimited' : $plan->max_venues); ?></strong>
                                <?php echo e($plan->max_venues == 1 ? 'Venue' : 'Venues'); ?>

                            </li>
                            <?php endif; ?>
                            <?php if($plan->max_offers): ?>
                            <li class="mb-2">
                                <i class="fas fa-check text-success me-2"></i>
                                <strong><?php echo e($plan->max_offers == -1 ? 'Unlimited' : $plan->max_offers); ?></strong>
                                <?php echo e($plan->max_offers == 1 ? 'Offer' : 'Offers'); ?>

                            </li>
                            <?php endif; ?>
                            <?php if($plan->max_staff): ?>
                            <li class="mb-2">
                                <i class="fas fa-check text-success me-2"></i>
                                <strong><?php echo e($plan->max_staff == -1 ? 'Unlimited' : $plan->max_staff); ?></strong>
                                <?php echo e($plan->max_staff == 1 ? 'Staff Member' : 'Staff Members'); ?>

                            </li>
                            <?php endif; ?>
                            <?php if($plan->monthly_campaigns): ?>
                            <li class="mb-2">
                                <i class="fas fa-check text-success me-2"></i>
                                <strong><?php echo e($plan->monthly_campaigns == -1 ? 'Unlimited' : $plan->monthly_campaigns); ?></strong>
                                Campaign(s) per Month
                            </li>
                            <?php endif; ?>
                            <?php if($plan->analytics_access): ?>
                            <li class="mb-2">
                                <i class="fas fa-check text-success me-2"></i>
                                Advanced Analytics
                            </li>
                            <?php endif; ?>
                            <?php if($plan->priority_support): ?>
                            <li class="mb-0">
                                <i class="fas fa-check text-success me-2"></i>
                                Priority Support 24/7
                            </li>
                            <?php endif; ?>
                        </ul>
                    </div>

                    <!-- Business Info -->
                    <div class="mb-4 pb-4 border-bottom">
                        <h6 class="fw-bold mb-3">Business Information</h6>
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <p class="text-muted small mb-1">Business Name</p>
                                <p class="fw-bold mb-0"><?php echo e($business->business_name); ?></p>
                            </div>
                            <div class="col-md-6 mb-3">
                                <p class="text-muted small mb-1">Email</p>
                                <p class="fw-bold mb-0"><?php echo e($business->email); ?></p>
                            </div>
                            <div class="col-md-6">
                                <p class="text-muted small mb-1">Phone</p>
                                <p class="fw-bold mb-0"><?php echo e($business->phone); ?></p>
                            </div>
                        </div>
                    </div>

                    <!-- Terms -->
                    <div class="form-check mb-4">
                        <input class="form-check-input" type="checkbox" id="agreeTerms" required>
                        <label class="form-check-label" for="agreeTerms">
                            I agree to the <a href="#" target="_blank">Terms of Service</a> and <a href="#" target="_blank">Privacy Policy</a>
                        </label>
                    </div>
                </div>
            </div>
        </div>

        <!-- Payment Summary Sidebar -->
        <div class="col-lg-4">
            <div class="card border-0 shadow-sm sticky-top" style="top: 20px;">
                <div class="card-header bg-light py-3">
                    <h5 class="mb-0 fw-bold">Payment Summary</h5>
                </div>
                <div class="card-body p-4">
                    <!-- Price Breakdown -->
                    <div class="row mb-3">
                        <div class="col-6">
                            <p class="text-muted small mb-0">Monthly Price</p>
                        </div>
                        <div class="col-6 text-end">
                            <?php if($plan->price > 0): ?>
                            <p class="fw-bold mb-0">AED <?php echo e(number_format($plan->price, 2)); ?></p>
                            <?php else: ?>
                            <p class="fw-bold mb-0 text-success">FREE</p>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="row mb-3">
                        <div class="col-6">
                            <p class="text-muted small mb-0">Billing Cycle</p>
                        </div>
                        <div class="col-6 text-end">
                            <?php if($plan->price > 0): ?>
                            <p class="fw-bold mb-0">Monthly</p>
                            <?php else: ?>
                            <p class="fw-bold mb-0"><?php echo e($plan->duration_days ?? 30); ?> Days</p>
                            <?php endif; ?>
                        </div>
                    </div>

                    <hr>

                    <!-- Total -->
                    <div class="row mb-4">
                        <div class="col-6">
                            <p class="fw-bold mb-0">Total</p>
                        </div>
                        <div class="col-6 text-end">
                            <?php if($plan->price > 0): ?>
                            <h5 class="fw-bold mb-0">AED <?php echo e(number_format($plan->price, 2)); ?></h5>
                            <?php else: ?>
                            <h5 class="fw-bold mb-0 text-success">FREE</h5>
                            <?php endif; ?>
                        </div>
                    </div>

                    <!-- Proceed Button -->
                    <?php if($plan->price > 0): ?>
                    <button class="btn btn-success btn-lg w-100 mb-3" onclick="proceedToPayment(<?php echo e($plan->id); ?>)">
                        <i class="fas fa-lock me-2"></i>Proceed to Payment
                    </button>
                    <?php else: ?>
                    <button class="btn btn-success btn-lg w-100 mb-3" onclick="activateFreeplan(<?php echo e($plan->id); ?>)">
                        <i class="fas fa-check me-2"></i>Activate Plan
                    </button>
                    <?php endif; ?>

                    <!-- Cancel Link -->
                    <a href="<?php echo e(route('business.subscription.index')); ?>" class="btn btn-outline-secondary w-100">
                        <i class="fas fa-arrow-left me-2"></i>Back to Subscription
                    </a>

                    <!-- Info Box -->
                    <div class="alert alert-info mt-4 mb-0">
                        <small>
                            <i class="fas fa-info-circle me-2"></i>
                            <?php if($plan->price > 0): ?>
                            You can cancel your subscription anytime. Auto-renewal is enabled by default.
                            <?php else: ?>
                            Your free plan is valid for <?php echo e($plan->duration_days ?? 30); ?> days.
                            <?php endif; ?>
                        </small>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
function proceedToPayment(planId) {
    // Validate terms agreement
    if (!document.getElementById('agreeTerms').checked) {
        alert('Please agree to the terms and conditions');
        return;
    }

    // For now, show a success message
    // In production, integrate with Stripe/PayPal
    alert('Payment integration coming soon!\n\nYour subscription to ' + '<?php echo e($plan->name); ?>' + ' will be activated.');

    // Redirect to subscription page
    window.location.href = '<?php echo e(route("business.subscription.index")); ?>';
}

function activateFreeplan(planId) {
    // Validate terms agreement
    if (!document.getElementById('agreeTerms').checked) {
        alert('Please agree to the terms and conditions');
        return;
    }

    // For free plans, redirect back to subscription index
    // The free plan activation is already handled in the upgrade() method
    window.location.href = '<?php echo e(route("business.subscription.index")); ?>';
}
</script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.business', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\privasee\resources\views/business/subscription/checkout.blade.php ENDPATH**/ ?>