<?php $__env->startSection('title', 'Create Banner Campaign'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <!-- Header -->
    <div class="row mb-4">
        <div class="col-md-8">
            <h1 class="h3 mb-0">Create Banner Campaign</h1>
            <p class="text-muted">Create a new banner campaign to display in the app</p>
        </div>
        <div class="col-md-4 text-end">
            <a href="<?php echo e(route('admin.marketing.campaigns')); ?>" class="btn btn-secondary">
                <i class="fas fa-arrow-left"></i> Back to Campaigns
            </a>
        </div>
    </div>

    <div class="row">
        <div class="col-md-8">
            <div class="card">
                <div class="card-body">
                    <!-- Info Alert -->
                    <div class="alert alert-info mb-4">
                        <i class="fas fa-lightbulb"></i>
                        <strong>Banner Campaign:</strong> Create promotional banners to display in the mobile app and web platform
                    </div>

                    <form id="campaignForm">
                        <?php echo csrf_field(); ?>

                        <!-- Business Selection -->
                        <div class="mb-3">
                            <label class="form-label" for="business_id">Business <span class="text-danger">*</span></label>
                            <select class="form-select" id="business_id" name="business_id" required>
                                <option value="">Select Business</option>
                                <?php $__currentLoopData = $businesses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $business): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($business->id); ?>"><?php echo e($business->name); ?> (<?php echo e($business->email); ?>)</option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <small class="text-muted">Select the business to run this banner campaign</small>
                        </div>

                        <!-- Banner Title -->
                        <div class="mb-3">
                            <label class="form-label" for="name">Banner Title <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" id="name" name="name" placeholder="e.g. Summer Sale 50% Off" required>
                            <small class="text-muted">The main heading displayed on the banner</small>
                        </div>

                        <!-- Banner Description -->
                        <div class="mb-3">
                            <label class="form-label" for="description">Banner Description</label>
                            <textarea class="form-control" id="description" name="description" rows="3" placeholder="e.g. Limited time offer! Get 50% discount on all items"></textarea>
                            <small class="text-muted">Additional text to display on the banner</small>
                        </div>

                        <!-- Campaign Type (Fixed to Banner) -->
                        <div class="mb-3">
                            <label class="form-label" for="type">Campaign Type <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" id="type" name="type" value="banner" readonly>
                            <small class="text-muted">This campaign will display as a banner in the app</small>
                        </div>

                        <!-- Banner Image Upload -->
                        <div class="mb-3">
                            <label class="form-label" for="banner_image">Banner Image (Optional)</label>
                            <input type="file" class="form-control" id="banner_image" name="banner_image" accept="image/*">
                            <small class="text-muted">Recommended size: 1200x300px (landscape for better display in app)</small>
                            <div id="imagePreview" class="mt-2"></div>
                        </div>

                        <!-- Targeting -->
                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label" for="venue_id">Target Venue (Optional)</label>
                                    <select class="form-select" id="venue_id" name="venue_id">
                                        <option value="">Show to all venues</option>
                                        <?php $__currentLoopData = $venues; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $venue): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($venue->id); ?>"><?php echo e($venue->name); ?> (<?php echo e($venue->business->name ?? 'N/A'); ?>)</option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <small class="text-muted">Leave empty to show banner to all</small>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label" for="offer_id">Target Offer (Optional)</label>
                                    <select class="form-select" id="offer_id" name="offer_id">
                                        <option value="">Show to all offers</option>
                                        <?php $__currentLoopData = $offers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $offer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($offer->id); ?>"><?php echo e($offer->name); ?> (<?php echo e($offer->venue->name ?? 'N/A'); ?>)</option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <small class="text-muted">Leave empty to show banner to all</small>
                                </div>
                            </div>
                        </div>

                        <!-- Campaign Duration -->
                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label" for="start_date">Start Date <span class="text-danger">*</span></label>
                                    <input type="date" class="form-control" id="start_date" name="start_date" required>
                                    <small class="text-muted">Banner will appear on this date</small>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label" for="end_date">End Date <span class="text-danger">*</span></label>
                                    <input type="date" class="form-control" id="end_date" name="end_date" required>
                                    <small class="text-muted">Banner will stop appearing on this date</small>
                                </div>
                            </div>
                        </div>

                        <!-- Budget -->
                        <div class="mb-3">
                            <label class="form-label" for="budget">Campaign Budget (AED) <span class="text-danger">*</span></label>
                            <input type="number" class="form-control" id="budget" name="budget" step="0.01" min="0" placeholder="0.00" required>
                            <small class="text-muted">Total budget allocated for this banner campaign</small>
                        </div>

                        <!-- Submit Buttons -->
                        <div class="d-flex gap-2">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save"></i> Create Banner Campaign
                            </button>
                            <a href="<?php echo e(route('admin.marketing.campaigns')); ?>" class="btn btn-secondary">
                                <i class="fas fa-times"></i> Cancel
                            </a>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <div class="col-md-4">
            <!-- Campaign Summary -->
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0"><i class="fas fa-banner"></i> Campaign Summary</h5>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <p class="text-muted mb-1">Campaign Type</p>
                        <h6><span class="badge bg-primary">Banner</span></h6>
                    </div>

                    <div class="mb-3">
                        <p class="text-muted mb-1">Display Duration</p>
                        <h6 id="summary-duration">-</h6>
                    </div>

                    <div class="mb-3">
                        <p class="text-muted mb-1">Total Budget</p>
                        <h5 id="summary-budget">AED 0.00</h5>
                    </div>

                    <hr>

                    <div class="alert alert-info">
                        <i class="fas fa-info-circle"></i>
                        <small><strong>How it works:</strong> Once created, the banner will automatically display in the app during the campaign period. Users will see the banner on the home screen and throughout the app.</small>
                    </div>

                    <div class="alert alert-warning">
                        <i class="fas fa-clock"></i>
                        <small><strong>Auto-approved:</strong> Campaigns created by admin are automatically approved and will start displaying at the scheduled time.</small>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
document.getElementById('campaignForm').addEventListener('submit', function(e) {
    e.preventDefault();

    const formData = new FormData(this);

    fetch('<?php echo e(route("admin.marketing.campaigns.store")); ?>', {
        method: 'POST',
        headers: {
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
        },
        body: formData
    })
    .then(response => response.json())
    .then(result => {
        if (result.success) {
            alert('Banner campaign created successfully!');
            window.location.href = '<?php echo e(route("admin.marketing.campaigns")); ?>';
        } else {
            alert('Error: ' + (result.message || 'Failed to create campaign'));
        }
    })
    .catch(error => alert('Error: ' + error.message));
});

// Image preview
document.getElementById('banner_image').addEventListener('change', function(e) {
    const file = e.target.files[0];
    if (file) {
        const reader = new FileReader();
        reader.onload = function(event) {
            const preview = document.getElementById('imagePreview');
            preview.innerHTML = '<img src="' + event.target.result + '" class="img-thumbnail" style="max-height: 200px;">';
        };
        reader.readAsDataURL(file);
    }
});

// Update summary on date change
document.getElementById('start_date').addEventListener('change', updateDurationSummary);
document.getElementById('end_date').addEventListener('change', updateDurationSummary);
document.getElementById('budget').addEventListener('change', updateBudgetSummary);

function updateDurationSummary() {
    const startDate = document.getElementById('start_date').value;
    const endDate = document.getElementById('end_date').value;

    if (startDate && endDate) {
        const start = new Date(startDate);
        const end = new Date(endDate);
        const days = Math.ceil((end - start) / (1000 * 60 * 60 * 24));
        document.getElementById('summary-duration').textContent = `${days} days`;
    }
}

function updateBudgetSummary() {
    const budget = parseFloat(document.getElementById('budget').value) || 0;
    document.getElementById('summary-budget').textContent = 'AED ' + budget.toFixed(2);
}
</script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\privasee\resources\views/admin/marketing/create-campaign.blade.php ENDPATH**/ ?>