<?php $__env->startSection('title', 'Stripe Checkout - ' . $plan->name); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid py-4">
    <!-- Header -->
    <div class="row mb-5">
        <div class="col-md-8">
            <h1 class="h2 fw-bold mb-0">
                <i class="fas fa-lock me-2"></i>Secure Payment
            </h1>
            <p class="text-muted">Redirecting to Stripe Checkout...</p>
        </div>
    </div>

    <div class="row">
        <!-- Payment Loading -->
        <div class="col-lg-8 mb-4">
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-primary text-white py-3 border-0">
                    <h5 class="mb-0 fw-bold">
                        <i class="fab fa-cc-stripe me-2"></i>Stripe Checkout
                    </h5>
                </div>
                <div class="card-body p-4">
                    <div class="text-center">
                        <div class="spinner-border text-primary mb-3" role="status">
                            <span class="visually-hidden">Loading...</span>
                        </div>
                        <p class="text-muted">Preparing your secure payment page...</p>
                        <p class="text-muted small">You will be redirected to Stripe Checkout automatically.</p>

                        <!-- Manual redirect button if auto-redirect fails -->
                        <button onclick="redirectToCheckout()" class="btn btn-primary mt-3">
                            <i class="fas fa-arrow-right me-2"></i>Click here if not redirected
                        </button>
                    </div>
                </div>
            </div>

            <!-- Security Info -->
            <div class="alert alert-info mt-4">
                <i class="fas fa-shield-alt me-2"></i>
                <strong>Secure Payment:</strong> You will be redirected to Stripe's secure hosted checkout page. Your payment information is encrypted and secure.
            </div>
        </div>

        <!-- Order Summary Sidebar -->
        <div class="col-lg-4">
            <div class="card border-0 shadow-sm sticky-top" style="top: 20px;">
                <div class="card-header bg-light py-3 border-bottom">
                    <h5 class="mb-0 fw-bold">
                        <i class="fas fa-receipt me-2 text-primary"></i>Order Summary
                    </h5>
                </div>
                <div class="card-body p-4">
                    <!-- Plan Details -->
                    <div class="mb-3">
                        <p class="text-muted small mb-1">Plan</p>
                        <p class="fw-bold mb-0"><?php echo e($plan->name); ?></p>
                    </div>

                    <div class="mb-3">
                        <p class="text-muted small mb-1">Description</p>
                        <p class="small mb-0"><?php echo e($plan->description ?? 'Premium subscription plan'); ?></p>
                    </div>

                    <div class="mb-3 pb-3 border-bottom">
                        <p class="text-muted small mb-1">Business</p>
                        <p class="fw-bold mb-0"><?php echo e($business->business_name); ?></p>
                    </div>

                    <!-- Price -->
                    <div class="row mb-3">
                        <div class="col-6">
                            <p class="text-muted small mb-0">Price</p>
                        </div>
                        <div class="col-6 text-end">
                            <p class="fw-bold mb-0">AED <?php echo e(number_format($plan->price, 2)); ?></p>
                        </div>
                    </div>

                    <div class="row mb-3 pb-3 border-bottom">
                        <div class="col-6">
                            <p class="text-muted small mb-0">Billing Cycle</p>
                        </div>
                        <div class="col-6 text-end">
                            <p class="fw-bold mb-0">Monthly</p>
                        </div>
                    </div>

                    <!-- Total -->
                    <div class="row">
                        <div class="col-6">
                            <p class="fw-bold mb-0">Total Amount</p>
                        </div>
                        <div class="col-6 text-end">
                            <h4 class="fw-bold mb-0 text-primary">AED <?php echo e(number_format($plan->price, 2)); ?></h4>
                        </div>
                    </div>

                    <!-- Features -->
                    <div class="mt-4 pt-4 border-top">
                        <p class="fw-bold small mb-2">What's Included:</p>
                        <ul class="list-unstyled small">
                            <?php if($plan->max_venues): ?>
                            <li class="mb-1"><i class="fas fa-check text-success me-2"></i><?php echo e($plan->max_venues == -1 ? 'Unlimited' : $plan->max_venues); ?> Venue(s)</li>
                            <?php endif; ?>
                            <?php if($plan->max_offers): ?>
                            <li class="mb-1"><i class="fas fa-check text-success me-2"></i><?php echo e($plan->max_offers == -1 ? 'Unlimited' : $plan->max_offers); ?> Offer(s)</li>
                            <?php endif; ?>
                            <?php if($plan->max_staff): ?>
                            <li class="mb-1"><i class="fas fa-check text-success me-2"></i><?php echo e($plan->max_staff == -1 ? 'Unlimited' : $plan->max_staff); ?> Staff Member(s)</li>
                            <?php endif; ?>
                        </ul>
                    </div>
                </div>

                <div class="card-footer bg-light border-top p-3">
                    <small class="text-muted">
                        <i class="fas fa-info-circle me-1"></i>
                        Your subscription will auto-renew on <?php echo e(now()->addDays($plan->duration_days ?? 30)->format('M d, Y')); ?>. You can cancel anytime.
                    </small>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Stripe Script - Load FIRST -->
<script src="https://js.stripe.com/v3/"></script>

<script>
// Store session ID for redirect verification
const stripeSessionId = '<?php echo e($session->id); ?>';
// Get from config

// get from env
const stripePublicKey = '<?php echo e(env("STRIPE_KEY")); ?>';

// Redirect to Stripe Checkout
function redirectToCheckout() {
    // Initialize Stripe with public key
    const stripe = Stripe(stripePublicKey);

    // Redirect to checkout session
    stripe.redirectToCheckout({
        sessionId: stripeSessionId
    }).then(function(result) {
        if (result.error) {
            alert('Error: ' + result.error.message);
            console.error('Stripe redirect error:', result.error);
        }
    });
}

// Auto-redirect on page load after a short delay to ensure Stripe is loaded
document.addEventListener('DOMContentLoaded', function() {
    // Wait 1 second for Stripe to load properly
    setTimeout(function() {
        redirectToCheckout();
    }, 1000);
});
</script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.business', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\privasee\resources\views/payment/stripe-checkout.blade.php ENDPATH**/ ?>