<?php $__env->startSection('content'); ?>
<div class="container mt-4">
    <div class="row mb-4">
        <div class="col">
            <h1>Chat</h1>
            <p class="text-muted">Communicate with your team members</p>
        </div>
        <div class="col-auto">
            <a href="<?php echo e(route('business.chats.create')); ?>" class="btn btn-primary">
                <i class="bi bi-plus-circle"></i> New Chat
            </a>
        </div>
    </div>

    <?php if($chats->count() > 0): ?>
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="list-group list-group-flush">
                        <?php $__currentLoopData = $chats; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $chat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <a href="<?php echo e(route('business.chats.show', $chat)); ?>" class="list-group-item list-group-item-action <?php echo e(!$chat->is_active ? 'disabled opacity-50' : ''); ?>">
                                <div class="d-flex w-100 justify-content-between align-items-start">
                                    <div class="flex-grow-1">
                                        <h6 class="mb-1">
                                            <?php if($chat->type === 'group'): ?>
                                                <i class="bi bi-people-fill"></i>
                                            <?php else: ?>
                                                <i class="bi bi-person-circle"></i>
                                            <?php endif; ?>
                                            <?php echo e($chat->subject); ?>

                                            <?php if(!$chat->is_active): ?>
                                            <span class="badge bg-danger">Disabled</span>
                                            <?php endif; ?>
                                        </h6>
                                        <p class="mb-1 text-muted small">
                                            <?php if($chat->messages->count() > 0): ?>
                                                <?php echo e(Str::limit($chat->messages->first()->content, 60)); ?>

                                            <?php else: ?>
                                                No messages yet
                                            <?php endif; ?>
                                        </p>
                                        <small class="text-muted">
                                            <?php echo e($chat->participants->count()); ?> participant<?php echo e($chat->participants->count() !== 1 ? 's' : ''); ?>

                                        </small>
                                    </div>
                                    <div class="text-end">
                                        <small class="text-muted"><?php echo e($chat->updated_at->diffForHumans()); ?></small>
                                    </div>
                                </div>
                            </a>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>

                <!-- Pagination -->
                <div class="mt-4">
                    <?php echo e($chats->links()); ?>

                </div>
            </div>
        </div>
    <?php else: ?>
        <div class="row">
            <div class="col">
                <div class="alert alert-info text-center">
                    <i class="bi bi-chat-left-text" style="font-size: 3rem;"></i>
                    <h4 class="mt-3">No chats yet</h4>
                    <p class="text-muted mb-3">Start a conversation with your team members</p>
                    <a href="<?php echo e(route('business.chats.create')); ?>" class="btn btn-primary">
                        <i class="bi bi-plus-circle"></i> Create New Chat
                    </a>
                </div>
            </div>
        </div>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.business', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\privasee\resources\views/business/chats/index.blade.php ENDPATH**/ ?>