<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class CheckRole
{
    /**
     * Handle an incoming request.
     */
    public function handle(Request $request, Closure $next, string ...$roles): Response
    {
        if (!auth()->check()) {
            return response()->json([
                'success' => false,
                'message' => 'Unauthenticated',
            ], 401);
        }

        $businessId = $request->route('business_id') ?? $request->input('business_id');

        if (!auth()->user()->hasAnyRole($roles, $businessId)) {
            return response()->json([
                'success' => false,
                'message' => 'Unauthorized. You do not have the required role.',
                'required_roles' => $roles,
            ], 403);
        }

        return $next($request);
    }
}
