<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class NotificationPreference extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'email_enabled',
        'sms_enabled',
        'push_enabled',
        'account_notifications',
        'offer_new_notifications',
        'offer_update_notifications',
        'offer_exclusive_notifications',
        'redemption_notifications',
        'subscription_notifications',
        'spotlight_notifications',
        'system_notifications',
        'marketing_notifications',
    ];

    protected $casts = [
        'email_enabled' => 'boolean',
        'sms_enabled' => 'boolean',
        'push_enabled' => 'boolean',
        'account_notifications' => 'boolean',
        'offer_new_notifications' => 'boolean',
        'offer_update_notifications' => 'boolean',
        'offer_exclusive_notifications' => 'boolean',
        'redemption_notifications' => 'boolean',
        'subscription_notifications' => 'boolean',
        'spotlight_notifications' => 'boolean',
        'system_notifications' => 'boolean',
        'marketing_notifications' => 'boolean',
    ];

    /**
     * User relationship
     */
    public function user()
    {
        return $this->belongsTo(User::class);
    }

    /**
     * Check if user wants notifications for a specific category via a specific channel
     */
    public function wantsNotification(string $category, string $channel): bool
    {
        $channelEnabled = $this->{$channel . '_enabled'} ?? false;
        $categoryEnabled = $this->{$category . '_notifications'} ?? false;

        return $channelEnabled && $categoryEnabled;
    }

    /**
     * Get all enabled categories
     */
    public function getEnabledCategories(): array
    {
        $categories = [
            'account',
            'offer_new',
            'offer_update',
            'offer_exclusive',
            'redemption',
            'subscription',
            'spotlight',
            'system',
            'marketing',
        ];

        return array_filter($categories, function ($category) {
            return $this->{$category . '_notifications'};
        });
    }

    /**
     * Get all enabled channels
     */
    public function getEnabledChannels(): array
    {
        $channels = [];

        if ($this->email_enabled) {
            $channels[] = 'email';
        }
        if ($this->sms_enabled) {
            $channels[] = 'sms';
        }
        if ($this->push_enabled) {
            $channels[] = 'push';
        }

        return $channels;
    }
}
