<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SocialAccount extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'provider',
        'provider_id',
        'provider_token',
        'provider_refresh_token',
        'provider_token_expires_at',
        'avatar',
        'email',
        'name',
    ];

    protected $hidden = [
        'provider_token',
        'provider_refresh_token',
    ];

    protected $casts = [
        'provider_token_expires_at' => 'datetime',
    ];

    /**
     * User relationship
     */
    public function user()
    {
        return $this->belongsTo(User::class);
    }

    /**
     * Check if token is expired
     */
    public function isTokenExpired()
    {
        if (!$this->provider_token_expires_at) {
            return false;
        }

        return $this->provider_token_expires_at->isPast();
    }

    /**
     * Scope for specific provider
     */
    public function scopeProvider($query, $provider)
    {
        return $query->where('provider', $provider);
    }
}
